/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsonapt;

import cn.wjybxx.apt.AbstractGenerator;
import cn.wjybxx.apt.AptUtils;
import cn.wjybxx.apt.MyAbstractProcessor;
import cn.wjybxx.dsonapt.AptFieldProps;
import cn.wjybxx.dsonapt.AptTypeInfo;
import cn.wjybxx.dsonapt.CodecProcessor;
import cn.wjybxx.dsonapt.Context;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

class SchemaGenerator
extends AbstractGenerator<CodecProcessor> {
    private final Context context;
    private final ClassName typeInfoRawTypeName;

    public SchemaGenerator(CodecProcessor processor, Context context) {
        super((MyAbstractProcessor)processor, context.typeElement);
        this.context = context;
        this.typeInfoRawTypeName = processor.typeName_TypeInfo;
    }

    public void execute() {
        List<VariableElement> allSerialFields = this.context.serialFields;
        ArrayList<AptTypeInfo> allAptTypeInfos = new ArrayList<AptTypeInfo>(allSerialFields.size());
        for (VariableElement variableElement : allSerialFields) {
            AptTypeInfo typeInfo = this.parseTypeArgMirrors(variableElement);
            allAptTypeInfos.add(typeInfo);
            AptFieldProps aptFieldProps = this.context.fieldPropsMap.get(variableElement);
            if (aptFieldProps == null) continue;
            aptFieldProps.implMirror = typeInfo.impl;
        }
        List<FieldSpec> typesFields = this.genTypeFields(allSerialFields, allAptTypeInfos);
        List<FieldSpec> factoryFields = this.genFactoryFields(allSerialFields, allAptTypeInfos);
        List<FieldSpec> namesSpec = this.genNameFields();
        this.context.typeBuilder.addFields(typesFields).addFields(factoryFields).addFields(namesSpec);
    }

    static String getFactoryFieldName(String fieldName) {
        return "factories_" + fieldName;
    }

    static String getTypeInfoFieldName(String fieldName) {
        return "types_" + fieldName;
    }

    static String getNameFileName(String fieldName) {
        return "names_" + fieldName;
    }

    private List<FieldSpec> genTypeFields(List<VariableElement> allSerialFields, List<AptTypeInfo> allAptTypeInfos) {
        ArrayList<FieldSpec> typeFieldList = new ArrayList<FieldSpec>(allSerialFields.size() * 2);
        for (int i = 0; i < allSerialFields.size(); ++i) {
            VariableElement variableElement = allSerialFields.get(i);
            AptTypeInfo aptTypeInfo = allAptTypeInfos.get(i);
            typeFieldList.add(this.genTypeField(variableElement, aptTypeInfo));
        }
        return typeFieldList;
    }

    private List<FieldSpec> genFactoryFields(List<VariableElement> allSerialFields, List<AptTypeInfo> allAptTypeInfos) {
        ArrayList<FieldSpec> typeFieldList = new ArrayList<FieldSpec>(allSerialFields.size() * 2);
        for (int i = 0; i < allSerialFields.size(); ++i) {
            VariableElement variableElement = allSerialFields.get(i);
            AptTypeInfo aptTypeInfo = allAptTypeInfos.get(i);
            if (aptTypeInfo.impl == null) continue;
            typeFieldList.add(this.genFactoryField(variableElement, aptTypeInfo));
        }
        return typeFieldList;
    }

    private FieldSpec genFactoryField(VariableElement variableElement, AptTypeInfo aptTypeInfo) {
        ParameterizedTypeName fieldTypeName = ParameterizedTypeName.get((ClassName)AptUtils.CLSNAME_SUPPLIER, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)variableElement.asType())});
        String factoryFieldName = SchemaGenerator.getFactoryFieldName(variableElement.getSimpleName().toString());
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)fieldTypeName, (String)factoryFieldName, (Modifier[])AptUtils.PUBLIC_STATIC_FINAL);
        if (aptTypeInfo.type == 2) {
            if (((CodecProcessor)this.processor).isEnumMap(aptTypeInfo.impl)) {
                builder.initializer("() -> new EnumMap<>($T.class)", new Object[]{TypeName.get((TypeMirror)this.typeUtils.erasure(aptTypeInfo.typeArgs.get(0)))});
            } else {
                builder.initializer("$T::new", new Object[]{TypeName.get((TypeMirror)this.typeUtils.erasure(aptTypeInfo.impl))});
            }
        } else if (aptTypeInfo.type == 1) {
            if (((CodecProcessor)this.processor).isEnumSet(aptTypeInfo.impl)) {
                builder.initializer("() -> EnumSet.noneOf($T.class)", new Object[]{TypeName.get((TypeMirror)this.typeUtils.erasure(aptTypeInfo.typeArgs.get(0)))});
            } else {
                builder.initializer("$T::new", new Object[]{TypeName.get((TypeMirror)this.typeUtils.erasure(aptTypeInfo.impl))});
            }
        } else {
            builder.initializer("$T::new", new Object[]{TypeName.get((TypeMirror)this.typeUtils.erasure(aptTypeInfo.impl))});
        }
        return builder.build();
    }

    private FieldSpec genTypeField(VariableElement variableElement, AptTypeInfo aptTypeInfo) {
        ParameterizedTypeName fieldTypeName = variableElement.asType().getKind().isPrimitive() ? ParameterizedTypeName.get((ClassName)this.typeInfoRawTypeName, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)variableElement.asType()).box()}) : ParameterizedTypeName.get((ClassName)this.typeInfoRawTypeName, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)this.typeUtils.erasure(variableElement.asType()))});
        String typeInfoFieldName = SchemaGenerator.getTypeInfoFieldName(variableElement.getSimpleName().toString());
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)fieldTypeName, (String)typeInfoFieldName, (Modifier[])AptUtils.PUBLIC_STATIC_FINAL);
        switch (aptTypeInfo.typeArgs.size()) {
            case 0: {
                builder.initializer("$T.of($T.class)", new Object[]{this.typeInfoRawTypeName, TypeName.get((TypeMirror)this.typeUtils.erasure(aptTypeInfo.declared))});
                break;
            }
            case 1: {
                builder.initializer("$T.of($T.class, $T.class)", new Object[]{this.typeInfoRawTypeName, TypeName.get((TypeMirror)this.typeUtils.erasure(aptTypeInfo.declared)), TypeName.get((TypeMirror)this.typeUtils.erasure(aptTypeInfo.typeArgs.get(0)))});
                break;
            }
            case 2: {
                builder.initializer("$T.of($T.class, $T.class, $T.class)", new Object[]{this.typeInfoRawTypeName, TypeName.get((TypeMirror)this.typeUtils.erasure(aptTypeInfo.declared)), TypeName.get((TypeMirror)this.typeUtils.erasure(aptTypeInfo.typeArgs.get(0))), TypeName.get((TypeMirror)this.typeUtils.erasure(aptTypeInfo.typeArgs.get(1)))});
                break;
            }
            default: {
                StringBuilder format = new StringBuilder("$T.of($T.class, List.Of(");
                ArrayList<Object> params = new ArrayList<Object>(aptTypeInfo.typeArgs.size() + 2);
                params.add(this.typeInfoRawTypeName);
                params.add(TypeName.get((TypeMirror)this.typeUtils.erasure(aptTypeInfo.declared)));
                for (int i = 0; i < aptTypeInfo.typeArgs.size(); ++i) {
                    if (i > 0) {
                        format.append(", ");
                    }
                    TypeMirror typeArg = aptTypeInfo.typeArgs.get(i);
                    format.append("$T.class");
                    params.add(this.typeUtils.erasure(typeArg));
                }
                format.append(")");
                builder.initializer(format.toString(), params.toArray());
                break;
            }
        }
        return builder.build();
    }

    private AptTypeInfo parseTypeArgMirrors(VariableElement variableElement) {
        TypeMirror typeMirror = variableElement.asType();
        if (typeMirror.getKind().isPrimitive()) {
            return AptTypeInfo.of(typeMirror, null);
        }
        AptFieldProps properties = this.context.fieldPropsMap.get(variableElement);
        if (typeMirror.getKind() == TypeKind.ARRAY) {
            return AptTypeInfo.of(variableElement.asType(), properties.implMirror);
        }
        if (properties.implMirror != null && !AptUtils.isSubTypeIgnoreTypeParameter((Types)this.typeUtils, (TypeMirror)properties.implMirror, (TypeMirror)variableElement.asType())) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "The implementation type must be a subtype of the declared type", variableElement);
        }
        if (((CodecProcessor)this.processor).isMap(typeMirror)) {
            return this.parseMapTypeInfo(variableElement, properties);
        }
        if (((CodecProcessor)this.processor).isCollection(typeMirror)) {
            return this.parseCollectionTypeInfo(variableElement, properties);
        }
        DeclaredType declaredType = (DeclaredType)typeMirror;
        List<? extends TypeMirror> typeArguments = this.erasureTypeArguments(declaredType.getTypeArguments());
        return AptTypeInfo.of(declaredType, typeArguments, properties.implMirror);
    }

    private AptTypeInfo parseMapTypeInfo(VariableElement variableElement, AptFieldProps properties) {
        DeclaredType declaredType = (DeclaredType)variableElement.asType();
        List<? extends TypeMirror> typeArguments = this.erasureTypeArguments(declaredType.getTypeArguments());
        TypeMirror realImplMirror = this.parseMapVarImpl(variableElement, properties);
        return AptTypeInfo.ofMap(variableElement.asType(), typeArguments, realImplMirror);
    }

    private AptTypeInfo parseCollectionTypeInfo(VariableElement variableElement, AptFieldProps properties) {
        DeclaredType declaredType = (DeclaredType)variableElement.asType();
        List<? extends TypeMirror> typeArguments = this.erasureTypeArguments(declaredType.getTypeArguments());
        TypeMirror realImplMirror = this.parseCollectionVarImpl(variableElement, properties);
        return AptTypeInfo.ofCollection(variableElement.asType(), typeArguments, realImplMirror);
    }

    private TypeMirror parseMapVarImpl(VariableElement variableElement, AptFieldProps properties) {
        if (!AptUtils.isBlank((String)properties.readProxy)) {
            return null;
        }
        TypeMirror typeMirror = variableElement.asType();
        if (properties.implMirror != null) {
            return properties.implMirror;
        }
        if (((CodecProcessor)this.processor).isEnumMap(typeMirror)) {
            return ((CodecProcessor)this.processor).type_EnumMap;
        }
        DeclaredType declaredType = AptUtils.findDeclaredType((TypeMirror)variableElement.asType());
        assert (declaredType != null);
        if (!declaredType.asElement().getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return declaredType;
        }
        this.checkDefaultImpl(variableElement, ((CodecProcessor)this.processor).type_LinkedHashMap);
        return null;
    }

    private TypeMirror parseCollectionVarImpl(VariableElement variableElement, AptFieldProps properties) {
        if (!AptUtils.isBlank((String)properties.readProxy)) {
            return null;
        }
        TypeMirror typeMirror = variableElement.asType();
        if (properties.implMirror != null) {
            return properties.implMirror;
        }
        if (((CodecProcessor)this.processor).isEnumSet(typeMirror)) {
            return ((CodecProcessor)this.processor).type_EnumSet;
        }
        DeclaredType declaredType = AptUtils.findDeclaredType((TypeMirror)variableElement.asType());
        assert (declaredType != null);
        if (!declaredType.asElement().getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return declaredType;
        }
        if (((CodecProcessor)this.processor).isSet(typeMirror)) {
            this.checkDefaultImpl(variableElement, ((CodecProcessor)this.processor).type_LinkedHashSet);
        } else {
            this.checkDefaultImpl(variableElement, ((CodecProcessor)this.processor).type_ArrayList);
        }
        return null;
    }

    private List<? extends TypeMirror> erasureTypeArguments(List<? extends TypeMirror> typeArguments) {
        ArrayList<TypeMirror> result = new ArrayList<TypeMirror>(typeArguments.size());
        for (TypeMirror typeMirror : typeArguments) {
            if (typeMirror.getKind() == TypeKind.WILDCARD) {
                WildcardType wildcardType = (WildcardType)typeMirror;
                if (wildcardType.getExtendsBound() != null) {
                    result.add(this.typeUtils.erasure(wildcardType.getExtendsBound()));
                    continue;
                }
                result.add(((CodecProcessor)this.processor).type_Object);
                continue;
            }
            if (typeMirror.getKind() == TypeKind.TYPEVAR) {
                TypeVariable typeVariable = (TypeVariable)typeMirror;
                result.add(this.typeUtils.erasure(typeVariable.getUpperBound()));
                continue;
            }
            result.add(this.typeUtils.erasure(typeMirror));
        }
        return result;
    }

    private void checkDefaultImpl(VariableElement variableElement, TypeMirror defImpl) {
        if (!AptUtils.isSubTypeIgnoreTypeParameter((Types)this.typeUtils, (TypeMirror)defImpl, (TypeMirror)variableElement.asType())) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Unknown abstract Map or Collection must contains impl annotation cn.wjybxx.dsoncodec.annotations.DsonProperty", variableElement);
        }
    }

    private List<FieldSpec> genNameFields() {
        List<VariableElement> serialFields = this.context.serialFields;
        HashSet<String> dsonNameSet = new HashSet<String>((int)((float)serialFields.size() * 1.35f));
        ArrayList<FieldSpec> fieldSpecList = new ArrayList<FieldSpec>(serialFields.size());
        for (VariableElement variableElement : serialFields) {
            AptFieldProps properties = this.context.fieldPropsMap.get(variableElement);
            String fieldName = variableElement.getSimpleName().toString();
            String dsonName = !AptUtils.isBlank((String)properties.name) ? properties.name.trim() : fieldName;
            if (!dsonNameSet.add(dsonName)) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("dsonName is duplicate, dsonName %s", dsonName), variableElement);
                continue;
            }
            fieldSpecList.add(FieldSpec.builder((TypeName)AptUtils.CLSNAME_STRING, (String)SchemaGenerator.getNameFileName(fieldName), (Modifier[])AptUtils.PUBLIC_STATIC_FINAL).initializer("$S", new Object[]{dsonName}).build());
        }
        return fieldSpecList;
    }
}

