/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsonapt;

import cn.wjybxx.apt.AptUtils;
import cn.wjybxx.apt.BeanUtils;
import cn.wjybxx.apt.MyAbstractProcessor;
import cn.wjybxx.dsonapt.AptClassProps;
import cn.wjybxx.dsonapt.AptFieldProps;
import cn.wjybxx.dsonapt.Context;
import cn.wjybxx.dsonapt.PojoCodecGenerator;
import cn.wjybxx.dsonapt.SchemaGenerator;
import com.google.auto.service.AutoService;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@AutoService(value={Processor.class})
public class CodecProcessor
extends MyAbstractProcessor {
    public static final String CNAME_WireType = "cn.wjybxx.dson.WireType";
    public static final String CNAME_NumberStyle = "cn.wjybxx.dson.text.NumberStyle";
    public static final String CNAME_StringStyle = "cn.wjybxx.dson.text.StringStyle";
    public static final String CNAME_ObjectStyle = "cn.wjybxx.dson.text.ObjectStyle";
    public static final String CNAME_TypeInfo = "cn.wjybxx.dsoncodec.TypeInfo";
    public static final String CNAME_Options = "cn.wjybxx.dsoncodec.ConverterOptions";
    public static final String CNAME_ObjectPtr = "cn.wjybxx.dson.types.ObjectPtr";
    public static final String CNAME_ObjectLitePtr = "cn.wjybxx.dson.types.ObjectLitePtr";
    public static final String CNAME_Timestamp = "cn.wjybxx.dson.types.Timestamp";
    private static final String CNAME_SERIALIZABLE = "cn.wjybxx.dsoncodec.annotations.DsonSerializable";
    private static final String CNAME_PROPERTY = "cn.wjybxx.dsoncodec.annotations.DsonProperty";
    private static final String CNAME_DSON_IGNORE = "cn.wjybxx.dsoncodec.annotations.DsonIgnore";
    private static final String CNAME_DSON_READER = "cn.wjybxx.dsoncodec.DsonObjectReader";
    private static final String CNAME_DSON_WRITER = "cn.wjybxx.dsoncodec.DsonObjectWriter";
    private static final String CNAME_DSON_SCAN_IGNORE = "cn.wjybxx.dsoncodec.annotations.DsonCodecScanIgnore";
    private static final String CNAME_CODEC_LINKER_GROUP = "cn.wjybxx.dsoncodec.annotations.DsonCodecLinkerGroup";
    private static final String CNAME_CODEC_LINKER = "cn.wjybxx.dsoncodec.annotations.DsonCodecLinker";
    private static final String CNAME_CODEC_LINKER_BEAN = "cn.wjybxx.dsoncodec.annotations.DsonCodecLinkerBean";
    private static final String MNAME_OUTPUT = "outputPackage";
    private static final String MNAME_CLASS_PROPS = "props";
    public static final String CNAME_CODEC = "cn.wjybxx.dsoncodec.DsonCodec";
    public static final String MNAME_READ_OBJECT = "readObject";
    public static final String MNAME_WRITE_OBJECT = "writeObject";
    private static final String CNAME_ABSTRACT_CODEC = "cn.wjybxx.dsoncodec.AbstractDsonCodec";
    public static final String MNAME_GET_ENCODER_TYPE = "getEncoderType";
    public static final String MNAME_BEFORE_ENCODE = "beforeEncode";
    public static final String MNAME_WRITE_FIELDS = "writeFields";
    public static final String MNAME_NEW_INSTANCE = "newInstance";
    public static final String MNAME_READ_FIELDS = "readFields";
    public static final String MNAME_AFTER_DECODE = "afterDecode";
    private static final String CNAME_ENUM_CODEC = "cn.wjybxx.dsoncodec.codecs.EnumCodec";
    public static final String CNAME_ENUM_LITE = "cn.wjybxx.base.EnumLite";
    public static final String MNAME_FOR_NUMBER = "forNumber";
    public static final String MNAME_GET_NUMBER = "getNumber";
    public ClassName typeName_TypeInfo;
    public ClassName typeName_WireType;
    public ClassName typeName_NumberStyle;
    public ClassName typeName_StringStyle;
    public ClassName typeName_ObjectStyle;
    public TypeMirror type_Options;
    public TypeElement anno_DsonSerializable;
    public TypeMirror anno_DsonProperty;
    public TypeMirror anno_DsonIgnore;
    public TypeMirror typeMirror_DsonReader;
    public TypeMirror typeMirror_dsonWriter;
    public TypeElement anno_CodecLinkerGroup;
    public TypeElement anno_CodecLinker;
    public TypeElement anno_CodecLinkerBean;
    public TypeElement abstractCodecTypeElement;
    public ExecutableElement getEncoderClassMethod;
    public ExecutableElement newInstanceMethod;
    public ExecutableElement readFieldsMethod;
    public ExecutableElement afterDecodeMethod;
    public ExecutableElement beforeEncodeMethod;
    public ExecutableElement writeFieldsMethod;
    public TypeMirror type_String;
    public TypeMirror type_Object;
    public TypeMirror type_Ptr;
    public TypeMirror type_LitePtr;
    public TypeMirror type_LocalDateTime;
    public TypeMirror type_Timestamp;
    public TypeMirror type_Map;
    public TypeMirror type_Collection;
    public TypeMirror type_Set;
    public TypeMirror type_EnumSet;
    public TypeMirror type_EnumMap;
    public TypeMirror type_LinkedHashMap;
    public TypeMirror type_LinkedHashSet;
    public TypeMirror type_ArrayList;

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(CNAME_SERIALIZABLE, CNAME_CODEC_LINKER_GROUP, CNAME_CODEC_LINKER_BEAN);
    }

    protected void ensureInited() {
        if (this.typeName_WireType != null) {
            return;
        }
        this.typeName_TypeInfo = ClassName.get((TypeElement)this.elementUtils.getTypeElement(CNAME_TypeInfo));
        this.typeName_WireType = AptUtils.classNameOfCanonicalName((String)CNAME_WireType);
        this.typeName_NumberStyle = AptUtils.classNameOfCanonicalName((String)CNAME_NumberStyle);
        this.typeName_StringStyle = AptUtils.classNameOfCanonicalName((String)CNAME_StringStyle);
        this.typeName_ObjectStyle = AptUtils.classNameOfCanonicalName((String)CNAME_ObjectStyle);
        this.type_Options = this.elementUtils.getTypeElement(CNAME_Options).asType();
        this.anno_DsonSerializable = this.elementUtils.getTypeElement(CNAME_SERIALIZABLE);
        this.anno_DsonProperty = this.elementUtils.getTypeElement(CNAME_PROPERTY).asType();
        this.anno_DsonIgnore = this.elementUtils.getTypeElement(CNAME_DSON_IGNORE).asType();
        this.typeMirror_DsonReader = this.elementUtils.getTypeElement(CNAME_DSON_READER).asType();
        this.typeMirror_dsonWriter = this.elementUtils.getTypeElement(CNAME_DSON_WRITER).asType();
        this.anno_CodecLinkerGroup = this.elementUtils.getTypeElement(CNAME_CODEC_LINKER_GROUP);
        this.anno_CodecLinker = this.elementUtils.getTypeElement(CNAME_CODEC_LINKER);
        this.anno_CodecLinkerBean = this.elementUtils.getTypeElement(CNAME_CODEC_LINKER_BEAN);
        TypeElement codecTypeElement = this.elementUtils.getTypeElement(CNAME_CODEC);
        this.getEncoderClassMethod = AptUtils.findMethodByName((TypeElement)codecTypeElement, (String)MNAME_GET_ENCODER_TYPE);
        this.abstractCodecTypeElement = this.elementUtils.getTypeElement(CNAME_ABSTRACT_CODEC);
        List allMethodsWithInherit = BeanUtils.getAllMethodsWithInherit((TypeElement)this.abstractCodecTypeElement);
        this.newInstanceMethod = this.findCodecMethod(allMethodsWithInherit, MNAME_NEW_INSTANCE, this.typeMirror_DsonReader);
        this.readFieldsMethod = this.findCodecMethod(allMethodsWithInherit, MNAME_READ_FIELDS, this.typeMirror_DsonReader);
        this.afterDecodeMethod = this.findCodecMethod(allMethodsWithInherit, MNAME_AFTER_DECODE, this.typeMirror_DsonReader);
        this.beforeEncodeMethod = this.findCodecMethod(allMethodsWithInherit, MNAME_BEFORE_ENCODE, this.typeMirror_dsonWriter);
        this.writeFieldsMethod = this.findCodecMethod(allMethodsWithInherit, MNAME_WRITE_FIELDS, this.typeMirror_dsonWriter);
        this.type_String = this.elementUtils.getTypeElement(String.class.getCanonicalName()).asType();
        this.type_Object = this.elementUtils.getTypeElement(Object.class.getCanonicalName()).asType();
        this.type_Ptr = this.elementUtils.getTypeElement(CNAME_ObjectPtr).asType();
        this.type_LitePtr = this.elementUtils.getTypeElement(CNAME_ObjectLitePtr).asType();
        this.type_LocalDateTime = this.elementUtils.getTypeElement(LocalDateTime.class.getCanonicalName()).asType();
        this.type_Timestamp = this.elementUtils.getTypeElement(CNAME_Timestamp).asType();
        this.type_Map = this.elementUtils.getTypeElement(Map.class.getCanonicalName()).asType();
        this.type_Collection = this.elementUtils.getTypeElement(Collection.class.getCanonicalName()).asType();
        this.type_Set = this.elementUtils.getTypeElement(Set.class.getCanonicalName()).asType();
        this.type_EnumSet = this.typeUtils.erasure(AptUtils.getTypeMirrorOfClass((Elements)this.elementUtils, EnumSet.class));
        this.type_EnumMap = this.typeUtils.erasure(AptUtils.getTypeMirrorOfClass((Elements)this.elementUtils, EnumMap.class));
        this.type_LinkedHashMap = this.typeUtils.erasure(AptUtils.getTypeMirrorOfClass((Elements)this.elementUtils, LinkedHashMap.class));
        this.type_LinkedHashSet = this.typeUtils.erasure(AptUtils.getTypeMirrorOfClass((Elements)this.elementUtils, LinkedHashSet.class));
        this.type_ArrayList = this.typeUtils.erasure(AptUtils.getTypeMirrorOfClass((Elements)this.elementUtils, ArrayList.class));
    }

    private ExecutableElement findCodecMethod(List<ExecutableElement> allMethodsWithInherit, String methodName, TypeMirror readerWriterType) {
        return allMethodsWithInherit.stream().filter(e -> e.getSimpleName().toString().equals(methodName)).filter(e -> e.getParameters().size() > 0 && AptUtils.isSameTypeIgnoreTypeParameter((Types)this.typeUtils, (TypeMirror)e.getParameters().get(0).asType(), (TypeMirror)readerWriterType)).findFirst().orElseThrow(() -> new RuntimeException("method is absent, methodName: " + methodName));
    }

    protected boolean doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set allTypeElements = AptUtils.selectSourceFileAny((RoundEnvironment)roundEnv, (Elements)this.elementUtils, (TypeElement[])new TypeElement[]{this.anno_DsonSerializable, this.anno_CodecLinkerGroup, this.anno_CodecLinkerBean});
        for (TypeElement typeElement : allTypeElements) {
            try {
                Context context = this.createContext(typeElement);
                if (context.linkerBeanAnnoMirror != null) {
                    this.processLinkerBean(context);
                    continue;
                }
                if (context.linkerGroupAnnoMirror != null) {
                    this.processLinkerGroup(context);
                    continue;
                }
                assert (context.dsonSerialAnnoMirror != null);
                this.processDirectType(context);
            }
            catch (Throwable e) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, AptUtils.getStackTrace((Throwable)e), typeElement);
            }
        }
        return true;
    }

    private Context createContext(TypeElement typeElement) {
        Context context = new Context(typeElement);
        context.dsonSerialAnnoMirror = AptUtils.findAnnotation((Types)this.typeUtils, (Element)typeElement, (TypeMirror)this.anno_DsonSerializable.asType());
        if (context.dsonSerialAnnoMirror != null) {
            return context;
        }
        context.linkerBeanAnnoMirror = AptUtils.findAnnotation((Types)this.typeUtils, (Element)typeElement, (TypeMirror)this.anno_CodecLinkerBean.asType());
        if (context.linkerBeanAnnoMirror != null) {
            return context;
        }
        context.linkerGroupAnnoMirror = AptUtils.findAnnotation((Types)this.typeUtils, (Element)typeElement, (TypeMirror)this.anno_CodecLinkerGroup.asType());
        return context;
    }

    private void processLinkerBean(Context linkerBeanContext) {
        AnnotationMirror linkerBeanAnnoMirror = linkerBeanContext.linkerBeanAnnoMirror;
        String outPackage = this.getOutputPackage(linkerBeanContext.typeElement, linkerBeanAnnoMirror);
        AnnotationValue annotationValue = AptUtils.getAnnotationValue((AnnotationMirror)linkerBeanAnnoMirror, (String)"value");
        Objects.requireNonNull(annotationValue, "classProps");
        DeclaredType targetType = AptUtils.findDeclaredType((TypeMirror)AptUtils.getAnnotationValueTypeMirror((AnnotationValue)annotationValue));
        Objects.requireNonNull(targetType);
        AnnotationValue classPropsAnnoValue = AptUtils.getAnnotationValue((AnnotationMirror)linkerBeanAnnoMirror, (String)MNAME_CLASS_PROPS);
        AptClassProps aptClassProps = classPropsAnnoValue == null ? new AptClassProps() : AptClassProps.parse((AnnotationMirror)classPropsAnnoValue.getValue());
        TypeElement targetTypeElement = (TypeElement)targetType.asElement();
        Context context = new Context(targetTypeElement);
        context.linkerBeanAnnoMirror = linkerBeanAnnoMirror;
        context.outPackage = outPackage;
        context.aptClassProps = aptClassProps;
        context.additionalAnnotations = this.getAdditionalAnnotations(aptClassProps);
        this.cacheFields(context);
        this.cacheFieldProps(context);
        this.cacheFields(linkerBeanContext);
        this.cacheFieldProps(linkerBeanContext);
        HashMap<String, AptFieldProps> fieldName2FieldPropsMap = HashMap.newHashMap(linkerBeanContext.fieldPropsMap.size());
        for (Map.Entry<VariableElement, AptFieldProps> entry : linkerBeanContext.fieldPropsMap.entrySet()) {
            fieldName2FieldPropsMap.put(entry.getKey().getSimpleName().toString(), entry.getValue());
        }
        for (VariableElement field : context.allFields) {
            AptFieldProps aptFieldProps = (AptFieldProps)fieldName2FieldPropsMap.get(field.getSimpleName().toString());
            if (aptFieldProps == null) continue;
            context.fieldPropsMap.put(field, aptFieldProps);
        }
        TypeMirror linkerBeanTypeMirror = linkerBeanContext.typeElement.asType();
        aptClassProps.codecProxyTypeElement = linkerBeanContext.typeElement;
        aptClassProps.codecProxyClassName = TypeName.get((TypeMirror)this.typeUtils.erasure(linkerBeanTypeMirror));
        aptClassProps.codecProxyEnclosedElements = linkerBeanContext.typeElement.getEnclosedElements();
        this.checkTypeElement(context);
        this.generateCodec(context);
    }

    private void processLinkerGroup(Context groupContext) {
        String outPackage = this.getOutputPackage(groupContext.typeElement, groupContext.linkerGroupAnnoMirror);
        this.cacheFields(groupContext);
        for (VariableElement variableElement : groupContext.allFields) {
            DeclaredType targetType = AptUtils.findDeclaredType((TypeMirror)variableElement.asType());
            if (targetType == null) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Bad Linker Target", variableElement);
                continue;
            }
            AnnotationMirror linkerAnnoMirror = AptUtils.findAnnotation((Types)this.typeUtils, (Element)variableElement, (TypeMirror)this.anno_CodecLinker.asType());
            AnnotationValue classPropsAnnoValue = linkerAnnoMirror != null ? AptUtils.getAnnotationValue((AnnotationMirror)linkerAnnoMirror, (String)MNAME_CLASS_PROPS) : null;
            AptClassProps aptClassProps = classPropsAnnoValue != null ? AptClassProps.parse((AnnotationMirror)classPropsAnnoValue.getValue()) : new AptClassProps();
            TypeElement typeElement = (TypeElement)targetType.asElement();
            Context context = new Context(typeElement);
            context.linkerGroupAnnoMirror = groupContext.linkerGroupAnnoMirror;
            context.outPackage = outPackage;
            context.aptClassProps = aptClassProps;
            context.additionalAnnotations = this.getAdditionalAnnotations(aptClassProps);
            this.cacheFields(context);
            this.cacheFieldProps(context);
            this.checkTypeElement(context);
            this.generateCodec(context);
        }
    }

    private void processDirectType(Context context) {
        this.cacheFields(context);
        this.cacheFieldProps(context);
        context.aptClassProps = AptClassProps.parse(context.dsonSerialAnnoMirror);
        context.additionalAnnotations = this.getAdditionalAnnotations(context.aptClassProps);
        this.checkTypeElement(context);
        this.generateCodec(context);
    }

    private void generateCodec(Context context) {
        TypeElement typeElement = context.typeElement;
        if (typeElement.getKind() != ElementKind.CLASS) {
            return;
        }
        DeclaredType superDeclaredType = this.typeUtils.getDeclaredType(this.abstractCodecTypeElement, this.typeUtils.erasure(typeElement.asType()));
        this.initTypeBuilder(context, typeElement, superDeclaredType);
        SchemaGenerator schemaGenerator = new SchemaGenerator(this, context);
        schemaGenerator.execute();
        new PojoCodecGenerator(this, context).execute();
        if (context.outPackage != null) {
            AptUtils.writeToFile((Element)typeElement, (TypeSpec.Builder)context.typeBuilder, (String)context.outPackage, (Messager)this.messager, (Filer)this.filer);
        } else {
            AptUtils.writeToFile((TypeElement)typeElement, (TypeSpec.Builder)context.typeBuilder, (Elements)this.elementUtils, (Messager)this.messager, (Filer)this.filer);
        }
    }

    private void cacheFields(Context context) {
        context.allFieldsAndMethodWithInherit = BeanUtils.getAllFieldsAndMethodsWithInherit((TypeElement)context.typeElement);
        context.allFields = context.allFieldsAndMethodWithInherit.stream().filter(e -> e.getKind() == ElementKind.FIELD && !e.getModifiers().contains((Object)Modifier.STATIC)).map(e -> (VariableElement)e).toList();
    }

    private void cacheFieldProps(Context context) {
        for (VariableElement variableElement : context.allFields) {
            AptFieldProps aptFieldProps = AptFieldProps.parse(this.typeUtils, variableElement, this.anno_DsonProperty);
            aptFieldProps.parseIgnore(this.typeUtils, variableElement, this.anno_DsonIgnore);
            TypeMirror fieldTypeMirror = variableElement.asType();
            if (aptFieldProps.implMirror == null && fieldTypeMirror.getKind() == TypeKind.DECLARED && (this.isEnumSet(fieldTypeMirror) || this.isEnumMap(fieldTypeMirror))) {
                aptFieldProps.implMirror = fieldTypeMirror;
            }
            context.fieldPropsMap.put(variableElement, aptFieldProps);
        }
    }

    private String getOutputPackage(TypeElement typeElement, AnnotationMirror annotationMirror) {
        String outPackage = (String)AptUtils.getAnnotationValueValue((AnnotationMirror)annotationMirror, (String)MNAME_OUTPUT);
        if (AptUtils.isBlank((String)outPackage)) {
            return this.elementUtils.getPackageOf(typeElement).getQualifiedName().toString();
        }
        return outPackage;
    }

    private List<AnnotationSpec> getAdditionalAnnotations(AptClassProps aptClassProps) {
        if (aptClassProps.additionalAnnotations.isEmpty()) {
            return List.of();
        }
        ArrayList<AnnotationSpec> result = new ArrayList<AnnotationSpec>(aptClassProps.additionalAnnotations.size());
        for (TypeMirror typeMirror : aptClassProps.additionalAnnotations) {
            ClassName className = (ClassName)ClassName.get((TypeMirror)typeMirror);
            result.add(AnnotationSpec.builder((ClassName)className).build());
        }
        return result;
    }

    private void initTypeBuilder(Context context, TypeElement typeElement, DeclaredType superDeclaredType) {
        context.superDeclaredType = superDeclaredType;
        context.typeBuilder = TypeSpec.classBuilder((String)this.getCodecName(typeElement)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(AptUtils.SUPPRESS_UNCHECKED_RAWTYPES).addAnnotation(this.processorInfoAnnotation).superclass(TypeName.get((TypeMirror)superDeclaredType));
    }

    private String getCodecName(TypeElement typeElement) {
        return AptUtils.getProxyClassName((Elements)this.elementUtils, (TypeElement)typeElement, (String)"Codec");
    }

    private void checkTypeElement(Context context) {
        TypeElement typeElement = context.typeElement;
        if (typeElement.getKind() != ElementKind.CLASS) {
            return;
        }
        this.checkNormalClass(context);
    }

    private void checkNormalClass(Context context) {
        AptClassProps aptClassProps = context.aptClassProps;
        if (aptClassProps.isSingleton()) {
            return;
        }
        TypeElement typeElement = context.typeElement;
        this.checkConstructor(typeElement);
        List<? extends Element> allFieldsAndMethodWithInherit = context.allFieldsAndMethodWithInherit;
        List<Element> instMethodList = context.allFieldsAndMethodWithInherit.stream().filter(e -> e.getKind() == ElementKind.METHOD && !e.getModifiers().contains((Object)Modifier.STATIC)).toList();
        for (VariableElement variableElement : context.allFields) {
            AptFieldProps aptFieldProps;
            if (!this.isSerializableField(variableElement, instMethodList, aptFieldProps = context.fieldPropsMap.get(variableElement))) continue;
            context.serialFields.add(variableElement);
            if (this.isAutoWriteField(variableElement, aptClassProps, aptFieldProps)) {
                if (!AptUtils.isBlank((String)aptFieldProps.writeProxy)) continue;
                if (AptUtils.isBlank((String)aptFieldProps.getter) && !this.canGetDirectly(variableElement) && this.findPublicGetter(variableElement, allFieldsAndMethodWithInherit) == null) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("auto write field (%s) must be public or contains a public getter", variableElement.getSimpleName()), typeElement);
                    continue;
                }
            }
            if (!this.isAutoReadField(variableElement, aptClassProps, aptFieldProps) || !AptUtils.isBlank((String)aptFieldProps.readProxy) || !AptUtils.isBlank((String)aptFieldProps.setter) || this.canSetDirectly(variableElement) || this.findPublicSetter(variableElement, allFieldsAndMethodWithInherit) != null) continue;
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("auto read field (%s) must be public or contains a public getter", variableElement.getSimpleName()), typeElement);
        }
    }

    private void checkConstructor(TypeElement typeElement) {
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return;
        }
        if (BeanUtils.containsNoArgsConstructor((TypeElement)typeElement) || this.containsReaderConstructor(typeElement) || this.containsNewInstanceMethod(typeElement)) {
            return;
        }
        this.messager.printMessage(Diagnostic.Kind.ERROR, "SerializableClass %s must contains no-args constructor or reader-args constructor!", typeElement);
    }

    public boolean containsReaderConstructor(TypeElement typeElement) {
        return typeElement.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.CONSTRUCTOR).map(e -> (ExecutableElement)e).filter(e -> e.getParameters().size() > 0).anyMatch(e -> AptUtils.isSubTypeIgnoreTypeParameter((Types)this.typeUtils, (TypeMirror)e.getParameters().get(0).asType(), (TypeMirror)this.typeMirror_DsonReader));
    }

    public boolean containsNewInstanceMethod(TypeElement typeElement) {
        List<Element> staticMembers = typeElement.getEnclosedElements().stream().filter(e -> e.getModifiers().contains((Object)Modifier.STATIC) && e.getModifiers().contains((Object)Modifier.PUBLIC)).toList();
        return this.containsHookMethod(staticMembers, MNAME_NEW_INSTANCE, this.typeMirror_DsonReader);
    }

    public boolean containsReadObjectMethod(List<? extends Element> allFieldsAndMethodWithInherit) {
        return this.containsHookMethod(allFieldsAndMethodWithInherit, MNAME_READ_OBJECT, this.typeMirror_DsonReader);
    }

    public boolean containsWriteObjectMethod(List<? extends Element> allFieldsAndMethodWithInherit) {
        return this.containsHookMethod(allFieldsAndMethodWithInherit, MNAME_WRITE_OBJECT, this.typeMirror_dsonWriter);
    }

    public boolean containsBeforeEncodeMethod(List<? extends Element> allFieldsAndMethodWithInherit) {
        return this.containsHookMethod(allFieldsAndMethodWithInherit, MNAME_BEFORE_ENCODE, this.type_Options);
    }

    public boolean containsAfterDecodeMethod(List<? extends Element> allFieldsAndMethodWithInherit) {
        return this.containsHookMethod(allFieldsAndMethodWithInherit, MNAME_AFTER_DECODE, this.type_Options);
    }

    private boolean containsHookMethod(List<? extends Element> allFieldsAndMethodWithInherit, String methodName, TypeMirror argTypeMirror) {
        return allFieldsAndMethodWithInherit.stream().filter(e -> e.getKind() == ElementKind.METHOD).map(e -> (ExecutableElement)e).anyMatch(e -> e.getModifiers().contains((Object)Modifier.PUBLIC) && e.getSimpleName().toString().equals(methodName) && e.getParameters().size() > 0 && AptUtils.isSameTypeIgnoreTypeParameter((Types)this.typeUtils, (TypeMirror)e.getParameters().get(0).asType(), (TypeMirror)argTypeMirror));
    }

    public boolean canGetDirectly(VariableElement variableElement) {
        return variableElement.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    public boolean canSetDirectly(VariableElement variableElement) {
        if (variableElement.getModifiers().contains((Object)Modifier.FINAL)) {
            return false;
        }
        return variableElement.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    @Deprecated
    private boolean isMemberOrPackageMember(VariableElement variableElement, TypeElement typeElement) {
        TypeElement enclosingElement = (TypeElement)variableElement.getEnclosingElement();
        if (enclosingElement.equals(typeElement)) {
            return true;
        }
        return this.elementUtils.getPackageOf(enclosingElement).equals(this.elementUtils.getPackageOf(typeElement));
    }

    public ExecutableElement findPublicGetter(VariableElement variableElement, List<? extends Element> allMethodWithInherit) {
        return BeanUtils.findPublicGetter((Types)this.typeUtils, (VariableElement)variableElement, allMethodWithInherit);
    }

    public ExecutableElement findPublicSetter(VariableElement variableElement, List<? extends Element> allMethodWithInherit) {
        return BeanUtils.findPublicSetter((Types)this.typeUtils, (VariableElement)variableElement, allMethodWithInherit);
    }

    private boolean isSerializableField(VariableElement variableElement, List<? extends Element> instMethodList, AptFieldProps aptFieldProps) {
        if (variableElement.getModifiers().contains((Object)Modifier.STATIC)) {
            return false;
        }
        Boolean ignore = aptFieldProps.dsonIgnore;
        if (ignore != null) {
            return ignore == false;
        }
        if (variableElement.getModifiers().contains((Object)Modifier.TRANSIENT)) {
            return false;
        }
        if (variableElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return true;
        }
        return BeanUtils.containsPublicSetter((Types)this.typeUtils, (VariableElement)variableElement, instMethodList) && BeanUtils.containsPublicGetter((Types)this.typeUtils, (VariableElement)variableElement, instMethodList);
    }

    boolean isAutoWriteField(VariableElement variableElement, AptClassProps aptClassProps, AptFieldProps aptFieldProps) {
        if (aptClassProps.isSingleton()) {
            return false;
        }
        return !this.isSkipFields(variableElement, aptClassProps);
    }

    boolean isAutoReadField(VariableElement variableElement, AptClassProps aptClassProps, AptFieldProps aptFieldProps) {
        if (aptClassProps.isSingleton()) {
            return false;
        }
        if (variableElement.getModifiers().contains((Object)Modifier.FINAL)) {
            return false;
        }
        return !this.isSkipFields(variableElement, aptClassProps);
    }

    private boolean isSkipFields(VariableElement variableElement, AptClassProps aptClassProps) {
        if (aptClassProps.skipFields.isEmpty()) {
            return false;
        }
        String fieldName = variableElement.getSimpleName().toString();
        if (aptClassProps.skipFields.contains(fieldName)) {
            return true;
        }
        if (!aptClassProps.clippedSkipFields.contains(fieldName)) {
            return false;
        }
        TypeElement declaredTypeElement = (TypeElement)variableElement.getEnclosingElement();
        String simpleClassName = declaredTypeElement.getSimpleName().toString();
        if (aptClassProps.skipFields.contains(simpleClassName + "." + fieldName)) {
            return true;
        }
        String fullClassName = declaredTypeElement.getQualifiedName().toString();
        return aptClassProps.skipFields.contains(fullClassName + "." + fieldName);
    }

    protected boolean isClassOrEnum(TypeElement typeElement) {
        return typeElement.getKind() == ElementKind.CLASS || typeElement.getKind() == ElementKind.ENUM;
    }

    protected boolean isString(TypeMirror typeMirror) {
        return this.typeUtils.isSameType(typeMirror, this.type_String);
    }

    protected boolean isObjectPtr(TypeMirror typeMirror) {
        return this.typeUtils.isSameType(typeMirror, this.type_Ptr);
    }

    protected boolean isObjectLitePtr(TypeMirror typeMirror) {
        return this.typeUtils.isSameType(typeMirror, this.type_LitePtr);
    }

    protected boolean isLocalDateTime(TypeMirror typeMirror) {
        return this.typeUtils.isSameType(typeMirror, this.type_LocalDateTime);
    }

    protected boolean isTimestamp(TypeMirror typeMirror) {
        return this.typeUtils.isSameType(typeMirror, this.type_Timestamp);
    }

    protected boolean isByteArray(TypeMirror typeMirror) {
        return AptUtils.isByteArray((TypeMirror)typeMirror);
    }

    protected boolean isMap(TypeMirror typeMirror) {
        return AptUtils.isSubTypeIgnoreTypeParameter((Types)this.typeUtils, (TypeMirror)typeMirror, (TypeMirror)this.type_Map);
    }

    protected boolean isCollection(TypeMirror typeMirror) {
        return AptUtils.isSubTypeIgnoreTypeParameter((Types)this.typeUtils, (TypeMirror)typeMirror, (TypeMirror)this.type_Collection);
    }

    protected boolean isSet(TypeMirror typeMirror) {
        return AptUtils.isSubTypeIgnoreTypeParameter((Types)this.typeUtils, (TypeMirror)typeMirror, (TypeMirror)this.type_Set);
    }

    protected boolean isEnumSet(TypeMirror typeMirror) {
        return typeMirror == this.type_EnumSet || AptUtils.isSameTypeIgnoreTypeParameter((Types)this.typeUtils, (TypeMirror)typeMirror, (TypeMirror)this.type_EnumSet);
    }

    protected boolean isEnumMap(TypeMirror typeMirror) {
        return typeMirror == this.type_EnumMap || AptUtils.isSameTypeIgnoreTypeParameter((Types)this.typeUtils, (TypeMirror)typeMirror, (TypeMirror)this.type_EnumMap);
    }

    public MethodSpec newGetEncoderTypeMethod(DeclaredType superDeclaredType, ClassName rawTypeName) {
        return MethodSpec.overriding((ExecutableElement)this.getEncoderClassMethod, (DeclaredType)superDeclaredType, (Types)this.typeUtils).addStatement("return encoderType", new Object[0]).addAnnotation(AptUtils.ANNOTATION_NONNULL).build();
    }

    public MethodSpec.Builder newNewInstanceMethodBuilder(DeclaredType superDeclaredType) {
        return MethodSpec.overriding((ExecutableElement)this.newInstanceMethod, (DeclaredType)superDeclaredType, (Types)this.typeUtils);
    }

    public MethodSpec.Builder newReadFieldsMethodBuilder(DeclaredType superDeclaredType) {
        return MethodSpec.overriding((ExecutableElement)this.readFieldsMethod, (DeclaredType)superDeclaredType, (Types)this.typeUtils);
    }

    public MethodSpec.Builder newAfterDecodeMethodBuilder(DeclaredType superDeclaredType) {
        return MethodSpec.overriding((ExecutableElement)this.afterDecodeMethod, (DeclaredType)superDeclaredType, (Types)this.typeUtils);
    }

    public MethodSpec.Builder newBeforeEncodeMethodBuilder(DeclaredType superDeclaredType) {
        return MethodSpec.overriding((ExecutableElement)this.beforeEncodeMethod, (DeclaredType)superDeclaredType, (Types)this.typeUtils);
    }

    public MethodSpec.Builder newWriteFieldsMethodBuilder(DeclaredType superDeclaredType) {
        return MethodSpec.overriding((ExecutableElement)this.writeFieldsMethod, (DeclaredType)superDeclaredType, (Types)this.typeUtils);
    }
}

