/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsonapt;

import cn.wjybxx.apt.AptUtils;
import cn.wjybxx.apt.BeanUtils;
import cn.wjybxx.apt.MyAbstractProcessor;
import cn.wjybxx.dsonapt.AptClassProps;
import cn.wjybxx.dsonapt.AptFieldProps;
import cn.wjybxx.dsonapt.Context;
import cn.wjybxx.dsonapt.FieldKey;
import cn.wjybxx.dsonapt.PojoCodecGenerator;
import cn.wjybxx.dsonapt.SchemaGenerator;
import com.google.auto.service.AutoService;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@AutoService(value={Processor.class})
public class CodecProcessor
extends MyAbstractProcessor {
    private static final String CNAME_WireType = "cn.wjybxx.dson.WireType";
    private static final String CNAME_NumberStyle = "cn.wjybxx.dson.text.NumberStyle";
    private static final String CNAME_StringStyle = "cn.wjybxx.dson.text.StringStyle";
    private static final String CNAME_ObjectStyle = "cn.wjybxx.dson.text.ObjectStyle";
    private static final String CNAME_ObjectPtr = "cn.wjybxx.dson.types.ObjectPtr";
    private static final String CNAME_ObjectLitePtr = "cn.wjybxx.dson.types.ObjectLitePtr";
    private static final String CNAME_Timestamp = "cn.wjybxx.dson.types.Timestamp";
    private static final String CNAME_TypeInfo = "cn.wjybxx.base.TypeInfo";
    private static final String CNAME_TypeName = "cn.wjybxx.base.TypeName";
    private static final String CNAME_SERIALIZABLE = "cn.wjybxx.dsoncodec.annotations.DsonSerializable";
    private static final String CNAME_PROPERTY = "cn.wjybxx.dsoncodec.annotations.DsonProperty";
    private static final String CNAME_DSON_IGNORE = "cn.wjybxx.dsoncodec.annotations.DsonIgnore";
    private static final String CNAME_DSON_READER = "cn.wjybxx.dsoncodec.DsonObjectReader";
    private static final String CNAME_DSON_WRITER = "cn.wjybxx.dsoncodec.DsonObjectWriter";
    private static final String CNAME_OPTIONS = "cn.wjybxx.dsoncodec.ConverterOptions";
    private static final String CNAME_CODEC_LINKER_GROUP = "cn.wjybxx.dsoncodec.annotations.DsonCodecLinkerGroup";
    private static final String CNAME_CODEC_LINKER = "cn.wjybxx.dsoncodec.annotations.DsonCodecLinker";
    private static final String CNAME_CODEC_LINKER_BEAN = "cn.wjybxx.dsoncodec.annotations.DsonCodecLinkerBean";
    private static final String MNAME_OUTPUT = "outputPackage";
    private static final String MNAME_CLASS_PROPS = "props";
    private static final String MNAME_VALUE = "value";
    public static final String CNAME_CODEC = "cn.wjybxx.dsoncodec.DsonCodec";
    public static final String MNAME_READ_OBJECT = "readObject";
    public static final String MNAME_WRITE_OBJECT = "writeObject";
    private static final String CNAME_ABSTRACT_CODEC = "cn.wjybxx.dsoncodec.AbstractDsonCodec";
    public static final String MNAME_GET_ENCODER_TYPE = "getEncoderType";
    public static final String MNAME_BEFORE_ENCODE = "beforeEncode";
    public static final String MNAME_WRITE_FIELDS = "writeFields";
    public static final String MNAME_NEW_INSTANCE = "newInstance";
    public static final String MNAME_READ_FIELDS = "readFields";
    public static final String MNAME_AFTER_DECODE = "afterDecode";
    public static final ClassName typeName_TypeInfo = AptUtils.classNameOfCanonicalName((String)"cn.wjybxx.base.TypeInfo");
    public static final ClassName typeName_WireType = AptUtils.classNameOfCanonicalName((String)"cn.wjybxx.dson.WireType");
    public static final ClassName typeName_NumberStyle = AptUtils.classNameOfCanonicalName((String)"cn.wjybxx.dson.text.NumberStyle");
    public static final ClassName typeName_StringStyle = AptUtils.classNameOfCanonicalName((String)"cn.wjybxx.dson.text.StringStyle");
    public static final ClassName typeName_ObjectStyle = AptUtils.classNameOfCanonicalName((String)"cn.wjybxx.dson.text.ObjectStyle");
    public TypeElement anno_DsonSerializable;
    public TypeMirror anno_DsonProperty;
    public TypeMirror anno_DsonIgnore;
    public TypeMirror typeMirror_DsonReader;
    public TypeMirror typeMirror_dsonWriter;
    public TypeMirror typeMirror_Options;
    public TypeElement anno_CodecLinkerGroup;
    public TypeElement anno_CodecLinker;
    public TypeElement anno_CodecLinkerBean;
    public TypeElement abstractCodecTypeElement;
    public ExecutableElement getEncoderTypeMethod;
    public ExecutableElement newInstanceMethod;
    public ExecutableElement readFieldsMethod;
    public ExecutableElement afterDecodeMethod;
    public ExecutableElement beforeEncodeMethod;
    public ExecutableElement writeFieldsMethod;
    public TypeMirror type_String;
    public TypeMirror type_Object;
    public TypeMirror type_LocalDateTime;
    public TypeMirror type_Ptr;
    public TypeMirror type_LitePtr;
    public TypeMirror type_Timestamp;
    public TypeMirror type_EnumSet;
    public TypeMirror type_EnumMap;

    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(CNAME_SERIALIZABLE, CNAME_CODEC_LINKER_GROUP, CNAME_CODEC_LINKER_BEAN);
    }

    protected void ensureInited() {
        if (this.anno_DsonSerializable != null) {
            return;
        }
        this.anno_DsonSerializable = this.elementUtils.getTypeElement(CNAME_SERIALIZABLE);
        this.anno_DsonProperty = this.elementUtils.getTypeElement(CNAME_PROPERTY).asType();
        this.anno_DsonIgnore = this.elementUtils.getTypeElement(CNAME_DSON_IGNORE).asType();
        this.typeMirror_DsonReader = this.elementUtils.getTypeElement(CNAME_DSON_READER).asType();
        this.typeMirror_dsonWriter = this.elementUtils.getTypeElement(CNAME_DSON_WRITER).asType();
        this.typeMirror_Options = this.elementUtils.getTypeElement(CNAME_OPTIONS).asType();
        this.anno_CodecLinkerGroup = this.elementUtils.getTypeElement(CNAME_CODEC_LINKER_GROUP);
        this.anno_CodecLinker = this.elementUtils.getTypeElement(CNAME_CODEC_LINKER);
        this.anno_CodecLinkerBean = this.elementUtils.getTypeElement(CNAME_CODEC_LINKER_BEAN);
        TypeElement codecTypeElement = this.elementUtils.getTypeElement(CNAME_CODEC);
        this.getEncoderTypeMethod = AptUtils.findMethodByName((TypeElement)codecTypeElement, (String)MNAME_GET_ENCODER_TYPE);
        this.abstractCodecTypeElement = this.elementUtils.getTypeElement(CNAME_ABSTRACT_CODEC);
        List allMethodsWithInherit = BeanUtils.getAllMethodsWithInherit((TypeElement)this.abstractCodecTypeElement);
        this.newInstanceMethod = this.findCodecMethod(allMethodsWithInherit, MNAME_NEW_INSTANCE, this.typeMirror_DsonReader);
        this.readFieldsMethod = this.findCodecMethod(allMethodsWithInherit, MNAME_READ_FIELDS, this.typeMirror_DsonReader);
        this.afterDecodeMethod = this.findCodecMethod(allMethodsWithInherit, MNAME_AFTER_DECODE, this.typeMirror_DsonReader);
        this.beforeEncodeMethod = this.findCodecMethod(allMethodsWithInherit, MNAME_BEFORE_ENCODE, this.typeMirror_dsonWriter);
        this.writeFieldsMethod = this.findCodecMethod(allMethodsWithInherit, MNAME_WRITE_FIELDS, this.typeMirror_dsonWriter);
        this.type_String = this.elementUtils.getTypeElement(String.class.getCanonicalName()).asType();
        this.type_Object = this.elementUtils.getTypeElement(Object.class.getCanonicalName()).asType();
        this.type_LocalDateTime = this.elementUtils.getTypeElement(LocalDateTime.class.getCanonicalName()).asType();
        this.type_Ptr = this.elementUtils.getTypeElement(CNAME_ObjectPtr).asType();
        this.type_LitePtr = this.elementUtils.getTypeElement(CNAME_ObjectLitePtr).asType();
        this.type_Timestamp = this.elementUtils.getTypeElement(CNAME_Timestamp).asType();
        this.type_EnumSet = this.typeUtils.erasure(AptUtils.getTypeMirrorOfClass((Elements)this.elementUtils, EnumSet.class));
        this.type_EnumMap = this.typeUtils.erasure(AptUtils.getTypeMirrorOfClass((Elements)this.elementUtils, EnumMap.class));
    }

    private ExecutableElement findCodecMethod(List<ExecutableElement> allMethodsWithInherit, String methodName, TypeMirror readerWriterType) {
        return allMethodsWithInherit.stream().filter(e -> e.getSimpleName().toString().equals(methodName)).filter(e -> e.getParameters().size() > 0 && AptUtils.isSameTypeIgnoreTypeParameter((Types)this.typeUtils, (TypeMirror)e.getParameters().get(0).asType(), (TypeMirror)readerWriterType)).findFirst().orElseThrow(() -> new RuntimeException("method is absent, methodName: " + methodName));
    }

    protected boolean doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set allTypeElements = AptUtils.selectSourceFileAny((RoundEnvironment)roundEnv, (Elements)this.elementUtils, (TypeElement[])new TypeElement[]{this.anno_DsonSerializable, this.anno_CodecLinkerGroup, this.anno_CodecLinkerBean});
        for (TypeElement typeElement : allTypeElements) {
            try {
                AnnotationMirror dsonSerialAnnoMirror = AptUtils.findAnnotation((Types)this.typeUtils, (Element)typeElement, (TypeMirror)this.anno_DsonSerializable.asType());
                if (dsonSerialAnnoMirror != null) {
                    this.processDirectType(typeElement, dsonSerialAnnoMirror);
                    continue;
                }
                AnnotationMirror linkerBeanAnnoMirror = AptUtils.findAnnotation((Types)this.typeUtils, (Element)typeElement, (TypeMirror)this.anno_CodecLinkerBean.asType());
                if (linkerBeanAnnoMirror != null) {
                    this.processLinkerBean(typeElement, linkerBeanAnnoMirror);
                    continue;
                }
                AnnotationMirror linkerGroupAnnoMirror = AptUtils.findAnnotation((Types)this.typeUtils, (Element)typeElement, (TypeMirror)this.anno_CodecLinkerGroup.asType());
                if (linkerGroupAnnoMirror == null) continue;
                this.processLinkerGroup(typeElement, linkerGroupAnnoMirror);
            }
            catch (Throwable e) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, AptUtils.getStackTrace((Throwable)e), typeElement);
            }
        }
        return true;
    }

    private void processLinkerBean(TypeElement linkerBeanType, AnnotationMirror linkerBeanAnnoMirror) {
        String outPackage = this.getOutputPackage(linkerBeanType, linkerBeanAnnoMirror);
        AnnotationValue annotationValue = AptUtils.getAnnotationValue((AnnotationMirror)linkerBeanAnnoMirror, (String)MNAME_VALUE);
        Objects.requireNonNull(annotationValue, "targetType");
        DeclaredType targetType = AptUtils.findDeclaredType((TypeMirror)AptUtils.getAnnotationValueTypeMirror((AnnotationValue)annotationValue));
        Objects.requireNonNull(targetType, "targetType");
        AnnotationValue classPropsAnnoValue = AptUtils.getAnnotationValue((AnnotationMirror)linkerBeanAnnoMirror, (String)MNAME_CLASS_PROPS);
        AptClassProps aptClassProps = classPropsAnnoValue == null ? new AptClassProps() : AptClassProps.parse((AnnotationMirror)classPropsAnnoValue.getValue());
        TypeElement targetTypeElement = (TypeElement)targetType.asElement();
        Context context = new Context(targetTypeElement);
        context.outPackage = outPackage;
        context.aptClassProps = aptClassProps;
        context.additionalAnnotations = this.getAdditionalAnnotations(aptClassProps);
        this.cacheFields(context);
        this.cacheFieldProps(context);
        Context linkerBeanContext = new Context(linkerBeanType);
        this.cacheFields(linkerBeanContext);
        this.cacheFieldProps(linkerBeanContext);
        HashMap<FieldKey, AptFieldProps> fieldName2FieldPropsMap = HashMap.newHashMap(linkerBeanContext.fieldPropsMap.size());
        for (Map.Entry<VariableElement, AptFieldProps> entry : linkerBeanContext.fieldPropsMap.entrySet()) {
            VariableElement field = entry.getKey();
            FieldKey fieldKey = new FieldKey(field.getEnclosingElement().getSimpleName().toString(), field.getSimpleName().toString());
            fieldName2FieldPropsMap.put(fieldKey, entry.getValue());
        }
        for (VariableElement field : context.allFields) {
            FieldKey fieldKey = new FieldKey(field.getEnclosingElement().getSimpleName().toString(), field.getSimpleName().toString());
            AptFieldProps aptFieldProps = (AptFieldProps)fieldName2FieldPropsMap.get(fieldKey);
            if (aptFieldProps == null) continue;
            context.fieldPropsMap.put(field, aptFieldProps);
        }
        TypeMirror linkerBeanTypeMirror = linkerBeanType.asType();
        aptClassProps.codecProxyTypeElement = linkerBeanType;
        aptClassProps.codecProxyClassName = TypeName.get((TypeMirror)this.typeUtils.erasure(linkerBeanTypeMirror));
        this.checkTypeElement(context);
        this.generateCodec(context);
    }

    private void processLinkerGroup(TypeElement groupTypeElement, AnnotationMirror linkerGroupAnnoMirror) {
        String outPackage = this.getOutputPackage(groupTypeElement, linkerGroupAnnoMirror);
        for (VariableElement variableElement : BeanUtils.getAllFieldsWithInherit((TypeElement)groupTypeElement)) {
            DeclaredType targetType = AptUtils.findDeclaredType((TypeMirror)variableElement.asType());
            if (targetType == null) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Bad Linker Target", variableElement);
                continue;
            }
            AnnotationMirror linkerAnnoMirror = AptUtils.findAnnotation((Types)this.typeUtils, (Element)variableElement, (TypeMirror)this.anno_CodecLinker.asType());
            AnnotationValue classPropsAnnoValue = linkerAnnoMirror != null ? AptUtils.getAnnotationValue((AnnotationMirror)linkerAnnoMirror, (String)MNAME_CLASS_PROPS) : null;
            AptClassProps aptClassProps = classPropsAnnoValue != null ? AptClassProps.parse((AnnotationMirror)classPropsAnnoValue.getValue()) : new AptClassProps();
            TypeElement typeElement = (TypeElement)targetType.asElement();
            Context context = new Context(typeElement);
            context.outPackage = outPackage;
            context.aptClassProps = aptClassProps;
            context.additionalAnnotations = this.getAdditionalAnnotations(aptClassProps);
            this.cacheFields(context);
            this.cacheFieldProps(context);
            this.checkTypeElement(context);
            this.generateCodec(context);
        }
    }

    private void processDirectType(TypeElement typeElement, AnnotationMirror dsonSerialAnnoMirror) {
        Context context = new Context(typeElement);
        context.aptClassProps = AptClassProps.parse(dsonSerialAnnoMirror);
        context.additionalAnnotations = this.getAdditionalAnnotations(context.aptClassProps);
        this.cacheFields(context);
        this.cacheFieldProps(context);
        this.checkTypeElement(context);
        this.generateCodec(context);
    }

    private void generateCodec(Context context) {
        TypeElement typeElement = context.typeElement;
        if (typeElement.getKind() != ElementKind.CLASS) {
            return;
        }
        DeclaredType superDeclaredType = this.typeUtils.getDeclaredType(this.abstractCodecTypeElement, this.typeUtils.erasure(typeElement.asType()));
        this.initTypeBuilder(context, typeElement, superDeclaredType);
        SchemaGenerator schemaGenerator = new SchemaGenerator(this, context);
        schemaGenerator.execute();
        new PojoCodecGenerator(this, context).execute();
        if (context.outPackage != null) {
            AptUtils.writeToFile((Element)typeElement, (TypeSpec.Builder)context.typeBuilder, (String)context.outPackage, (Messager)this.messager, (Filer)this.filer);
        } else {
            AptUtils.writeToFile((TypeElement)typeElement, (TypeSpec.Builder)context.typeBuilder, (Elements)this.elementUtils, (Messager)this.messager, (Filer)this.filer);
        }
    }

    private void cacheFields(Context context) {
        context.allMembers = BeanUtils.getAllFieldsAndMethodsWithInherit((TypeElement)context.typeElement);
        context.allFields = context.allMembers.stream().filter(e -> e.getKind() == ElementKind.FIELD && !e.getModifiers().contains((Object)Modifier.STATIC)).map(e -> (VariableElement)e).toList();
    }

    private void cacheFieldProps(Context context) {
        for (VariableElement variableElement : context.allFields) {
            AptFieldProps aptFieldProps = AptFieldProps.parse(this.typeUtils, variableElement, this.anno_DsonProperty);
            aptFieldProps.parseIgnore(this.typeUtils, variableElement, this.anno_DsonIgnore);
            TypeMirror fieldTypeMirror = variableElement.asType();
            if (aptFieldProps.implMirror == null && fieldTypeMirror.getKind() == TypeKind.DECLARED && (this.isEnumSet(fieldTypeMirror) || this.isEnumMap(fieldTypeMirror))) {
                aptFieldProps.implMirror = fieldTypeMirror;
            }
            context.fieldPropsMap.put(variableElement, aptFieldProps);
        }
    }

    private String getOutputPackage(TypeElement typeElement, AnnotationMirror annotationMirror) {
        String outPackage = (String)AptUtils.getAnnotationValueValue((AnnotationMirror)annotationMirror, (String)MNAME_OUTPUT);
        if (AptUtils.isBlank((String)outPackage)) {
            return this.elementUtils.getPackageOf(typeElement).getQualifiedName().toString();
        }
        return outPackage;
    }

    private List<AnnotationSpec> getAdditionalAnnotations(AptClassProps aptClassProps) {
        if (aptClassProps.additionalAnnotations.isEmpty()) {
            return List.of();
        }
        ArrayList<AnnotationSpec> result = new ArrayList<AnnotationSpec>(aptClassProps.additionalAnnotations.size());
        for (TypeMirror typeMirror : aptClassProps.additionalAnnotations) {
            ClassName className = (ClassName)ClassName.get((TypeMirror)typeMirror);
            result.add(AnnotationSpec.builder((ClassName)className).build());
        }
        return result;
    }

    private void initTypeBuilder(Context context, TypeElement typeElement, DeclaredType superDeclaredType) {
        context.superDeclaredType = superDeclaredType;
        context.typeBuilder = TypeSpec.classBuilder((String)this.getCodecName(typeElement)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(AptUtils.SUPPRESS_UNCHECKED_RAWTYPES).addAnnotation(this.processorInfoAnnotation).superclass(TypeName.get((TypeMirror)superDeclaredType));
    }

    private String getCodecName(TypeElement typeElement) {
        return AptUtils.getProxyClassName((Elements)this.elementUtils, (TypeElement)typeElement, (String)"Codec");
    }

    private void checkTypeElement(Context context) {
        TypeElement typeElement = context.typeElement;
        if (typeElement.getKind() != ElementKind.CLASS) {
            return;
        }
        this.checkNormalClass(context);
    }

    private void checkNormalClass(Context context) {
        AptClassProps aptClassProps = context.aptClassProps;
        if (aptClassProps.isSingleton()) {
            return;
        }
        TypeElement typeElement = context.typeElement;
        this.checkConstructor(typeElement, aptClassProps);
        List<? extends Element> allMembers = context.allMembers;
        List<Element> instMethodList = context.allMembers.stream().filter(e -> e.getKind() == ElementKind.METHOD && !e.getModifiers().contains((Object)Modifier.STATIC)).toList();
        for (VariableElement variableElement : context.allFields) {
            AptFieldProps aptFieldProps;
            if (!this.isSerializableField(variableElement, instMethodList, aptFieldProps = context.fieldPropsMap.get(variableElement))) continue;
            context.serialFields.add(variableElement);
            if (this.isAutoWriteField(variableElement, aptClassProps, aptFieldProps)) {
                this.checkAutoWriteField(variableElement, aptFieldProps, allMembers, typeElement);
            }
            if (!this.isAutoReadField(variableElement, aptClassProps, aptFieldProps)) continue;
            this.checkAutoReadField(variableElement, aptFieldProps, allMembers, typeElement);
        }
    }

    private void checkAutoReadField(VariableElement variableElement, AptFieldProps aptFieldProps, List<? extends Element> allMembers, TypeElement typeElement) {
        if (!AptUtils.isBlank((String)aptFieldProps.readProxy)) {
            return;
        }
        if (AptUtils.isBlank((String)aptFieldProps.setter) && !this.canSetDirectly(variableElement) && this.findPublicSetter(variableElement, allMembers) == null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("auto read field (%s) must be public or contains a public getter", variableElement.getSimpleName()), typeElement);
        }
    }

    private void checkAutoWriteField(VariableElement variableElement, AptFieldProps aptFieldProps, List<? extends Element> allMembers, TypeElement typeElement) {
        if (!AptUtils.isBlank((String)aptFieldProps.writeProxy)) {
            return;
        }
        if (AptUtils.isBlank((String)aptFieldProps.getter) && !this.canGetDirectly(variableElement) && this.findPublicGetter(variableElement, allMembers) == null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("auto write field (%s) must be public or contains a public getter", variableElement.getSimpleName()), typeElement);
        }
    }

    private void checkConstructor(TypeElement typeElement, AptClassProps aptClassProps) {
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return;
        }
        if (aptClassProps.containsHookMethod(MNAME_NEW_INSTANCE)) {
            return;
        }
        if (BeanUtils.containsNoArgsConstructor((TypeElement)typeElement) || this.containsReaderConstructor(typeElement) || this.containsNewInstanceMethod(typeElement)) {
            return;
        }
        this.messager.printMessage(Diagnostic.Kind.ERROR, "SerializableClass %s must contains no-args constructor or reader-args constructor!", typeElement);
    }

    public boolean containsReaderConstructor(TypeElement typeElement) {
        return typeElement.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.CONSTRUCTOR).map(e -> (ExecutableElement)e).filter(e -> e.getParameters().size() > 0).anyMatch(e -> AptUtils.isSubTypeIgnoreTypeParameter((Types)this.typeUtils, (TypeMirror)e.getParameters().get(0).asType(), (TypeMirror)this.typeMirror_DsonReader));
    }

    public boolean containsNewInstanceMethod(TypeElement typeElement) {
        List<Element> staticMembers = typeElement.getEnclosedElements().stream().filter(e -> e.getModifiers().contains((Object)Modifier.STATIC) && e.getModifiers().contains((Object)Modifier.PUBLIC)).toList();
        return this.containsHookMethod(staticMembers, MNAME_NEW_INSTANCE, this.typeMirror_DsonReader);
    }

    public boolean containsReadObjectMethod(List<? extends Element> allMembers) {
        return this.containsHookMethod(allMembers, MNAME_READ_OBJECT, this.typeMirror_DsonReader);
    }

    public boolean containsWriteObjectMethod(List<? extends Element> allMembers) {
        return this.containsHookMethod(allMembers, MNAME_WRITE_OBJECT, this.typeMirror_dsonWriter);
    }

    public boolean containsBeforeEncodeMethod(List<? extends Element> allMembers) {
        return this.containsHookMethod(allMembers, MNAME_BEFORE_ENCODE, this.typeMirror_Options);
    }

    public boolean containsAfterDecodeMethod(List<? extends Element> allMembers) {
        return this.containsHookMethod(allMembers, MNAME_AFTER_DECODE, this.typeMirror_Options);
    }

    private boolean containsHookMethod(List<? extends Element> allMembers, String methodName, TypeMirror argTypeMirror) {
        return allMembers.stream().filter(e -> e.getKind() == ElementKind.METHOD).map(e -> (ExecutableElement)e).anyMatch(e -> e.getModifiers().contains((Object)Modifier.PUBLIC) && e.getSimpleName().toString().equals(methodName) && e.getParameters().size() > 0 && AptUtils.isSameTypeIgnoreTypeParameter((Types)this.typeUtils, (TypeMirror)e.getParameters().get(0).asType(), (TypeMirror)argTypeMirror));
    }

    public boolean canGetDirectly(VariableElement variableElement) {
        return variableElement.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    public boolean canSetDirectly(VariableElement variableElement) {
        if (variableElement.getModifiers().contains((Object)Modifier.FINAL)) {
            return false;
        }
        return variableElement.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    public ExecutableElement findPublicGetter(VariableElement variableElement, List<? extends Element> allMethodWithInherit) {
        return BeanUtils.findPublicGetter((Types)this.typeUtils, (VariableElement)variableElement, allMethodWithInherit);
    }

    public ExecutableElement findPublicSetter(VariableElement variableElement, List<? extends Element> allMethodWithInherit) {
        return BeanUtils.findPublicSetter((Types)this.typeUtils, (VariableElement)variableElement, allMethodWithInherit);
    }

    private boolean isSerializableField(VariableElement variableElement, List<? extends Element> instMethodList, AptFieldProps aptFieldProps) {
        if (variableElement.getModifiers().contains((Object)Modifier.STATIC)) {
            return false;
        }
        Boolean ignore = aptFieldProps.ignore;
        if (ignore != null) {
            return ignore == false;
        }
        if (variableElement.getModifiers().contains((Object)Modifier.TRANSIENT)) {
            return false;
        }
        if (variableElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return true;
        }
        return BeanUtils.containsPublicSetter((Types)this.typeUtils, (VariableElement)variableElement, instMethodList) && BeanUtils.containsPublicGetter((Types)this.typeUtils, (VariableElement)variableElement, instMethodList);
    }

    boolean isAutoWriteField(VariableElement variableElement, AptClassProps aptClassProps, AptFieldProps aptFieldProps) {
        if (aptClassProps.isSingleton()) {
            return false;
        }
        return !this.isSkipFields(variableElement, aptClassProps);
    }

    boolean isAutoReadField(VariableElement variableElement, AptClassProps aptClassProps, AptFieldProps aptFieldProps) {
        if (aptClassProps.isSingleton()) {
            return false;
        }
        if (variableElement.getModifiers().contains((Object)Modifier.FINAL)) {
            return false;
        }
        return !this.isSkipFields(variableElement, aptClassProps);
    }

    private boolean isSkipFields(VariableElement variableElement, AptClassProps aptClassProps) {
        if (aptClassProps.skipFields.isEmpty()) {
            return false;
        }
        String fieldName = variableElement.getSimpleName().toString();
        if (aptClassProps.skipFields.contains(fieldName)) {
            return true;
        }
        if (!aptClassProps.clippedSkipFields.contains(fieldName)) {
            return false;
        }
        TypeElement declaredTypeElement = (TypeElement)variableElement.getEnclosingElement();
        String simpleClassName = declaredTypeElement.getSimpleName().toString();
        if (aptClassProps.skipFields.contains(simpleClassName + "." + fieldName)) {
            return true;
        }
        String fullClassName = declaredTypeElement.getQualifiedName().toString();
        return aptClassProps.skipFields.contains(fullClassName + "." + fieldName);
    }

    protected boolean isString(TypeMirror typeMirror) {
        return this.typeUtils.isSameType(typeMirror, this.type_String);
    }

    protected boolean isObjectPtr(TypeMirror typeMirror) {
        return this.typeUtils.isSameType(typeMirror, this.type_Ptr);
    }

    protected boolean isObjectLitePtr(TypeMirror typeMirror) {
        return this.typeUtils.isSameType(typeMirror, this.type_LitePtr);
    }

    protected boolean isLocalDateTime(TypeMirror typeMirror) {
        return this.typeUtils.isSameType(typeMirror, this.type_LocalDateTime);
    }

    protected boolean isTimestamp(TypeMirror typeMirror) {
        return this.typeUtils.isSameType(typeMirror, this.type_Timestamp);
    }

    protected boolean isByteArray(TypeMirror typeMirror) {
        return AptUtils.isByteArray((TypeMirror)typeMirror);
    }

    protected boolean isEnumSet(TypeMirror typeMirror) {
        return typeMirror == this.type_EnumSet || AptUtils.isSameTypeIgnoreTypeParameter((Types)this.typeUtils, (TypeMirror)typeMirror, (TypeMirror)this.type_EnumSet);
    }

    protected boolean isEnumMap(TypeMirror typeMirror) {
        return typeMirror == this.type_EnumMap || AptUtils.isSameTypeIgnoreTypeParameter((Types)this.typeUtils, (TypeMirror)typeMirror, (TypeMirror)this.type_EnumMap);
    }

    public MethodSpec newGetEncoderTypeMethod(DeclaredType superDeclaredType, ClassName rawTypeName) {
        return MethodSpec.overriding((ExecutableElement)this.getEncoderTypeMethod, (DeclaredType)superDeclaredType, (Types)this.typeUtils).addStatement("return encoderType", new Object[0]).addAnnotation(AptUtils.ANNOTATION_NONNULL).build();
    }

    public MethodSpec.Builder newNewInstanceMethodBuilder(DeclaredType superDeclaredType) {
        return MethodSpec.overriding((ExecutableElement)this.newInstanceMethod, (DeclaredType)superDeclaredType, (Types)this.typeUtils);
    }

    public MethodSpec.Builder newReadFieldsMethodBuilder(DeclaredType superDeclaredType) {
        return MethodSpec.overriding((ExecutableElement)this.readFieldsMethod, (DeclaredType)superDeclaredType, (Types)this.typeUtils);
    }

    public MethodSpec.Builder newAfterDecodeMethodBuilder(DeclaredType superDeclaredType) {
        return MethodSpec.overriding((ExecutableElement)this.afterDecodeMethod, (DeclaredType)superDeclaredType, (Types)this.typeUtils);
    }

    public MethodSpec.Builder newBeforeEncodeMethodBuilder(DeclaredType superDeclaredType) {
        return MethodSpec.overriding((ExecutableElement)this.beforeEncodeMethod, (DeclaredType)superDeclaredType, (Types)this.typeUtils);
    }

    public MethodSpec.Builder newWriteFieldsMethodBuilder(DeclaredType superDeclaredType) {
        return MethodSpec.overriding((ExecutableElement)this.writeFieldsMethod, (DeclaredType)superDeclaredType, (Types)this.typeUtils);
    }
}

