/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsonapt;

import cn.wjybxx.apt.AbstractGenerator;
import cn.wjybxx.apt.AptUtils;
import cn.wjybxx.apt.BeanUtils;
import cn.wjybxx.apt.MyAbstractProcessor;
import cn.wjybxx.dsonapt.AptClassProps;
import cn.wjybxx.dsonapt.AptFieldProps;
import cn.wjybxx.dsonapt.CodecProcessor;
import cn.wjybxx.dsonapt.Context;
import cn.wjybxx.dsonapt.SchemaGenerator;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

class PojoCodecGenerator
extends AbstractGenerator<CodecProcessor> {
    private final Context context;
    private final TypeSpec.Builder typeBuilder;
    private final List<? extends Element> allMembers;
    private ClassName rawTypeName;
    private boolean containsReaderConstructor;
    private boolean containsNewInstanceMethod;
    private boolean containsReadObjectMethod;
    private boolean containsWriteObjectMethod;
    private boolean containsBeforeEncodeMethod;
    private boolean containsAfterDecodeMethod;
    private MethodSpec.Builder newInstanceMethodBuilder;
    private MethodSpec.Builder readFieldsMethodBuilder;
    private MethodSpec.Builder afterDecodeMethodBuilder;
    private MethodSpec.Builder beforeEncodeMethodBuilder;
    private MethodSpec.Builder writeFieldsMethodBuilder;
    private static final String MNAME_READ_STRING = "readString";
    private static final String MNAME_READ_BYTES = "readBytes";
    private static final String MNAME_READ_OBJECT = "readObject";
    private static final String MNAME_READ_PTR = "readPtr";
    private static final String MNAME_READ_LITE_PTR = "readLitePtr";
    private static final String MNAME_READ_DATETIME = "readDateTime";
    private static final String MNAME_READ_TIMESTAMP = "readTimestamp";
    private static final String MNAME_WRITE_STRING = "writeString";
    private static final String MNAME_WRITE_BYTES = "writeBytes";
    private static final String MNAME_WRITE_OBJECT = "writeObject";
    private static final String MNAME_WRITE_PTR = "writePtr";
    private static final String MNAME_WRITE_LITE_PTR = "writeLitePtr";
    private static final String MNAME_WRITE_DATETIME = "writeDateTime";
    private static final String MNAME_WRITE_TIMESTAMP = "writeTimestamp";
    private static final Map<TypeKind, String> primitiveReadMethodNameMap = new EnumMap<TypeKind, String>(TypeKind.class);
    private static final Map<TypeKind, String> primitiveWriteMethodNameMap = new EnumMap<TypeKind, String>(TypeKind.class);

    public PojoCodecGenerator(CodecProcessor processor, Context context) {
        super((MyAbstractProcessor)processor, context.typeElement);
        this.context = context;
        this.typeBuilder = context.typeBuilder;
        this.allMembers = context.allMembers;
    }

    public void execute() {
        this.init();
        this.gen();
    }

    protected void init() {
        this.rawTypeName = ClassName.get((TypeElement)this.typeElement);
        this.containsReaderConstructor = ((CodecProcessor)this.processor).containsReaderConstructor(this.typeElement);
        this.containsNewInstanceMethod = ((CodecProcessor)this.processor).containsNewInstanceMethod(this.typeElement);
        this.containsReadObjectMethod = ((CodecProcessor)this.processor).containsReadObjectMethod(this.allMembers);
        this.containsWriteObjectMethod = ((CodecProcessor)this.processor).containsWriteObjectMethod(this.allMembers);
        this.containsBeforeEncodeMethod = ((CodecProcessor)this.processor).containsBeforeEncodeMethod(this.allMembers);
        this.containsAfterDecodeMethod = ((CodecProcessor)this.processor).containsAfterDecodeMethod(this.allMembers);
        DeclaredType superDeclaredType = this.context.superDeclaredType;
        this.newInstanceMethodBuilder = ((CodecProcessor)this.processor).newNewInstanceMethodBuilder(superDeclaredType);
        this.readFieldsMethodBuilder = ((CodecProcessor)this.processor).newReadFieldsMethodBuilder(superDeclaredType);
        this.afterDecodeMethodBuilder = ((CodecProcessor)this.processor).newAfterDecodeMethodBuilder(superDeclaredType);
        this.beforeEncodeMethodBuilder = ((CodecProcessor)this.processor).newBeforeEncodeMethodBuilder(superDeclaredType);
        this.writeFieldsMethodBuilder = ((CodecProcessor)this.processor).newWriteFieldsMethodBuilder(superDeclaredType);
    }

    protected void gen() {
        AptClassProps aptClassProps = this.context.aptClassProps;
        this.genNewInstanceMethod(aptClassProps);
        if (!aptClassProps.isSingleton()) {
            this.genWriteObjectMethod(aptClassProps);
            this.genReadObjectMethod(aptClassProps);
            for (VariableElement variableElement : this.context.serialFields) {
                AptFieldProps aptFieldProps;
                if (((CodecProcessor)this.processor).isAutoWriteField(variableElement, aptClassProps, aptFieldProps = this.context.fieldPropsMap.get(variableElement))) {
                    this.addWriteStatement(variableElement, aptFieldProps, aptClassProps);
                }
                if (!((CodecProcessor)this.processor).isAutoReadField(variableElement, aptClassProps, aptFieldProps)) continue;
                this.addReadStatement(variableElement, aptFieldProps, aptClassProps);
            }
        }
        this.typeBuilder.addField(FieldSpec.builder((TypeName)CodecProcessor.typeName_TypeInfo, (String)"encoderType", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
        this.typeBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("this.encoderType = " + SchemaGenerator.rawEncoderTypeFieldName(), new Object[0]).build());
        this.typeBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)CodecProcessor.typeName_TypeInfo, "encoderType", new Modifier[0]).addStatement("this.encoderType = encoderType", new Object[0]).build());
        this.typeBuilder.addMethod(((CodecProcessor)this.processor).newGetEncoderTypeMethod(this.context.superDeclaredType, this.rawTypeName));
        if (this.genBeforeEncodeMethod(aptClassProps)) {
            this.typeBuilder.addMethod(this.beforeEncodeMethodBuilder.build());
        }
        this.typeBuilder.addMethod(this.writeFieldsMethodBuilder.build());
        this.typeBuilder.addMethod(this.newInstanceMethodBuilder.build()).addMethod(this.readFieldsMethodBuilder.build());
        if (this.genAfterDecodeMethod(aptClassProps)) {
            this.typeBuilder.addMethod(this.afterDecodeMethodBuilder.build());
        }
        if (this.context.additionalAnnotations != null) {
            this.typeBuilder.addAnnotations(this.context.additionalAnnotations);
        }
    }

    private boolean genReadObjectMethod(AptClassProps aptClassProps) {
        if (aptClassProps.codecProxyTypeElement != null) {
            if (aptClassProps.containsHookMethod(MNAME_READ_OBJECT)) {
                this.readFieldsMethodBuilder.addStatement("$T.$L(inst, reader)", new Object[]{aptClassProps.codecProxyClassName, MNAME_READ_OBJECT});
                return true;
            }
        } else if (this.containsReadObjectMethod) {
            this.readFieldsMethodBuilder.addStatement("inst.$L(reader)", new Object[]{MNAME_READ_OBJECT});
            return true;
        }
        return false;
    }

    private boolean genWriteObjectMethod(AptClassProps aptClassProps) {
        if (aptClassProps.codecProxyTypeElement != null) {
            if (aptClassProps.containsHookMethod(MNAME_WRITE_OBJECT)) {
                this.writeFieldsMethodBuilder.addStatement("$T.$L(inst, writer)", new Object[]{aptClassProps.codecProxyClassName, MNAME_WRITE_OBJECT});
                return true;
            }
        } else if (this.containsWriteObjectMethod) {
            this.writeFieldsMethodBuilder.addStatement("inst.$L(writer)", new Object[]{MNAME_WRITE_OBJECT});
            return true;
        }
        return false;
    }

    private boolean genBeforeEncodeMethod(AptClassProps aptClassProps) {
        if (aptClassProps.codecProxyTypeElement != null) {
            if (aptClassProps.containsHookMethod("beforeEncode")) {
                this.beforeEncodeMethodBuilder.addStatement("$T.$L(inst, writer.options())", new Object[]{aptClassProps.codecProxyClassName, "beforeEncode"});
                return true;
            }
        } else if (this.containsBeforeEncodeMethod) {
            this.beforeEncodeMethodBuilder.addStatement("inst.$L(writer.options())", new Object[]{"beforeEncode"});
            return true;
        }
        return false;
    }

    private boolean genAfterDecodeMethod(AptClassProps aptClassProps) {
        if (aptClassProps.codecProxyTypeElement != null) {
            if (aptClassProps.containsHookMethod("afterDecode")) {
                this.afterDecodeMethodBuilder.addStatement("$T.$L(inst, reader.options())", new Object[]{aptClassProps.codecProxyClassName, "afterDecode"});
                return true;
            }
        } else if (this.containsAfterDecodeMethod) {
            this.afterDecodeMethodBuilder.addStatement("inst.$L(reader.options())", new Object[]{"afterDecode"});
            return true;
        }
        return false;
    }

    private void genNewInstanceMethod(AptClassProps aptClassProps) {
        if (aptClassProps.isSingleton()) {
            Object holder = aptClassProps.codecProxyTypeElement != null ? aptClassProps.codecProxyClassName : this.rawTypeName;
            this.newInstanceMethodBuilder.addStatement("return $T.$L()", new Object[]{holder, aptClassProps.singleton});
            return;
        }
        if (this.typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.newInstanceMethodBuilder.addStatement("throw new $T()", new Object[]{UnsupportedOperationException.class});
            return;
        }
        if (aptClassProps.codecProxyTypeElement != null && aptClassProps.containsHookMethod("newInstance")) {
            this.newInstanceMethodBuilder.addStatement("return $T.$L(reader, $L())", new Object[]{aptClassProps.codecProxyClassName, "newInstance", "getEncoderType"});
            return;
        }
        if (this.containsNewInstanceMethod) {
            this.newInstanceMethodBuilder.addStatement("return $T.$L(reader, $L())", new Object[]{this.rawTypeName, "newInstance", "getEncoderType"});
        } else if (this.containsReaderConstructor) {
            this.newInstanceMethodBuilder.addStatement("return new $T(reader, $L())", new Object[]{this.rawTypeName, "getEncoderType"});
        } else {
            this.newInstanceMethodBuilder.addStatement("return new $T()", new Object[]{this.rawTypeName});
        }
    }

    private void addReadStatement(VariableElement variableElement, AptFieldProps fieldProps, AptClassProps aptClassProps) {
        boolean hasCustomSetter;
        String fieldName = variableElement.getSimpleName().toString();
        MethodSpec.Builder builder = this.readFieldsMethodBuilder;
        if (!AptUtils.isBlank((String)fieldProps.readProxy)) {
            if (aptClassProps.codecProxyTypeElement != null) {
                builder.addStatement("$T.$L(inst, reader, $L)", new Object[]{aptClassProps.codecProxyClassName, fieldProps.readProxy, this.serialName(fieldName)});
            } else {
                builder.addStatement("inst.$L(reader, $L)", new Object[]{fieldProps.readProxy, this.serialName(fieldName)});
            }
            return;
        }
        builder.addCode("if (reader.readName($L)) ", new Object[]{this.serialName(fieldName)});
        String readMethodName = this.getReadMethodName(variableElement);
        ExecutableElement setterMethod = ((CodecProcessor)this.processor).findPublicSetter(variableElement, this.allMembers);
        boolean bl = hasCustomSetter = !AptUtils.isBlank((String)fieldProps.setter);
        if (hasCustomSetter || setterMethod != null) {
            String fieldAccess;
            String string = fieldAccess = hasCustomSetter ? fieldProps.setter : setterMethod.getSimpleName().toString();
            if (readMethodName.equals(MNAME_READ_OBJECT)) {
                builder.addStatement("inst.$L(reader.$L(null, $L, $L))", new Object[]{fieldAccess, readMethodName, this.serialTypeInfo(fieldName), fieldProps.implMirror == null ? "null" : this.serialFactory(fieldName)});
            } else {
                builder.addStatement("inst.$L(reader.$L(null))", new Object[]{fieldAccess, readMethodName});
            }
        } else if (readMethodName.equals(MNAME_READ_OBJECT)) {
            builder.addStatement("inst.$L = reader.$L(null, $L, $L)", new Object[]{fieldName, readMethodName, this.serialTypeInfo(fieldName), fieldProps.implMirror == null ? "null" : this.serialFactory(fieldName)});
        } else {
            builder.addStatement("inst.$L = reader.$L(null)", new Object[]{fieldName, readMethodName});
        }
    }

    private void addWriteStatement(VariableElement variableElement, AptFieldProps fieldProps, AptClassProps aptClassProps) {
        String fieldName = variableElement.getSimpleName().toString();
        MethodSpec.Builder builder = this.writeFieldsMethodBuilder;
        if (!AptUtils.isBlank((String)fieldProps.writeProxy)) {
            if (aptClassProps.codecProxyTypeElement != null) {
                builder.addStatement("$T.$L(inst, writer, $L)", new Object[]{aptClassProps.codecProxyClassName, fieldProps.writeProxy, this.serialName(fieldName)});
            } else {
                builder.addStatement("inst.$L(writer, $L)", new Object[]{fieldProps.writeProxy, this.serialName(fieldName)});
            }
            return;
        }
        boolean hasCustomGetter = !AptUtils.isBlank((String)fieldProps.getter);
        ExecutableElement getterMethod = ((CodecProcessor)this.processor).findPublicGetter(variableElement, this.allMembers);
        Object fieldAccess = hasCustomGetter ? fieldProps.getter + "()" : (getterMethod != null ? String.valueOf(getterMethod.getSimpleName()) + "()" : fieldName);
        String writeMethodName = this.getWriteMethodName(variableElement);
        if (AptUtils.isPrimitiveNumber((TypeMirror)variableElement.asType())) {
            builder.addStatement("writer.$L($L, inst.$L, $T.$L)", new Object[]{writeMethodName, this.serialName(fieldName), fieldAccess, CodecProcessor.typeName_NumberStyle, fieldProps.numberStyle});
            return;
        }
        switch (writeMethodName) {
            case "writeString": {
                builder.addStatement("writer.$L($L, inst.$L, $T.$L)", new Object[]{writeMethodName, this.serialName(fieldName), fieldAccess, CodecProcessor.typeName_StringStyle, fieldProps.stringStyle});
                break;
            }
            case "writeObject": {
                if (fieldProps.objectStyle != null) {
                    builder.addStatement("writer.$L($L, inst.$L, $L, $T.$L)", new Object[]{writeMethodName, this.serialName(fieldName), fieldAccess, this.serialTypeInfo(fieldName), CodecProcessor.typeName_ObjectStyle, fieldProps.objectStyle});
                    break;
                }
                builder.addStatement("writer.$L($L, inst.$L, $L, null)", new Object[]{writeMethodName, this.serialName(fieldName), fieldAccess, this.serialTypeInfo(fieldName)});
                break;
            }
            default: {
                builder.addStatement("writer.$L($L, inst.$L)", new Object[]{writeMethodName, this.serialName(fieldName), fieldAccess});
            }
        }
    }

    private String serialName(String fieldName) {
        return SchemaGenerator.nameFileName(fieldName);
    }

    private String serialTypeInfo(String fieldName) {
        return SchemaGenerator.typeInfoFieldName(fieldName);
    }

    private String serialFactory(String fieldName) {
        return SchemaGenerator.factoryFieldName(fieldName);
    }

    private String getWriteMethodName(VariableElement variableElement) {
        TypeMirror typeMirror = variableElement.asType();
        if (PojoCodecGenerator.isPrimitiveType(typeMirror)) {
            return primitiveWriteMethodNameMap.get((Object)typeMirror.getKind());
        }
        if (((CodecProcessor)this.processor).isString(typeMirror)) {
            return MNAME_WRITE_STRING;
        }
        if (((CodecProcessor)this.processor).isByteArray(typeMirror)) {
            return MNAME_WRITE_BYTES;
        }
        if (((CodecProcessor)this.processor).isObjectPtr(typeMirror)) {
            return MNAME_WRITE_PTR;
        }
        if (((CodecProcessor)this.processor).isObjectLitePtr(typeMirror)) {
            return MNAME_WRITE_LITE_PTR;
        }
        if (((CodecProcessor)this.processor).isLocalDateTime(typeMirror)) {
            return MNAME_WRITE_DATETIME;
        }
        if (((CodecProcessor)this.processor).isTimestamp(typeMirror)) {
            return MNAME_WRITE_TIMESTAMP;
        }
        return MNAME_WRITE_OBJECT;
    }

    private String getReadMethodName(VariableElement variableElement) {
        TypeMirror typeMirror = variableElement.asType();
        if (PojoCodecGenerator.isPrimitiveType(typeMirror)) {
            return primitiveReadMethodNameMap.get((Object)typeMirror.getKind());
        }
        if (((CodecProcessor)this.processor).isString(typeMirror)) {
            return MNAME_READ_STRING;
        }
        if (((CodecProcessor)this.processor).isByteArray(typeMirror)) {
            return MNAME_READ_BYTES;
        }
        if (((CodecProcessor)this.processor).isObjectPtr(typeMirror)) {
            return MNAME_READ_PTR;
        }
        if (((CodecProcessor)this.processor).isObjectLitePtr(typeMirror)) {
            return MNAME_READ_LITE_PTR;
        }
        if (((CodecProcessor)this.processor).isLocalDateTime(typeMirror)) {
            return MNAME_READ_DATETIME;
        }
        if (((CodecProcessor)this.processor).isTimestamp(typeMirror)) {
            return MNAME_READ_TIMESTAMP;
        }
        return MNAME_READ_OBJECT;
    }

    private static boolean isPrimitiveType(TypeMirror typeMirror) {
        return typeMirror.getKind().isPrimitive();
    }

    static {
        for (TypeKind typeKind : TypeKind.values()) {
            if (!typeKind.isPrimitive()) continue;
            String name = BeanUtils.firstCharToUpperCase((String)typeKind.name().toLowerCase());
            primitiveReadMethodNameMap.put(typeKind, "read" + name);
            primitiveWriteMethodNameMap.put(typeKind, "write" + name);
        }
    }
}

