/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsonapt;

import cn.wjybxx.apt.AbstractGenerator;
import cn.wjybxx.apt.AptUtils;
import cn.wjybxx.apt.MyAbstractProcessor;
import cn.wjybxx.dsonapt.AptFieldProps;
import cn.wjybxx.dsonapt.CodecProcessor;
import cn.wjybxx.dsonapt.Context;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.tools.Diagnostic;

class SchemaGenerator
extends AbstractGenerator<CodecProcessor> {
    private final Context context;
    private final ClassName typeName_TypeInfo;

    public SchemaGenerator(CodecProcessor processor, Context context) {
        super((MyAbstractProcessor)processor, context.typeElement);
        this.context = context;
        this.typeName_TypeInfo = CodecProcessor.typeName_TypeInfo;
    }

    public void execute() {
        List<FieldSpec> typesFields = this.genTypeFields(this.context.serialFields);
        List<FieldSpec> factoryFields = this.genFactoryFields(this.context.serialFields);
        List<FieldSpec> namesSpec = this.genNameFields();
        this.context.typeBuilder.addField(this.genRawEncoderTypeFiled()).addFields(typesFields).addFields(factoryFields).addFields(namesSpec);
    }

    static String rawEncoderTypeFieldName() {
        return "_rawEncoderType";
    }

    static String factoryFieldName(String fieldName) {
        return "factories_" + fieldName;
    }

    static String typeInfoFieldName(String fieldName) {
        return "types_" + fieldName;
    }

    static String nameFileName(String fieldName) {
        return "names_" + fieldName;
    }

    private List<FieldSpec> genFactoryFields(List<VariableElement> allSerialFields) {
        ArrayList<FieldSpec> typeFieldList = new ArrayList<FieldSpec>(allSerialFields.size());
        for (VariableElement variableElement : allSerialFields) {
            AptFieldProps fieldProps = this.context.fieldPropsMap.get(variableElement);
            if (fieldProps.implMirror == null) continue;
            typeFieldList.add(this.genFactoryField(variableElement, fieldProps.implMirror));
        }
        return typeFieldList;
    }

    private FieldSpec genFactoryField(VariableElement variableElement, TypeMirror implMirror) {
        TypeMirror typeMirror = variableElement.asType();
        ParameterizedTypeName fieldTypeName = ParameterizedTypeName.get((ClassName)AptUtils.CLSNAME_SUPPLIER, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)typeMirror)});
        String factoryFieldName = SchemaGenerator.factoryFieldName(variableElement.getSimpleName().toString());
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)fieldTypeName, (String)factoryFieldName, (Modifier[])AptUtils.PUBLIC_STATIC_FINAL);
        if (((CodecProcessor)this.processor).isEnumMap(implMirror)) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            builder.initializer("() -> new EnumMap<>($T.class)", new Object[]{TypeName.get((TypeMirror)this.typeUtils.erasure(declaredType.getTypeArguments().get(0)))});
        } else if (((CodecProcessor)this.processor).isEnumSet(implMirror)) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            builder.initializer("() -> EnumSet.noneOf($T.class)", new Object[]{TypeName.get((TypeMirror)this.typeUtils.erasure(declaredType.getTypeArguments().get(0)))});
        } else {
            builder.initializer("$T::new", new Object[]{TypeName.get((TypeMirror)this.typeUtils.erasure(implMirror))});
        }
        return builder.build();
    }

    private List<FieldSpec> genTypeFields(List<VariableElement> allSerialFields) {
        return allSerialFields.stream().filter(e -> this.needTypeInfoFields(e.asType())).map(this::genTypeField).toList();
    }

    private boolean needTypeInfoFields(TypeMirror typeMirror) {
        return !typeMirror.getKind().isPrimitive() && !((CodecProcessor)this.processor).isString(typeMirror) && !((CodecProcessor)this.processor).isByteArray(typeMirror);
    }

    private FieldSpec genTypeField(VariableElement variableElement) {
        TypeMirror typeMirror = variableElement.asType();
        String typeInfoFieldName = SchemaGenerator.typeInfoFieldName(variableElement.getSimpleName().toString());
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)this.typeName_TypeInfo, (String)typeInfoFieldName, (Modifier[])AptUtils.PUBLIC_STATIC_FINAL);
        StringBuilder format = new StringBuilder(16);
        ArrayList<Object> params = new ArrayList<Object>(4);
        this.appendTypeInfo(typeMirror, format, params);
        builder.initializer(format.toString(), params.toArray());
        return builder.build();
    }

    private void appendTypeInfo(TypeMirror typeMirror, StringBuilder format, List<Object> params) {
        boolean nested;
        List<Object> typeArguments = List.of();
        switch (typeMirror.getKind()) {
            case ARRAY: {
                ArrayType arrayType = (ArrayType)typeMirror;
                typeArguments = SchemaGenerator.getArrayTypeArguments(arrayType);
                break;
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                typeArguments = declaredType.getTypeArguments();
            }
        }
        if (typeArguments.isEmpty()) {
            format.append("$T.of($T.class)");
            params.add(this.typeName_TypeInfo);
            params.add(TypeName.get((TypeMirror)this.typeUtils.erasure(typeMirror)));
            return;
        }
        boolean bl = nested = format.length() > 0;
        if (nested) {
            format.append("\n$>");
        }
        format.append("$T.of($T.class, ");
        params.add(this.typeName_TypeInfo);
        params.add(TypeName.get((TypeMirror)this.typeUtils.erasure(typeMirror)));
        for (int i = 0; i < typeArguments.size(); ++i) {
            if (i > 0) {
                format.append(", ");
            }
            TypeMirror constructedType = this.toConstructedType((TypeMirror)typeArguments.get(i));
            this.appendTypeInfo(constructedType, format, params);
        }
        if (nested) {
            format.append("$<");
        }
        format.append(")");
    }

    private FieldSpec genRawEncoderTypeFiled() {
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)this.typeName_TypeInfo, (String)SchemaGenerator.rawEncoderTypeFieldName(), (Modifier[])AptUtils.PRIVATE_STATIC_FINAL);
        List<? extends TypeParameterElement> typeParameters = this.typeElement.getTypeParameters();
        StringBuilder format = new StringBuilder(16);
        ArrayList<Object> params = new ArrayList<Object>(4);
        if (typeParameters.isEmpty()) {
            format.append("$T.of($T.class)");
            params.add(this.typeName_TypeInfo);
            params.add(TypeName.get((TypeMirror)this.typeUtils.erasure(this.typeElement.asType())));
        } else {
            format.append("$T.of($T.class, ");
            params.add(this.typeName_TypeInfo);
            params.add(TypeName.get((TypeMirror)this.typeUtils.erasure(this.typeElement.asType())));
            for (int i = 0; i < typeParameters.size(); ++i) {
                if (i > 0) {
                    format.append(", ");
                }
                format.append("$T.of($T.class)");
                params.add(this.typeName_TypeInfo);
                params.add(TypeName.get((TypeMirror)this.typeUtils.erasure(typeParameters.get(i).asType())));
            }
            format.append(")");
        }
        builder.initializer(format.toString(), params.toArray());
        return builder.build();
    }

    private List<FieldSpec> genNameFields() {
        List<VariableElement> serialFields = this.context.serialFields;
        HashSet<String> dsonNameSet = new HashSet<String>((int)((float)serialFields.size() * 1.35f));
        ArrayList<FieldSpec> fieldSpecList = new ArrayList<FieldSpec>(serialFields.size());
        for (VariableElement variableElement : serialFields) {
            AptFieldProps properties = this.context.fieldPropsMap.get(variableElement);
            String fieldName = variableElement.getSimpleName().toString();
            String dsonName = !AptUtils.isBlank((String)properties.name) ? properties.name.trim() : fieldName;
            if (!dsonNameSet.add(dsonName)) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("dsonName is duplicate, dsonName %s", dsonName), variableElement);
                continue;
            }
            fieldSpecList.add(FieldSpec.builder((TypeName)AptUtils.CLSNAME_STRING, (String)SchemaGenerator.nameFileName(fieldName), (Modifier[])AptUtils.PUBLIC_STATIC_FINAL).initializer("$S", new Object[]{dsonName}).build());
        }
        return fieldSpecList;
    }

    private TypeMirror toConstructedType(TypeMirror typeMirror) {
        if (typeMirror.getKind().isPrimitive()) {
            return typeMirror;
        }
        TypeKind typeKind = typeMirror.getKind();
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"WILDCARD", "TYPEVAR", "DECLARED", "ARRAY"}, (TypeKind)typeKind, n)) {
            case 0: {
                WildcardType wildcardType = (WildcardType)typeMirror;
                if (wildcardType.getExtendsBound() != null) {
                    return this.typeUtils.erasure(wildcardType.getExtendsBound());
                }
                return ((CodecProcessor)this.processor).type_Object;
            }
            case 1: {
                TypeVariable typeVariable = (TypeVariable)typeMirror;
                return this.typeUtils.erasure(typeVariable.getUpperBound());
            }
            case 2: {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                if (this.isConstructedType(declaredType)) {
                    return declaredType;
                }
                List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                TypeMirror[] copiedTypeArgs = new TypeMirror[typeArguments.size()];
                for (int i = 0; i < typeArguments.size(); ++i) {
                    TypeMirror nestTypeMirror = typeArguments.get(i);
                    copiedTypeArgs[i] = this.toConstructedType(nestTypeMirror);
                }
                TypeElement element = (TypeElement)declaredType.asElement();
                TypeMirror typeMirror2 = declaredType.getEnclosingType();
                if (typeMirror2 instanceof DeclaredType) {
                    DeclaredType enclosingType = (DeclaredType)typeMirror2;
                    return this.typeUtils.getDeclaredType(enclosingType, element, copiedTypeArgs);
                }
                return this.typeUtils.getDeclaredType(element, copiedTypeArgs);
            }
            case 3: {
                ArrayType arrayType = (ArrayType)typeMirror;
                if (this.isConstructedType(arrayType)) {
                    return arrayType;
                }
                TypeMirror rootComponentType = AptUtils.getRootComponentType((ArrayType)arrayType);
                TypeMirror rootComponentType2 = this.toConstructedType(rootComponentType);
                int arrayRank = AptUtils.getArrayRank((ArrayType)arrayType);
                ArrayType copiedArrayType = this.typeUtils.getArrayType(rootComponentType2);
                for (int i = 1; i < arrayRank; ++i) {
                    copiedArrayType = this.typeUtils.getArrayType(copiedArrayType);
                }
                return copiedArrayType;
            }
        }
        return this.typeUtils.erasure(typeMirror);
    }

    private boolean isConstructedType(TypeMirror typeMirror) {
        if (typeMirror.getKind().isPrimitive()) {
            return true;
        }
        switch (typeMirror.getKind()) {
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                if (typeArguments.isEmpty()) {
                    return true;
                }
                for (int i = 0; i < typeArguments.size(); ++i) {
                    TypeMirror nestTypeMirror = typeArguments.get(i);
                    if (this.isConstructedType(nestTypeMirror)) continue;
                    return false;
                }
                return true;
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)typeMirror;
                TypeMirror rootComponentType = AptUtils.getRootComponentType((ArrayType)arrayType);
                return this.isConstructedType(rootComponentType);
            }
            case VOID: 
            case NONE: 
            case NULL: {
                return true;
            }
        }
        return false;
    }

    private static List<? extends TypeMirror> getArrayTypeArguments(ArrayType arrayType) {
        TypeMirror rootComponentType = AptUtils.getRootComponentType((ArrayType)arrayType);
        if (rootComponentType instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)rootComponentType;
            return declaredType.getTypeArguments();
        }
        return List.of();
    }
}

