/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonConverterUtils;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public abstract class AbstractDsonCodec<T>
implements DsonCodec<T> {
    @Override
    @Nonnull
    public abstract Class<T> getEncoderClass();

    @Override
    public boolean autoStartEnd() {
        return true;
    }

    @Override
    public boolean isWriteAsArray() {
        return DsonConverterUtils.isEncodeAsArray(this.getEncoderClass());
    }

    @Override
    public void writeObject(DsonObjectWriter writer, T instance, TypeInfo<?> typeInfo, ObjectStyle style) {
        if (writer.options().enableBeforeEncode) {
            this.beforeEncode(writer, instance, typeInfo, style);
        }
        this.writeFields(writer, instance, typeInfo, style);
    }

    protected void beforeEncode(DsonObjectWriter writer, T instance, TypeInfo<?> typeInfo, ObjectStyle style) {
    }

    public abstract void writeFields(DsonObjectWriter var1, T var2, TypeInfo<?> var3, ObjectStyle var4);

    @Override
    public T readObject(DsonObjectReader reader, TypeInfo<?> typeInfo, Supplier<? extends T> factory) {
        T instance = factory != null ? factory.get() : this.newInstance(reader, typeInfo);
        this.readFields(reader, instance, typeInfo);
        if (reader.options().enableAfterDecode) {
            this.afterDecode(reader, instance, typeInfo);
        }
        return instance;
    }

    protected abstract T newInstance(DsonObjectReader var1, TypeInfo<?> var2);

    public abstract void readFields(DsonObjectReader var1, T var2, TypeInfo<?> var3);

    protected void afterDecode(DsonObjectReader reader, T instance, TypeInfo<?> typeInfo) {
    }
}

