/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.dson.DsonCollectionReader;
import cn.wjybxx.dson.DsonNull;
import cn.wjybxx.dson.DsonReader;
import cn.wjybxx.dson.DsonType;
import cn.wjybxx.dson.DsonValue;
import cn.wjybxx.dsoncodec.AbstractObjectReader;
import cn.wjybxx.dsoncodec.DsonConverter;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

final class BufferedDsonObjectReader
extends AbstractObjectReader
implements DsonObjectReader {
    public BufferedDsonObjectReader(DsonConverter converter, DsonCollectionReader reader) {
        super(converter, (DsonReader)reader);
    }

    @Override
    public boolean readName(String name) {
        DsonReader reader = this.reader;
        if (reader.getContextType().isArrayLike()) {
            if (reader.isAtValue()) {
                return true;
            }
            if (reader.isAtType()) {
                return reader.readDsonType() != DsonType.END_OF_OBJECT;
            }
            return reader.getCurrentDsonType() != DsonType.END_OF_OBJECT;
        }
        if (reader.isAtValue()) {
            if (reader.getCurrentName().equals(name)) {
                return true;
            }
            reader.skipValue();
        }
        Objects.requireNonNull(name, "name");
        if (reader.isAtType()) {
            KeyIterator keyItr = (KeyIterator)reader.attachment();
            if (keyItr.keySet.contains(name)) {
                keyItr.setNext(name);
                reader.readDsonType();
                reader.readName();
                return true;
            }
            return false;
        }
        if (reader.getCurrentDsonType() == DsonType.END_OF_OBJECT) {
            return false;
        }
        reader.readName(name);
        return true;
    }

    @Override
    public void readStartObject() {
        super.readStartObject();
        DsonCollectionReader reader = (DsonCollectionReader)this.reader;
        ArrayDeque keyQueue = (ArrayDeque)this.converter.options().keySetPool.acquire();
        KeyIterator keyItr = new KeyIterator(reader.getkeySet(), keyQueue);
        reader.setKeyItr((Iterator)keyItr, (DsonValue)DsonNull.NULL);
        reader.attach((Object)keyItr);
    }

    @Override
    public void readEndObject() {
        KeyIterator keyItr = (KeyIterator)this.reader.attach(null);
        super.readEndObject();
        this.converter.options().keySetPool.release(keyItr.keyQueue);
        keyItr.keyQueue = null;
    }

    private static class KeyIterator
    implements Iterator<String> {
        Set<String> keySet;
        ArrayDeque<String> keyQueue;

        public KeyIterator(Set<String> keySet, ArrayDeque<String> keyQueue) {
            this.keySet = keySet;
            this.keyQueue = keyQueue;
            keyQueue.addAll(keySet);
        }

        public void setNext(String nextName) {
            Objects.requireNonNull(nextName);
            if (Objects.equals(this.keyQueue.peekFirst(), nextName)) {
                return;
            }
            this.keyQueue.removeFirstOccurrence(nextName);
            this.keyQueue.addFirst(nextName);
        }

        @Override
        public boolean hasNext() {
            return !this.keyQueue.isEmpty();
        }

        @Override
        public String next() {
            return this.keyQueue.removeFirst();
        }
    }
}

