/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

public final class ClassId {
    public static final int DEFAULT_NAMESPACE = 0;
    public static final ClassId OBJECT = new ClassId(0, 0);
    private final int namespace;
    private final int lclassId;

    public ClassId(int namespace, int lclassId) {
        if (namespace < 0) {
            throw new IllegalArgumentException("invalid namespace " + namespace);
        }
        this.namespace = namespace;
        this.lclassId = lclassId;
    }

    public int getNamespace() {
        return this.namespace;
    }

    public int getLclassId() {
        return this.lclassId;
    }

    public boolean isDefaultNameSpace() {
        return this.namespace == 0;
    }

    public static ClassId ofDefaultNameSpace(int lclassId) {
        return new ClassId(0, lclassId);
    }

    public static boolean isObjectClassId(ClassId classId) {
        if (classId == OBJECT) {
            return true;
        }
        return classId.namespace == 0 && classId.lclassId == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassId that = (ClassId)o;
        return this.namespace == that.namespace && this.lclassId == that.lclassId;
    }

    public int hashCode() {
        return 31 * this.namespace + this.lclassId;
    }

    public String toString() {
        return "BinClassId{namespace=" + this.namespace + ", classId=" + this.lclassId + "}";
    }
}

