/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.dson.io.DsonChunk;
import cn.wjybxx.dsoncodec.TypeInfo;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface Converter {
    public byte[] write(Object var1, TypeInfo<?> var2);

    public <T> T read(byte[] var1, TypeInfo<T> var2, @Nullable Supplier<? extends T> var3);

    public void write(Object var1, TypeInfo<?> var2, DsonChunk var3);

    public <T> T read(DsonChunk var1, TypeInfo<T> var2, @Nullable Supplier<? extends T> var3);

    default public <T> T read(byte[] source, TypeInfo<T> typeInfo) {
        return this.read(new DsonChunk(source), typeInfo, null);
    }

    default public <T> T read(DsonChunk chunk, TypeInfo<T> typeInfo) {
        return this.read(chunk, typeInfo, null);
    }

    default public byte[] write(Object value) {
        return this.write(value, TypeInfo.OBJECT);
    }

    default public Object read(byte[] source) {
        return this.read(source, TypeInfo.OBJECT);
    }

    default public int write(Object value, TypeInfo<?> typeInfo, byte[] buffer) {
        DsonChunk chunk = new DsonChunk(buffer);
        this.write(value, typeInfo, chunk);
        return chunk.getUsed();
    }

    default public <T> T cloneObject(Object value, TypeInfo<T> typeInfo, @Nullable Supplier<? extends T> factory) {
        if (value == null) {
            return null;
        }
        byte[] data = this.write(value, TypeInfo.of(value.getClass()));
        return this.read(data, typeInfo, factory);
    }

    default public <T> T cloneObject(Object value, TypeInfo<T> typeInfo) {
        return this.cloneObject(value, typeInfo, null);
    }
}

