/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.base.io.StringBuilderWriter;
import cn.wjybxx.dson.DsonArray;
import cn.wjybxx.dson.DsonBinaryReader;
import cn.wjybxx.dson.DsonBinaryWriter;
import cn.wjybxx.dson.DsonCollectionReader;
import cn.wjybxx.dson.DsonCollectionWriter;
import cn.wjybxx.dson.DsonReader;
import cn.wjybxx.dson.DsonValue;
import cn.wjybxx.dson.DsonWriter;
import cn.wjybxx.dson.Dsons;
import cn.wjybxx.dson.io.DsonChunk;
import cn.wjybxx.dson.io.DsonInput;
import cn.wjybxx.dson.io.DsonInputs;
import cn.wjybxx.dson.io.DsonOutput;
import cn.wjybxx.dson.io.DsonOutputs;
import cn.wjybxx.dson.text.DsonTextReader;
import cn.wjybxx.dson.text.DsonTextWriter;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.BufferedDsonObjectReader;
import cn.wjybxx.dsoncodec.ConverterOptions;
import cn.wjybxx.dsoncodec.DefaultDsonObjectReader;
import cn.wjybxx.dsoncodec.DefaultDsonObjectWriter;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonCodecImpl;
import cn.wjybxx.dsoncodec.DsonCodecRegistries;
import cn.wjybxx.dsoncodec.DsonCodecRegistry;
import cn.wjybxx.dsoncodec.DsonConverter;
import cn.wjybxx.dsoncodec.DsonConverterUtils;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.TypeMeta;
import cn.wjybxx.dsoncodec.TypeMetaRegistries;
import cn.wjybxx.dsoncodec.TypeMetaRegistry;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultDsonConverter
implements DsonConverter {
    private final TypeMetaRegistry typeMetaRegistry;
    private final DsonCodecRegistry codecRegistry;
    private final ConverterOptions options;

    private DefaultDsonConverter(TypeMetaRegistry typeMetaRegistry, DsonCodecRegistry codecRegistry, ConverterOptions options) {
        this.codecRegistry = codecRegistry;
        this.typeMetaRegistry = typeMetaRegistry;
        this.options = options;
    }

    @Override
    public DsonCodecRegistry codecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public TypeMetaRegistry typeMetaRegistry() {
        return this.typeMetaRegistry;
    }

    @Override
    public ConverterOptions options() {
        return this.options;
    }

    @Override
    public DsonConverter withOptions(ConverterOptions options) {
        Objects.requireNonNull(options);
        return new DefaultDsonConverter(this.typeMetaRegistry, this.codecRegistry, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public byte[] write(Object value, @Nonnull TypeInfo<?> typeInfo) {
        Objects.requireNonNull(value);
        byte[] localBuffer = (byte[])this.options.bufferPool.acquire(this.options.bufferSize);
        try {
            DsonChunk chunk = new DsonChunk(localBuffer);
            this.write(value, typeInfo, chunk);
            byte[] byArray = chunk.usedPayload();
            return byArray;
        }
        finally {
            this.options.bufferPool.release((Object)localBuffer);
        }
    }

    @Override
    public <T> T read(byte[] source, @Nonnull TypeInfo<T> typeInfo, Supplier<? extends T> factory) {
        DsonInput inputStream = DsonInputs.newInstance((byte[])source);
        return this.decodeObject(inputStream, typeInfo, factory);
    }

    @Override
    public void write(Object value, TypeInfo<?> typeInfo, DsonChunk chunk) {
        Objects.requireNonNull(value);
        DsonOutput outputStream = DsonOutputs.newInstance((byte[])chunk.getBuffer(), (int)chunk.getOffset(), (int)chunk.getLength());
        this.encodeObject(outputStream, value, typeInfo);
        chunk.setUsed(outputStream.getPosition());
    }

    @Override
    public <T> T read(DsonChunk chunk, TypeInfo<T> typeInfo, Supplier<? extends T> factory) {
        DsonInput inputStream = DsonInputs.newInstance((byte[])chunk.getBuffer(), (int)chunk.getOffset(), (int)chunk.getLength());
        return this.decodeObject(inputStream, typeInfo, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T cloneObject(Object value, TypeInfo<T> typeInfo, Supplier<? extends T> factory) {
        if (value == null) {
            return null;
        }
        byte[] localBuffer = (byte[])this.options.bufferPool.acquire(this.options.bufferSize);
        try {
            DsonOutput outputStream = DsonOutputs.newInstance((byte[])localBuffer);
            this.encodeObject(outputStream, value, typeInfo);
            DsonInput inputStream = DsonInputs.newInstance((byte[])localBuffer, (int)0, (int)outputStream.getPosition());
            T t = this.decodeObject(inputStream, typeInfo, factory);
            return t;
        }
        finally {
            this.options.bufferPool.release((Object)localBuffer);
        }
    }

    private void encodeObject(DsonOutput outputStream, @Nullable Object value, TypeInfo<?> typeInfo) {
        try (DefaultDsonObjectWriter wrapper = new DefaultDsonObjectWriter(this, (DsonWriter)new DsonBinaryWriter(this.options.binWriterSettings, outputStream));){
            wrapper.writeObject(null, value, typeInfo, null);
            wrapper.flush();
        }
    }

    private <T> T decodeObject(DsonInput inputStream, TypeInfo<T> typeInfo, Supplier<? extends T> factory) {
        try (DsonObjectReader wrapper = this.wrapReader((DsonReader)new DsonBinaryReader(this.options.binReaderSettings, inputStream));){
            T t = wrapper.readObject(null, typeInfo, factory);
            return t;
        }
    }

    private DsonObjectReader wrapReader(DsonReader reader) {
        if (this.options.randomRead) {
            return new BufferedDsonObjectReader((DsonConverter)this, this.toDsonCollectionReader(reader));
        }
        return new DefaultDsonObjectReader(this, reader);
    }

    private DsonCollectionReader toDsonCollectionReader(DsonReader dsonReader) {
        assert (!(dsonReader instanceof DsonCollectionReader));
        DsonValue dsonValue = Dsons.readTopDsonValue((DsonReader)dsonReader);
        return new DsonCollectionReader(this.options.binReaderSettings, new DsonArray().append(dsonValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public String writeAsDson(Object value, @Nonnull TypeInfo<?> typeInfo, ObjectStyle style) {
        StringBuilder stringBuilder = (StringBuilder)this.options.stringBuilderPool.acquire();
        try {
            this.writeAsDson(value, typeInfo, (Writer)new StringBuilderWriter(stringBuilder), style);
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            this.options.stringBuilderPool.release((Object)stringBuilder);
        }
    }

    @Override
    public <T> T readFromDson(CharSequence source, @Nonnull TypeInfo<T> typeInfo, Supplier<? extends T> factory) {
        try (DsonObjectReader wrapper = this.wrapReader((DsonReader)new DsonTextReader(this.options.textReaderSettings, source));){
            T t = wrapper.readObject(null, typeInfo, factory);
            return t;
        }
    }

    @Override
    public void writeAsDson(Object value, @Nonnull TypeInfo<?> typeInfo, Writer writer, ObjectStyle style) {
        Objects.requireNonNull(writer, "writer");
        try (DefaultDsonObjectWriter wrapper = new DefaultDsonObjectWriter(this, (DsonWriter)new DsonTextWriter(this.options.textWriterSettings, writer, false));){
            wrapper.writeObject(null, value, typeInfo, style);
            wrapper.flush();
        }
    }

    @Override
    public <T> T readFromDson(Reader source, @Nonnull TypeInfo<T> typeInfo, Supplier<? extends T> factory) {
        try (DsonObjectReader wrapper = this.wrapReader((DsonReader)new DsonTextReader(this.options.textReaderSettings, Dsons.newStreamScanner((Reader)source, (boolean)false)));){
            T t = wrapper.readObject(null, typeInfo, factory);
            return t;
        }
    }

    @Override
    public DsonValue writeAsDsonValue(Object value, TypeInfo<?> typeInfo) {
        Objects.requireNonNull(value);
        DsonArray outList = new DsonArray(1);
        try (DefaultDsonObjectWriter wrapper = new DefaultDsonObjectWriter(this, (DsonWriter)new DsonCollectionWriter(this.options.binWriterSettings, outList));){
            wrapper.writeObject(null, value, typeInfo, ObjectStyle.INDENT);
            DsonValue dsonValue = outList.get(0);
            if (dsonValue.getDsonType().isContainer()) {
                DsonValue dsonValue2 = dsonValue;
                return dsonValue2;
            }
            throw new IllegalArgumentException("value must be container");
        }
    }

    @Override
    public <T> T readFromDsonValue(DsonValue source, @Nonnull TypeInfo<T> typeInfo, Supplier<? extends T> factory) {
        if (!source.getDsonType().isContainer()) {
            throw new IllegalArgumentException("value must be container");
        }
        DsonArray dsonArray = new DsonArray().append(source);
        try (BufferedDsonObjectReader wrapper = new BufferedDsonObjectReader((DsonConverter)this, new DsonCollectionReader(this.options.binReaderSettings, dsonArray));){
            T t = wrapper.readObject(null, typeInfo, factory);
            return t;
        }
    }

    @Override
    public DsonValue readAsDsonValue(Reader source) {
        try (DsonTextReader textReader = new DsonTextReader(this.options.textReaderSettings, Dsons.newStreamScanner((Reader)source, (boolean)false));){
            DsonValue dsonValue = Dsons.readTopDsonValue((DsonReader)textReader);
            return dsonValue;
        }
    }

    @Override
    public DsonArray<String> readAsDsonCollection(Reader source) {
        try (DsonTextReader textReader = new DsonTextReader(this.options.textReaderSettings, Dsons.newStreamScanner((Reader)source, (boolean)false));){
            DsonArray dsonArray = Dsons.readCollection((DsonReader)textReader);
            return dsonArray;
        }
    }

    public static DefaultDsonConverter newInstance(TypeMetaRegistry typeMetaRegistry, List<? extends DsonCodec<?>> pojoCodecList, ConverterOptions options) {
        Objects.requireNonNull(options, "options");
        for (DsonCodec<?> rawCodec : pojoCodecList) {
            TypeMeta typeMeta = typeMetaRegistry.ofClass(rawCodec.getEncoderClass());
            if (typeMeta != null) continue;
            throw new IllegalArgumentException("the type meta of encoderClass: %s is absent".formatted(rawCodec.getEncoderClass()));
        }
        ArrayList allPojoCodecList = new ArrayList(pojoCodecList.size());
        for (DsonCodec<?> rawCodec : pojoCodecList) {
            allPojoCodecList.add(new DsonCodecImpl(rawCodec));
        }
        return new DefaultDsonConverter(TypeMetaRegistries.fromRegistries(typeMetaRegistry, DsonConverterUtils.getDefaultTypeMetaRegistry()), DsonCodecRegistries.fromRegistries(DsonCodecRegistries.fromCodecs(allPojoCodecList), DsonConverterUtils.getDefaultCodecRegistry()), options);
    }

    public static DefaultDsonConverter newInstance2(List<DsonCodecRegistry> registryList, TypeMetaRegistry typeMetaRegistry, ConverterOptions options) {
        Objects.requireNonNull(options, "options");
        if (!registryList.contains(DsonConverterUtils.getDefaultCodecRegistry())) {
            ArrayList<DsonCodecRegistry> copied = new ArrayList<DsonCodecRegistry>(registryList.size() + 1);
            copied.addAll(registryList);
            copied.add(DsonConverterUtils.getDefaultCodecRegistry());
            registryList = copied;
        }
        return new DefaultDsonConverter(TypeMetaRegistries.fromRegistries(typeMetaRegistry, DsonConverterUtils.getDefaultTypeMetaRegistry()), DsonCodecRegistries.fromRegistries(registryList), options);
    }
}

