/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.base.EnumLite;
import cn.wjybxx.dson.DsonType;
import cn.wjybxx.dson.DsonValue;
import cn.wjybxx.dson.DsonWriter;
import cn.wjybxx.dson.Dsons;
import cn.wjybxx.dson.WireType;
import cn.wjybxx.dson.io.DsonChunk;
import cn.wjybxx.dson.text.DsonTextWriter;
import cn.wjybxx.dson.text.INumberStyle;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dson.text.StringStyle;
import cn.wjybxx.dson.types.Binary;
import cn.wjybxx.dson.types.ExtDateTime;
import cn.wjybxx.dson.types.ObjectLitePtr;
import cn.wjybxx.dson.types.ObjectPtr;
import cn.wjybxx.dson.types.Timestamp;
import cn.wjybxx.dsoncodec.ConverterOptions;
import cn.wjybxx.dsoncodec.DsonCodecException;
import cn.wjybxx.dsoncodec.DsonCodecImpl;
import cn.wjybxx.dsoncodec.DsonCodecRegistry;
import cn.wjybxx.dsoncodec.DsonConverter;
import cn.wjybxx.dsoncodec.DsonConverterUtils;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.TypeMeta;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class DefaultDsonObjectWriter
implements DsonObjectWriter {
    private final DsonConverter converter;
    private final DsonWriter writer;

    public DefaultDsonObjectWriter(DsonConverter converter, DsonWriter writer) {
        this.converter = converter;
        this.writer = writer;
    }

    @Override
    public void writeInt(String name, int value, WireType wireType, INumberStyle style) {
        if (value != 0 || !this.writer.isAtName() || this.converter.options().appendDef) {
            this.writer.writeInt32(name, value, wireType, style);
        }
    }

    @Override
    public void writeLong(String name, long value, WireType wireType, INumberStyle style) {
        if (value != 0L || !this.writer.isAtName() || this.converter.options().appendDef) {
            this.writer.writeInt64(name, value, wireType, style);
        }
    }

    @Override
    public void writeFloat(String name, float value, INumberStyle style) {
        if (value != 0.0f || !this.writer.isAtName() || this.converter.options().appendDef) {
            this.writer.writeFloat(name, value, style);
        }
    }

    @Override
    public void writeDouble(String name, double value, INumberStyle style) {
        if (value != 0.0 || !this.writer.isAtName() || this.converter.options().appendDef) {
            this.writer.writeDouble(name, value, style);
        }
    }

    @Override
    public void writeBoolean(String name, boolean value) {
        if (value || !this.writer.isAtName() || this.converter.options().appendDef) {
            this.writer.writeBool(name, value);
        }
    }

    @Override
    public void writeString(String name, @Nullable String value, StringStyle style) {
        if (value == null) {
            this.writeNull(name);
        } else {
            this.writer.writeString(name, value, style);
        }
    }

    @Override
    public void writeNull(String name) {
        if (!this.writer.isAtName() || this.converter.options().appendNull) {
            this.writer.writeNull(name);
        }
    }

    @Override
    public void writeBytes(String name, byte[] value) {
        if (value == null) {
            this.writeNull(name);
        } else {
            this.writer.writeBinary(name, Binary.copyFrom((byte[])value));
        }
    }

    @Override
    public void writeBinary(String name, Binary binary) {
        if (binary == null) {
            this.writeNull(name);
        } else {
            this.writer.writeBinary(name, binary);
        }
    }

    @Override
    public void writeBinary(String name, @Nonnull DsonChunk chunk) {
        Objects.requireNonNull(chunk);
        this.writer.writeBinary(name, chunk);
    }

    @Override
    public void writePtr(String name, ObjectPtr objectPtr) {
        if (objectPtr == null) {
            this.writeNull(name);
        } else {
            this.writer.writePtr(name, objectPtr);
        }
    }

    @Override
    public void writeLitePtr(String name, ObjectLitePtr objectLitePtr) {
        if (objectLitePtr == null) {
            this.writeNull(name);
        } else {
            this.writer.writeLitePtr(name, objectLitePtr);
        }
    }

    @Override
    public void writeDateTime(String name, LocalDateTime dateTime) {
        if (dateTime == null) {
            this.writeNull(name);
        } else {
            this.writer.writeDateTime(name, ExtDateTime.ofDateTime((LocalDateTime)dateTime));
        }
    }

    @Override
    public void writeExtDateTime(String name, ExtDateTime dateTime) {
        if (dateTime == null) {
            this.writeNull(name);
        } else {
            this.writer.writeDateTime(name, dateTime);
        }
    }

    @Override
    public void writeTimestamp(String name, Timestamp timestamp) {
        if (timestamp == null) {
            this.writeNull(name);
        } else {
            this.writer.writeTimestamp(name, timestamp);
        }
    }

    @Override
    public <T> void writeObject(String name, T value, TypeInfo<?> typeInfo, ObjectStyle style) {
        Objects.requireNonNull(typeInfo, "typeInfo");
        if (value == null) {
            this.writeNull(name);
            return;
        }
        DsonCodecImpl<T> codec = this.findObjectEncoder(value);
        if (codec != null) {
            if (this.writer.isAtName()) {
                this.writer.writeName(name);
            }
            codec.writeObject(this, value, typeInfo, this.findObjectStyle(value, typeInfo, style));
            return;
        }
        Class<?> type = value.getClass();
        if (type == byte[].class) {
            this.writeBytes(name, (byte[])value);
            return;
        }
        if (type == Short.class) {
            this.writeShort(name, (Short)value);
            return;
        }
        if (type == Byte.class) {
            this.writeByte(name, (Byte)value);
            return;
        }
        if (type == Character.class) {
            this.writeChar(name, ((Character)value).charValue());
            return;
        }
        if (value instanceof DsonValue) {
            DsonValue dsonValue = (DsonValue)value;
            Dsons.writeDsonValue((DsonWriter)this.writer, (DsonValue)dsonValue, (String)name);
            return;
        }
        throw DsonCodecException.unsupportedType(type);
    }

    @Override
    public ConverterOptions options() {
        return this.converter.options();
    }

    @Override
    public String getCurrentName() {
        return this.writer.getCurrentName();
    }

    @Override
    public void writeName(String name) {
        this.writer.writeName(name);
    }

    @Override
    public void writeStartObject(@Nonnull Object value, TypeInfo<?> typeInfo, ObjectStyle style) {
        this.writer.writeStartObject(style);
        this.writeClsName(value, typeInfo);
    }

    @Override
    public void writeEndObject() {
        this.writer.writeEndObject();
    }

    @Override
    public void writeStartArray(@Nonnull Object value, TypeInfo<?> typeInfo, ObjectStyle style) {
        this.writer.writeStartArray(style);
        this.writeClsName(value, typeInfo);
    }

    @Override
    public void writeEndArray() {
        this.writer.writeEndArray();
    }

    @Override
    public void writeValueBytes(String name, DsonType dsonType, byte[] data) {
        Objects.requireNonNull(data);
        this.writer.writeValueBytes(name, dsonType, data);
    }

    @Override
    public String encodeKey(Object key) {
        Objects.requireNonNull(key);
        if (key instanceof String) {
            String str = (String)key;
            return str;
        }
        if (key instanceof Integer || key instanceof Long) {
            return key.toString();
        }
        if (!(key instanceof EnumLite)) {
            throw DsonCodecException.unsupportedType(key.getClass());
        }
        EnumLite enumLite = (EnumLite)key;
        if (this.converter.options().writeEnumAsString) {
            return key.toString();
        }
        return Integer.toString(enumLite.getNumber());
    }

    @Override
    public void println() {
        DsonWriter dsonWriter = this.writer;
        if (dsonWriter instanceof DsonTextWriter) {
            DsonTextWriter textWriter = (DsonTextWriter)dsonWriter;
            textWriter.println();
        }
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    public void close() {
        this.writer.close();
    }

    private void writeClsName(Object value, TypeInfo<?> typeInfo) {
        if (typeInfo == TypeInfo.NONE) {
            return;
        }
        Class<?> encodeClass = DsonConverterUtils.getEncodeClass(value);
        if (!this.converter.options().classIdPolicy.test(typeInfo.rawType, encodeClass)) {
            return;
        }
        TypeMeta typeMeta = this.getEncoderTypeMeta(typeInfo, encodeClass);
        if (typeMeta != null && !typeMeta.clsNames.isEmpty()) {
            this.writer.writeSimpleHeader(typeMeta.mainClsName());
        }
    }

    private ObjectStyle findObjectStyle(Object value, TypeInfo<?> typeInfo, @Nullable ObjectStyle style) {
        if (style != null) {
            return style;
        }
        Class<?> encodeClass = DsonConverterUtils.getEncodeClass(value);
        TypeMeta typeMeta = this.getEncoderTypeMeta(typeInfo, encodeClass);
        return typeMeta != null ? typeMeta.style : ObjectStyle.INDENT;
    }

    private TypeMeta getEncoderTypeMeta(TypeInfo<?> typeInfo, Class<?> encoderClass) {
        if (encoderClass == typeInfo.rawType) {
            return this.converter.typeMetaRegistry().ofType(typeInfo);
        }
        if (DsonConverterUtils.canInheritTypeArgs(encoderClass, typeInfo)) {
            return this.converter.typeMetaRegistry().ofType(TypeInfo.of(encoderClass, typeInfo.typeArgs));
        }
        return this.converter.typeMetaRegistry().ofClass(encoderClass);
    }

    private <T> DsonCodecImpl<? super T> findObjectEncoder(T value) {
        Class<?> encodeClass = DsonConverterUtils.getEncodeClass(value);
        DsonCodecRegistry rootRegistry = this.converter.codecRegistry();
        return rootRegistry.getEncoder(encodeClass, rootRegistry);
    }
}

