/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.dson.DsonReader;
import cn.wjybxx.dson.DsonType;
import cn.wjybxx.dson.types.Binary;
import cn.wjybxx.dson.types.ExtDateTime;
import cn.wjybxx.dson.types.ObjectLitePtr;
import cn.wjybxx.dson.types.ObjectPtr;
import cn.wjybxx.dson.types.Timestamp;
import cn.wjybxx.dsoncodec.DsonCodecException;

final class DsonCodecHelper {
    DsonCodecHelper() {
    }

    static DsonType readOrGetDsonType(DsonReader reader) {
        if (reader.isAtType()) {
            return reader.readDsonType();
        }
        return reader.getCurrentDsonType();
    }

    static int readInt(DsonReader reader, String name) {
        DsonType dsonType = DsonCodecHelper.readOrGetDsonType(reader);
        return switch (dsonType) {
            case DsonType.INT32 -> reader.readInt32(name);
            case DsonType.INT64 -> (int)reader.readInt64(name);
            case DsonType.FLOAT -> (int)reader.readFloat(name);
            case DsonType.DOUBLE -> (int)reader.readDouble(name);
            case DsonType.BOOL -> {
                if (reader.readBool(name)) {
                    yield 1;
                }
                yield 0;
            }
            case DsonType.NULL -> {
                reader.readNull(name);
                yield 0;
            }
            default -> throw DsonCodecException.incompatible(Integer.class, dsonType);
        };
    }

    static long readLong(DsonReader reader, String name) {
        DsonType dsonType = DsonCodecHelper.readOrGetDsonType(reader);
        return switch (dsonType) {
            case DsonType.INT32 -> reader.readInt32(name);
            case DsonType.INT64 -> reader.readInt64(name);
            case DsonType.FLOAT -> (long)reader.readFloat(name);
            case DsonType.DOUBLE -> (long)reader.readDouble(name);
            case DsonType.BOOL -> {
                if (reader.readBool(name)) {
                    yield 1L;
                }
                yield 0L;
            }
            case DsonType.NULL -> {
                reader.readNull(name);
                yield 0L;
            }
            default -> throw DsonCodecException.incompatible(Long.class, dsonType);
        };
    }

    static float readFloat(DsonReader reader, String name) {
        DsonType dsonType = DsonCodecHelper.readOrGetDsonType(reader);
        return switch (dsonType) {
            case DsonType.INT32 -> reader.readInt32(name);
            case DsonType.INT64 -> reader.readInt64(name);
            case DsonType.FLOAT -> reader.readFloat(name);
            case DsonType.DOUBLE -> (float)reader.readDouble(name);
            case DsonType.BOOL -> {
                if (reader.readBool(name)) {
                    yield 1.0f;
                }
                yield 0.0f;
            }
            case DsonType.NULL -> {
                reader.readNull(name);
                yield 0.0f;
            }
            default -> throw DsonCodecException.incompatible(Float.class, dsonType);
        };
    }

    static double readDouble(DsonReader reader, String name) {
        DsonType dsonType = DsonCodecHelper.readOrGetDsonType(reader);
        return switch (dsonType) {
            case DsonType.INT32 -> reader.readInt32(name);
            case DsonType.INT64 -> reader.readInt64(name);
            case DsonType.FLOAT -> reader.readFloat(name);
            case DsonType.DOUBLE -> reader.readDouble(name);
            case DsonType.BOOL -> {
                if (reader.readBool(name)) {
                    yield 1.0;
                }
                yield 0.0;
            }
            case DsonType.NULL -> {
                reader.readNull(name);
                yield 0.0;
            }
            default -> throw DsonCodecException.incompatible(Double.class, dsonType);
        };
    }

    static boolean readBool(DsonReader reader, String name) {
        DsonType dsonType = DsonCodecHelper.readOrGetDsonType(reader);
        return switch (dsonType) {
            case DsonType.INT32 -> {
                if (reader.readInt32(name) != 0) {
                    yield true;
                }
                yield false;
            }
            case DsonType.INT64 -> {
                if (reader.readInt64(name) != 0L) {
                    yield true;
                }
                yield false;
            }
            case DsonType.FLOAT -> {
                if (reader.readFloat(name) != 0.0f) {
                    yield true;
                }
                yield false;
            }
            case DsonType.DOUBLE -> {
                if (reader.readDouble(name) != 0.0) {
                    yield true;
                }
                yield false;
            }
            case DsonType.BOOL -> reader.readBool(name);
            case DsonType.NULL -> {
                reader.readNull(name);
                yield false;
            }
            default -> throw DsonCodecException.incompatible(Boolean.class, dsonType);
        };
    }

    static String readString(DsonReader reader, String name) {
        DsonType dsonType = DsonCodecHelper.readOrGetDsonType(reader);
        return switch (dsonType) {
            case DsonType.STRING -> reader.readString(name);
            case DsonType.NULL -> {
                reader.readNull(name);
                yield null;
            }
            default -> throw DsonCodecException.incompatible(String.class, dsonType);
        };
    }

    static void readNull(DsonReader reader, String name) {
        DsonType dsonType = DsonCodecHelper.readOrGetDsonType(reader);
        if (dsonType != DsonType.NULL) {
            throw DsonCodecException.incompatible(DsonType.NULL, dsonType);
        }
        reader.readNull(name);
    }

    static Binary readBinary(DsonReader reader, String name) {
        DsonType dsonType = DsonCodecHelper.readOrGetDsonType(reader);
        return switch (dsonType) {
            case DsonType.BINARY -> reader.readBinary(name);
            case DsonType.NULL -> {
                reader.readNull(name);
                yield null;
            }
            default -> throw DsonCodecException.incompatible(Binary.class, dsonType);
        };
    }

    static ObjectPtr readPtr(DsonReader reader, String name) {
        DsonType dsonType = DsonCodecHelper.readOrGetDsonType(reader);
        return switch (dsonType) {
            case DsonType.POINTER -> reader.readPtr(name);
            case DsonType.NULL -> {
                reader.readNull(name);
                yield null;
            }
            default -> throw DsonCodecException.incompatible(ObjectPtr.class, dsonType);
        };
    }

    static ObjectLitePtr readLitePtr(DsonReader reader, String name) {
        DsonType dsonType = DsonCodecHelper.readOrGetDsonType(reader);
        return switch (dsonType) {
            case DsonType.LITE_POINTER -> reader.readLitePtr(name);
            case DsonType.NULL -> {
                reader.readNull(name);
                yield null;
            }
            default -> throw DsonCodecException.incompatible(ObjectLitePtr.class, dsonType);
        };
    }

    static ExtDateTime readDateTime(DsonReader reader, String name) {
        DsonType dsonType = DsonCodecHelper.readOrGetDsonType(reader);
        return switch (dsonType) {
            case DsonType.DATETIME -> reader.readDateTime(name);
            case DsonType.NULL -> {
                reader.readNull(name);
                yield null;
            }
            default -> throw DsonCodecException.incompatible(ExtDateTime.class, dsonType);
        };
    }

    static Timestamp readTimestamp(DsonReader reader, String name) {
        DsonType dsonType = DsonCodecHelper.readOrGetDsonType(reader);
        return switch (dsonType) {
            case DsonType.TIMESTAMP -> reader.readTimestamp(name);
            case DsonType.NULL -> {
                reader.readNull(name);
                yield null;
            }
            default -> throw DsonCodecException.incompatible(Timestamp.class, dsonType);
        };
    }

    static Object readPrimitive(DsonReader reader, String name, Class<?> declared) {
        if (declared == Integer.TYPE) {
            return DsonCodecHelper.readInt(reader, name);
        }
        if (declared == Long.TYPE) {
            return DsonCodecHelper.readLong(reader, name);
        }
        if (declared == Float.TYPE) {
            return Float.valueOf(DsonCodecHelper.readFloat(reader, name));
        }
        if (declared == Double.TYPE) {
            return DsonCodecHelper.readDouble(reader, name);
        }
        if (declared == Boolean.TYPE) {
            return DsonCodecHelper.readBool(reader, name);
        }
        if (declared == Short.TYPE) {
            return (short)DsonCodecHelper.readInt(reader, name);
        }
        if (declared == Byte.TYPE) {
            return (byte)DsonCodecHelper.readInt(reader, name);
        }
        if (declared == Character.TYPE) {
            return Character.valueOf((char)DsonCodecHelper.readInt(reader, name));
        }
        throw DsonCodecException.unsupportedType(declared);
    }

    public static Object readDsonValue(DsonReader reader, DsonType dsonType, String name) {
        return switch (dsonType) {
            case DsonType.INT32 -> reader.readInt32(name);
            case DsonType.INT64 -> reader.readInt64(name);
            case DsonType.FLOAT -> Float.valueOf(reader.readFloat(name));
            case DsonType.DOUBLE -> reader.readDouble(name);
            case DsonType.BOOL -> reader.readBool(name);
            case DsonType.STRING -> reader.readString(name);
            case DsonType.BINARY -> reader.readBinary(name);
            case DsonType.POINTER -> reader.readPtr(name);
            case DsonType.LITE_POINTER -> reader.readLitePtr(name);
            case DsonType.DATETIME -> reader.readDateTime(name);
            case DsonType.TIMESTAMP -> reader.readTimestamp(name);
            case DsonType.NULL -> {
                reader.readNull(name);
                yield null;
            }
            default -> throw new AssertionError(dsonType);
        };
    }
}

