/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonCodecException;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.codecs.AbstractEnumCodec;
import cn.wjybxx.dsoncodec.codecs.EnumCodec;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class DsonCodecImpl<T> {
    private final DsonCodec<T> codec;
    private final boolean autoStart;
    private final boolean writeAsArray;
    private final AbstractEnumCodec<T> enumCodec;

    public DsonCodecImpl(DsonCodec<T> codec) {
        AbstractEnumCodec enumCodec;
        Objects.requireNonNull(codec.getEncoderClass());
        this.codec = codec;
        this.autoStart = codec.autoStartEnd();
        this.writeAsArray = codec.isWriteAsArray();
        this.enumCodec = codec instanceof AbstractEnumCodec ? (enumCodec = (AbstractEnumCodec)((Object)codec)) : null;
    }

    @Nonnull
    public Class<T> getEncoderClass() {
        return this.codec.getEncoderClass();
    }

    public boolean isWriteAsArray() {
        return this.writeAsArray;
    }

    public void writeObject(DsonObjectWriter writer, T instance, TypeInfo<?> typeInfo, ObjectStyle style) {
        if (this.autoStart) {
            if (this.writeAsArray) {
                writer.writeStartArray(instance, typeInfo, style);
                this.codec.writeObject(writer, instance, typeInfo, style);
                writer.writeEndArray();
            } else {
                writer.writeStartObject(instance, typeInfo, style);
                this.codec.writeObject(writer, instance, typeInfo, style);
                writer.writeEndObject();
            }
        } else {
            this.codec.writeObject(writer, instance, typeInfo, style);
        }
    }

    public T readObject(DsonObjectReader reader, TypeInfo<?> typeInfo, Supplier<? extends T> factory) {
        if (this.autoStart) {
            T result;
            if (this.writeAsArray) {
                reader.readStartArray();
                result = this.codec.readObject(reader, typeInfo, factory);
                reader.readEndArray();
            } else {
                reader.readStartObject();
                result = this.codec.readObject(reader, typeInfo, factory);
                reader.readEndObject();
            }
            return result;
        }
        return this.codec.readObject(reader, typeInfo, factory);
    }

    public boolean isEnumCodec() {
        return this.codec instanceof EnumCodec;
    }

    public T forNumber(int number) {
        if (this.enumCodec != null) {
            return this.enumCodec.forNumber(number);
        }
        throw new DsonCodecException("unexpected forNumber method call");
    }

    public T forName(String name) {
        if (this.enumCodec != null) {
            return this.enumCodec.forName(name);
        }
        throw new DsonCodecException("unexpected forName method call");
    }
}

