/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.dsoncodec.DsonCodecImpl;
import cn.wjybxx.dsoncodec.DsonCodecRegistry;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class DsonCodecRegistries {
    public static Map<Class<?>, DsonCodecImpl<?>> newCodecMap(List<? extends DsonCodecImpl<?>> pojoCodecs) {
        IdentityHashMap codecMap = new IdentityHashMap(pojoCodecs.size());
        for (DsonCodecImpl<?> codec : pojoCodecs) {
            if (codecMap.containsKey(codec.getEncoderClass())) {
                throw new IllegalArgumentException("the class has multiple codecs :" + codec.getEncoderClass().getName());
            }
            codecMap.put(codec.getEncoderClass(), codec);
        }
        return codecMap;
    }

    public static DsonCodecRegistry fromCodecs(DsonCodecImpl<?> ... pojoCodecs) {
        return DsonCodecRegistries.fromCodecs(List.of(pojoCodecs));
    }

    public static DsonCodecRegistry fromCodecs(List<? extends DsonCodecImpl<?>> pojoCodecs) {
        IdentityHashMap codecMap = new IdentityHashMap(pojoCodecs.size());
        for (DsonCodecImpl<?> codec : pojoCodecs) {
            if (codecMap.containsKey(codec.getEncoderClass())) {
                throw new IllegalArgumentException("the class has multiple codecs :" + codec.getEncoderClass().getName());
            }
            codecMap.put(codec.getEncoderClass(), codec);
        }
        return new DefaultCodecRegistry(codecMap);
    }

    public static DsonCodecRegistry fromRegistries(DsonCodecRegistry ... codecRegistry) {
        return new CompositeCodecRegistry(List.of(codecRegistry));
    }

    public static DsonCodecRegistry fromRegistries(List<DsonCodecRegistry> codecRegistry) {
        return new CompositeCodecRegistry(List.copyOf(codecRegistry));
    }

    private static class DefaultCodecRegistry
    implements DsonCodecRegistry {
        private final IdentityHashMap<Class<?>, DsonCodecImpl<?>> type2CodecMap;

        private DefaultCodecRegistry(IdentityHashMap<Class<?>, DsonCodecImpl<?>> type2CodecMap) {
            this.type2CodecMap = type2CodecMap;
        }

        @Override
        @Nullable
        public <T> DsonCodecImpl<? super T> getEncoder(Class<T> clazz, DsonCodecRegistry rootRegistry) {
            return this.type2CodecMap.get(clazz);
        }

        @Override
        public <T> DsonCodecImpl<T> getDecoder(Class<T> clazz, DsonCodecRegistry rootRegistry) {
            return this.type2CodecMap.get(clazz);
        }
    }

    private static class CompositeCodecRegistry
    implements DsonCodecRegistry {
        private final List<DsonCodecRegistry> registryList;

        private CompositeCodecRegistry(List<DsonCodecRegistry> registryList) {
            this.registryList = registryList;
        }

        @Override
        @Nullable
        public <T> DsonCodecImpl<? super T> getEncoder(Class<T> clazz, DsonCodecRegistry rootRegistry) {
            List<DsonCodecRegistry> registryList = this.registryList;
            for (int i = 0; i < registryList.size(); ++i) {
                DsonCodecRegistry registry = registryList.get(i);
                DsonCodecImpl<T> codec = registry.getEncoder(clazz, rootRegistry);
                if (codec == null) continue;
                return codec;
            }
            return null;
        }

        @Override
        @Nullable
        public <T> DsonCodecImpl<T> getDecoder(Class<T> clazz, DsonCodecRegistry rootRegistry) {
            List<DsonCodecRegistry> registryList = this.registryList;
            for (int i = 0; i < registryList.size(); ++i) {
                DsonCodecRegistry registry = registryList.get(i);
                DsonCodecImpl<T> codec = registry.getDecoder(clazz, rootRegistry);
                if (codec == null) continue;
                return codec;
            }
            return null;
        }
    }
}

