/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.base.reflect.TypeParameterFinder;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dson.types.Binary;
import cn.wjybxx.dson.types.ExtDateTime;
import cn.wjybxx.dson.types.ObjectLitePtr;
import cn.wjybxx.dson.types.ObjectPtr;
import cn.wjybxx.dson.types.Timestamp;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonCodecImpl;
import cn.wjybxx.dsoncodec.DsonCodecRegistries;
import cn.wjybxx.dsoncodec.DsonCodecRegistry;
import cn.wjybxx.dsoncodec.MapEncodeProxy;
import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.TypeMeta;
import cn.wjybxx.dsoncodec.TypeMetaRegistries;
import cn.wjybxx.dsoncodec.TypeMetaRegistry;
import cn.wjybxx.dsoncodec.codecs.BinaryCodec;
import cn.wjybxx.dsoncodec.codecs.BooleanCodec;
import cn.wjybxx.dsoncodec.codecs.CollectionCodec;
import cn.wjybxx.dsoncodec.codecs.DoubleCodec;
import cn.wjybxx.dsoncodec.codecs.DurationCodec;
import cn.wjybxx.dsoncodec.codecs.ExtDateTimeCodec;
import cn.wjybxx.dsoncodec.codecs.FloatCodec;
import cn.wjybxx.dsoncodec.codecs.InstantCodec;
import cn.wjybxx.dsoncodec.codecs.Int32Codec;
import cn.wjybxx.dsoncodec.codecs.Int64Codec;
import cn.wjybxx.dsoncodec.codecs.LocalDateCodec;
import cn.wjybxx.dsoncodec.codecs.LocalDateTimeCodec;
import cn.wjybxx.dsoncodec.codecs.LocalTimeCodec;
import cn.wjybxx.dsoncodec.codecs.MapCodec;
import cn.wjybxx.dsoncodec.codecs.MapEncodeProxyCodec;
import cn.wjybxx.dsoncodec.codecs.MoreArrayCodecs;
import cn.wjybxx.dsoncodec.codecs.ObjectLitePtrCodec;
import cn.wjybxx.dsoncodec.codecs.ObjectPtrCodec;
import cn.wjybxx.dsoncodec.codecs.StringCodec;
import cn.wjybxx.dsoncodec.codecs.TimestampCodec;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class DsonConverterUtils {
    private static final TypeMetaRegistry TYPE_META_REGISTRY;
    private static final DsonCodecRegistry CODEC_REGISTRY;
    private static final MethodType SUPPLIER_INVOKE_TYPE;
    private static final MethodType SUPPLIER_GET_METHOD_TYPE;
    private static final Map<Class<?>, Class<?>> wrapperToPrimitiveTypeMap;
    private static final Map<Class<?>, Class<?>> primitiveTypeToWrapperMap;
    private static final Map<Class<?>, Object> primitiveTypeDefaultValueMap;
    private static final String[] arrayRankSymbols;
    private static final ConcurrentHashMap<ClassPair, Boolean> inheritableResultCache;
    private static final TypeInfo<?> Nil;
    private static final ConcurrentHashMap<Class<?>, TypeInfo<?>> actualTypeArgCache;

    private static TypeMeta typeMetaOf(Class<?> clazz, String ... clsNames) {
        if (clsNames.length == 0) {
            clsNames = new String[]{clazz.getSimpleName()};
        }
        return TypeMeta.of(clazz, ObjectStyle.INDENT, List.of(clsNames));
    }

    private static List<TypeMeta> builtinTypeMetas() {
        return List.of(DsonConverterUtils.typeMetaOf(Integer.TYPE, "i", "int", "int32", "ui", "uint", "uint32"), DsonConverterUtils.typeMetaOf(Long.TYPE, "L", "long", "int64", "uL", "ulong", "uint64"), DsonConverterUtils.typeMetaOf(Float.TYPE, "f", "float"), DsonConverterUtils.typeMetaOf(Double.TYPE, "d", "double"), DsonConverterUtils.typeMetaOf(Boolean.TYPE, "b", "bool", "boolean"), DsonConverterUtils.typeMetaOf(String.class, "s", "string"), DsonConverterUtils.typeMetaOf(Binary.class, "bin"), DsonConverterUtils.typeMetaOf(ObjectPtr.class, "ptr"), DsonConverterUtils.typeMetaOf(ObjectLitePtr.class, "lptr"), DsonConverterUtils.typeMetaOf(ExtDateTime.class, "dt"), DsonConverterUtils.typeMetaOf(Timestamp.class, "ts"), DsonConverterUtils.typeMetaOf(MapEncodeProxy.class, "MapEncodeProxy", "DictionaryEncodeProxy"), DsonConverterUtils.typeMetaOf(int[].class, new String[0]), DsonConverterUtils.typeMetaOf(long[].class, new String[0]), DsonConverterUtils.typeMetaOf(float[].class, new String[0]), DsonConverterUtils.typeMetaOf(double[].class, new String[0]), DsonConverterUtils.typeMetaOf(boolean[].class, new String[0]), DsonConverterUtils.typeMetaOf(String[].class, new String[0]), DsonConverterUtils.typeMetaOf(short[].class, new String[0]), DsonConverterUtils.typeMetaOf(char[].class, new String[0]), DsonConverterUtils.typeMetaOf(Object[].class, new String[0]), DsonConverterUtils.typeMetaOf(Collection.class, new String[0]), DsonConverterUtils.typeMetaOf(Map.class, new String[0]), DsonConverterUtils.typeMetaOf(LinkedList.class, new String[0]), DsonConverterUtils.typeMetaOf(ArrayDeque.class, new String[0]), DsonConverterUtils.typeMetaOf(IdentityHashMap.class, new String[0]), DsonConverterUtils.typeMetaOf(ConcurrentHashMap.class, new String[0]), DsonConverterUtils.typeMetaOf(LocalDateTime.class, new String[0]), DsonConverterUtils.typeMetaOf(LocalDate.class, new String[0]), DsonConverterUtils.typeMetaOf(LocalTime.class, new String[0]), DsonConverterUtils.typeMetaOf(Instant.class, new String[0]), DsonConverterUtils.typeMetaOf(DurationCodec.class, new String[0]));
    }

    private static List<DsonCodec<?>> builtinCodecs() {
        return List.of(new Int32Codec(), new Int64Codec(), new FloatCodec(), new DoubleCodec(), new BooleanCodec(), new StringCodec(), new BinaryCodec(), new ObjectPtrCodec(), new ObjectLitePtrCodec(), new ExtDateTimeCodec(), new TimestampCodec(), new MapEncodeProxyCodec(), new MoreArrayCodecs.IntArrayCodec(), new MoreArrayCodecs.LongArrayCodec(), new MoreArrayCodecs.FloatArrayCodec(), new MoreArrayCodecs.DoubleArrayCodec(), new MoreArrayCodecs.BooleanArrayCodec(), new MoreArrayCodecs.StringArrayCodec(), new MoreArrayCodecs.ShortArrayCodec(), new MoreArrayCodecs.CharArrayCodec(), new MoreArrayCodecs.ObjectArrayCodec(), new CollectionCodec<Collection>(Collection.class, null), new MapCodec<Map>(Map.class, null), new CollectionCodec<LinkedList>(LinkedList.class, LinkedList::new), new CollectionCodec<ArrayDeque>(ArrayDeque.class, ArrayDeque::new), new MapCodec<IdentityHashMap>(IdentityHashMap.class, IdentityHashMap::new), new MapCodec<ConcurrentHashMap>(ConcurrentHashMap.class, ConcurrentHashMap::new), new LocalDateTimeCodec(), new LocalDateCodec(), new LocalTimeCodec(), new InstantCodec(), new DurationCodec());
    }

    public static String arrayRankSymbol(int rank) {
        if (rank < 1 || rank > 9) {
            throw new IllegalArgumentException("rank: " + rank);
        }
        return arrayRankSymbols[rank - 1];
    }

    public static Class<?> getRootComponentType(Class<?> clz) {
        while (clz.isArray()) {
            clz = clz.getComponentType();
        }
        return clz;
    }

    public static int getArrayRank(Class<?> clz) {
        int r = 0;
        while (clz.isArray()) {
            ++r;
            clz = clz.getComponentType();
        }
        return r;
    }

    public static <T> boolean canInheritTypeArgs(Class<T> encoderClass, TypeInfo<?> typeInfo) {
        return typeInfo.typeArgs.size() > 0 && DsonConverterUtils.canInheritTypeArgs(encoderClass, typeInfo.rawType);
    }

    public static <T> boolean canInheritTypeArgs(Class<T> thisClass, Class<?> targetClass) {
        if (thisClass == targetClass) {
            return true;
        }
        if (!targetClass.isAssignableFrom(thisClass)) {
            return false;
        }
        ClassPair classPair = new ClassPair(thisClass, targetClass);
        Boolean r = inheritableResultCache.get(classPair);
        if (r != null) {
            return r;
        }
        if (thisClass.isArray()) {
            Class<?> thisElementType = DsonConverterUtils.getRootComponentType(thisClass);
            Class<?> targetElementType = DsonConverterUtils.getRootComponentType(targetClass);
            r = DsonConverterUtils.canInheritTypeArgs(thisElementType, targetElementType);
        } else {
            Class<T> superClassOrInterface;
            Type genericSuperType;
            Object[] thisTypeParameters = thisClass.getTypeParameters();
            if (thisTypeParameters.length > 0 && (genericSuperType = TypeParameterFinder.getGenericSuperType(thisClass, superClassOrInterface = targetClass)) instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericSuperType;
                Object[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                r = Arrays.equals(thisTypeParameters, actualTypeArguments);
            }
        }
        if (r == null) {
            r = false;
        }
        inheritableResultCache.put(classPair, r);
        return r;
    }

    public static <T> TypeInfo<?> getElementActualTypeInfo(Class<T> rawType) {
        if (!Collection.class.isAssignableFrom(rawType)) {
            return null;
        }
        return DsonConverterUtils.findActualTypeImpl(rawType, Collection.class, "E");
    }

    public static <T> TypeInfo<?> getKeyActualTypeInfo(Class<T> rawType) {
        if (!Map.class.isAssignableFrom(rawType)) {
            return null;
        }
        return DsonConverterUtils.findActualTypeImpl(rawType, Map.class, "K");
    }

    private static <T> TypeInfo<?> findActualTypeImpl(Class<T> rawType, Class<? super T> targetType, String typeVarName) {
        if (rawType == targetType) {
            return null;
        }
        TypeInfo<Object> typeInfo = actualTypeArgCache.get(rawType);
        if (typeInfo == null) {
            try {
                Class actualType = TypeParameterFinder.findTypeParameterUnsafe(rawType, targetType, (String)typeVarName);
                if (actualType != null) {
                    typeInfo = TypeInfo.of(actualType);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (typeInfo == null) {
                typeInfo = Nil;
            }
            actualTypeArgCache.put(rawType, typeInfo);
        }
        return typeInfo == Nil ? null : typeInfo;
    }

    public static DsonCodecRegistry getDefaultCodecRegistry() {
        return CODEC_REGISTRY;
    }

    public static TypeMetaRegistry getDefaultTypeMetaRegistry() {
        return TYPE_META_REGISTRY;
    }

    public static Object getDefaultValue(Class<?> type) {
        return type.isPrimitive() ? primitiveTypeDefaultValueMap.get(type) : null;
    }

    public static Class<?> boxIfPrimitiveType(Class<?> type) {
        return type.isPrimitive() ? primitiveTypeToWrapperMap.get(type) : type;
    }

    public static Class<?> unboxIfWrapperType(Class<?> type) {
        Class<?> result = wrapperToPrimitiveTypeMap.get(type);
        return result == null ? type : result;
    }

    public static boolean isBoxType(Class<?> type) {
        return wrapperToPrimitiveTypeMap.containsKey(type);
    }

    public static boolean isPrimitiveType(Class<?> type) {
        return type.isPrimitive();
    }

    public static boolean isAssignable(Class<?> lhsType, Class<?> rhsType) {
        Objects.requireNonNull(lhsType, "Left-hand side type must not be null");
        Objects.requireNonNull(rhsType, "Right-hand side type must not be null");
        if (lhsType.isAssignableFrom(rhsType)) {
            return true;
        }
        if (lhsType.isPrimitive()) {
            Class<?> resolvedPrimitive = wrapperToPrimitiveTypeMap.get(rhsType);
            return lhsType == resolvedPrimitive;
        }
        Class<?> resolvedWrapper = primitiveTypeToWrapperMap.get(rhsType);
        return resolvedWrapper != null && lhsType.isAssignableFrom(resolvedWrapper);
    }

    public static boolean isAssignableValue(Class<?> type, @Nullable Object value) {
        Objects.requireNonNull(type, "Type must not be null");
        return value != null ? DsonConverterUtils.isAssignable(type, value.getClass()) : !type.isPrimitive();
    }

    public static <T> T castValue(Class<T> type, Object value) {
        if (type.isPrimitive()) {
            Class<?> boxedType = primitiveTypeToWrapperMap.get(type);
            return (T)boxedType.cast(value);
        }
        return type.cast(value);
    }

    public static Class<?> getEncodeClass(Object value) {
        if (value instanceof Enum) {
            Enum e = (Enum)value;
            return e.getDeclaringClass();
        }
        return value.getClass();
    }

    public static <T> boolean isEncodeAsArray(Class<T> encoderClass) {
        return encoderClass.isArray() || Collection.class.isAssignableFrom(encoderClass) || Map.class.isAssignableFrom(encoderClass);
    }

    public static <T, E> T convertList2Array(List<? extends E> list, Class<T> arrayType) {
        Class<?> componentType = arrayType.getComponentType();
        int length = list.size();
        if (list.getClass() == ArrayList.class && !componentType.isPrimitive()) {
            Object[] tempArray = (Object[])Array.newInstance(componentType, length);
            return (T)list.toArray(tempArray);
        }
        Object tempArray = Array.newInstance(componentType, length);
        for (int index = 0; index < length; ++index) {
            E element = list.get(index);
            Array.set(tempArray, index, element);
        }
        return (T)tempArray;
    }

    public static <T> Supplier<T> noArgConstructorToSupplier(MethodHandles.Lookup lookup, Constructor<T> constructor) throws Throwable {
        Class<T> returnType = constructor.getDeclaringClass();
        CallSite callSite = LambdaMetafactory.metafactory(lookup, "get", SUPPLIER_INVOKE_TYPE, SUPPLIER_GET_METHOD_TYPE, lookup.unreflectConstructor(constructor), MethodType.methodType(returnType));
        Supplier supplier = callSite.getTarget().invoke();
        return supplier;
    }

    public static <T extends Collection<?>> CollectionCodec<T> createCollectionCodec(MethodHandles.Lookup lookup, Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            Supplier<T> factory = DsonConverterUtils.noArgConstructorToSupplier(lookup, constructor);
            return new CollectionCodec<T>(clazz, factory);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Map<?, ?>> MapCodec<T> createMapCodec(MethodHandles.Lookup lookup, Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            Supplier<T> factory = DsonConverterUtils.noArgConstructorToSupplier(lookup, constructor);
            return new MapCodec<T>(clazz, factory);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static {
        SUPPLIER_INVOKE_TYPE = MethodType.methodType(Supplier.class);
        SUPPLIER_GET_METHOD_TYPE = MethodType.methodType(Object.class);
        wrapperToPrimitiveTypeMap = new IdentityHashMap(9);
        primitiveTypeToWrapperMap = new IdentityHashMap(9);
        primitiveTypeDefaultValueMap = new IdentityHashMap(9);
        wrapperToPrimitiveTypeMap.put(Boolean.class, Boolean.TYPE);
        wrapperToPrimitiveTypeMap.put(Byte.class, Byte.TYPE);
        wrapperToPrimitiveTypeMap.put(Character.class, Character.TYPE);
        wrapperToPrimitiveTypeMap.put(Double.class, Double.TYPE);
        wrapperToPrimitiveTypeMap.put(Float.class, Float.TYPE);
        wrapperToPrimitiveTypeMap.put(Integer.class, Integer.TYPE);
        wrapperToPrimitiveTypeMap.put(Long.class, Long.TYPE);
        wrapperToPrimitiveTypeMap.put(Short.class, Short.TYPE);
        wrapperToPrimitiveTypeMap.put(Void.class, Void.TYPE);
        for (Map.Entry<Class<?>, Class<?>> entry : wrapperToPrimitiveTypeMap.entrySet()) {
            primitiveTypeToWrapperMap.put(entry.getValue(), entry.getKey());
        }
        primitiveTypeDefaultValueMap.put(Boolean.class, Boolean.FALSE);
        primitiveTypeDefaultValueMap.put(Byte.class, (byte)0);
        primitiveTypeDefaultValueMap.put(Character.class, Character.valueOf('\u0000'));
        primitiveTypeDefaultValueMap.put(Double.class, 0.0);
        primitiveTypeDefaultValueMap.put(Float.class, Float.valueOf(0.0f));
        primitiveTypeDefaultValueMap.put(Integer.class, 0);
        primitiveTypeDefaultValueMap.put(Long.class, 0L);
        primitiveTypeDefaultValueMap.put(Short.class, (short)0);
        primitiveTypeDefaultValueMap.put(Void.class, null);
        TYPE_META_REGISTRY = TypeMetaRegistries.fromMetas(DsonConverterUtils.builtinTypeMetas());
        CODEC_REGISTRY = new DefaultCodecRegistry(DsonCodecRegistries.newCodecMap(DsonConverterUtils.builtinCodecs().stream().map(DsonCodecImpl::new).toList()));
        arrayRankSymbols = new String[]{"[]", "[][]", "[][][]", "[][][][]", "[][][][][]", "[][][][][][]", "[][][][][][][]", "[][][][][][][][]", "[][][][][][][][][]"};
        inheritableResultCache = new ConcurrentHashMap();
        Nil = TypeInfo.of(Void.TYPE);
        actualTypeArgCache = new ConcurrentHashMap();
    }

    private static class ClassPair {
        final Class<?> first;
        final Class<?> second;

        public ClassPair(Class<?> first, Class<?> second) {
            this.first = first;
            this.second = second;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassPair classPair = (ClassPair)o;
            if (!this.first.equals(classPair.first)) {
                return false;
            }
            return this.second.equals(classPair.second);
        }

        public int hashCode() {
            int result = this.first.hashCode();
            result = 31 * result + this.second.hashCode();
            return result;
        }
    }

    private static class DefaultCodecRegistry
    implements DsonCodecRegistry {
        final Map<Class<?>, DsonCodecImpl<?>> codecMap;
        final DsonCodecImpl<Object[]> objectArrayCodec;
        final DsonCodecImpl<Collection> collectionCodec;
        final DsonCodecImpl<Map> mapCodec;

        private DefaultCodecRegistry(Map<Class<?>, DsonCodecImpl<?>> codecMap) {
            this.codecMap = codecMap;
            this.objectArrayCodec = DefaultCodecRegistry.getCodec(codecMap, Object[].class);
            this.collectionCodec = DefaultCodecRegistry.getCodec(codecMap, Collection.class);
            this.mapCodec = DefaultCodecRegistry.getCodec(codecMap, Map.class);
        }

        private static <T> DsonCodecImpl<T> getCodec(Map<Class<?>, DsonCodecImpl<?>> codecMap, Class<T> clazz) {
            DsonCodecImpl<?> codec = codecMap.get(clazz);
            if (codec == null) {
                throw new IllegalArgumentException(clazz.getName());
            }
            return codec;
        }

        @Override
        @Nullable
        public <T> DsonCodecImpl<? super T> getEncoder(Class<T> clazz, DsonCodecRegistry rootRegistry) {
            DsonCodecImpl<?> codec = this.codecMap.get(clazz);
            if (codec != null) {
                return codec;
            }
            if (clazz.isArray()) {
                return this.objectArrayCodec;
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return this.collectionCodec;
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return this.mapCodec;
            }
            return null;
        }

        @Override
        @Nullable
        public <T> DsonCodecImpl<T> getDecoder(Class<T> clazz, DsonCodecRegistry rootRegistry) {
            DsonCodecImpl<?> codec = this.codecMap.get(clazz);
            if (codec != null) {
                return codec;
            }
            if (clazz.isAssignableFrom(LinkedHashMap.class)) {
                return this.mapCodec;
            }
            if (clazz.isAssignableFrom(ArrayList.class)) {
                return this.collectionCodec;
            }
            return null;
        }
    }
}

