/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.base.CollectionUtils;
import cn.wjybxx.dson.DsonContextType;
import cn.wjybxx.dson.DsonType;
import cn.wjybxx.dson.types.Binary;
import cn.wjybxx.dson.types.ExtDateTime;
import cn.wjybxx.dson.types.ObjectLitePtr;
import cn.wjybxx.dson.types.ObjectPtr;
import cn.wjybxx.dson.types.Timestamp;
import cn.wjybxx.dsoncodec.ConverterOptions;
import cn.wjybxx.dsoncodec.TypeInfo;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface DsonObjectReader
extends AutoCloseable {
    public int readInt(String var1);

    public long readLong(String var1);

    public float readFloat(String var1);

    public double readDouble(String var1);

    public boolean readBoolean(String var1);

    public String readString(String var1);

    public void readNull(String var1);

    default public byte[] readBytes(String name) {
        Binary binary = this.readBinary(name);
        return binary == null ? null : binary.unsafeBuffer();
    }

    public Binary readBinary(String var1);

    public ObjectPtr readPtr(String var1);

    public ObjectLitePtr readLitePtr(String var1);

    public LocalDateTime readDateTime(String var1);

    public ExtDateTime readExtDateTime(String var1);

    public Timestamp readTimestamp(String var1);

    @Nullable
    public <T> T readObject(String var1, TypeInfo<T> var2, Supplier<? extends T> var3);

    default public <T> T readObject(String name, TypeInfo<T> typeInfo) {
        return this.readObject(name, typeInfo, null);
    }

    public ConverterOptions options();

    public DsonContextType getContextType();

    public DsonType readDsonType();

    public String readName();

    public boolean readName(String var1);

    public DsonType getCurrentDsonType();

    public String getCurrentName();

    public void readStartObject();

    public void readEndObject();

    public void readStartArray();

    public void readEndArray();

    public void skipName();

    public void skipValue();

    public void skipToEndOfObject();

    public byte[] readValueAsBytes(String var1);

    public <T> T decodeKey(String var1, Class<T> var2);

    public void setComponentType(DsonType var1);

    @Override
    public void close();

    default public boolean readStartObject(String name) {
        if (this.readName(name)) {
            this.readStartObject();
            return true;
        }
        return false;
    }

    default public boolean readStartArray(String name) {
        if (this.readName(name)) {
            this.readStartArray();
            return true;
        }
        return false;
    }

    default public short readShort(String name) {
        return (short)this.readInt(name);
    }

    default public byte readByte(String name) {
        return (byte)this.readInt(name);
    }

    default public char readChar(String name) {
        return (char)this.readInt(name);
    }

    @Nonnull
    default public <E> List<E> readImmutableList(String name, Class<E> elementType) {
        Collection result = this.readObject(name, TypeInfo.of(Collection.class, elementType));
        return CollectionUtils.toImmutableList((Collection)result);
    }

    @Nonnull
    default public <E> Set<E> readImmutableSet(String name, Class<E> elementType) {
        Set result = this.readObject(name, TypeInfo.of(Set.class, elementType), LinkedHashSet::new);
        if (result == null) {
            return Set.of();
        }
        return Collections.unmodifiableSet(result);
    }

    @Nonnull
    default public <K, V> Map<K, V> readImmutableMap(String name, Class<K> keyType, Class<V> valueType) {
        Map result = this.readObject(name, TypeInfo.of(Map.class, keyType, valueType), LinkedHashMap::new);
        if (result == null) {
            return Map.of();
        }
        return Collections.unmodifiableMap(result);
    }
}

