/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.dson.DsonType;
import cn.wjybxx.dson.WireType;
import cn.wjybxx.dson.io.DsonChunk;
import cn.wjybxx.dson.text.INumberStyle;
import cn.wjybxx.dson.text.NumberStyle;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dson.text.StringStyle;
import cn.wjybxx.dson.types.Binary;
import cn.wjybxx.dson.types.ExtDateTime;
import cn.wjybxx.dson.types.ObjectLitePtr;
import cn.wjybxx.dson.types.ObjectPtr;
import cn.wjybxx.dson.types.Timestamp;
import cn.wjybxx.dsoncodec.ConverterOptions;
import cn.wjybxx.dsoncodec.TypeInfo;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface DsonObjectWriter
extends AutoCloseable {
    public void writeInt(String var1, int var2, WireType var3, INumberStyle var4);

    public void writeLong(String var1, long var2, WireType var4, INumberStyle var5);

    public void writeFloat(String var1, float var2, INumberStyle var3);

    public void writeDouble(String var1, double var2, INumberStyle var4);

    public void writeBoolean(String var1, boolean var2);

    public void writeString(String var1, String var2, StringStyle var3);

    public void writeNull(String var1);

    public void writeBytes(String var1, byte[] var2);

    public void writeBinary(String var1, Binary var2);

    public void writeBinary(String var1, @Nonnull DsonChunk var2);

    public void writePtr(String var1, ObjectPtr var2);

    public void writeLitePtr(String var1, ObjectLitePtr var2);

    public void writeDateTime(String var1, LocalDateTime var2);

    public void writeExtDateTime(String var1, ExtDateTime var2);

    public void writeTimestamp(String var1, Timestamp var2);

    public <T> void writeObject(String var1, T var2, TypeInfo<?> var3, @Nullable ObjectStyle var4);

    default public <T> void writeObject(String name, T value) {
        this.writeObject(name, value, TypeInfo.OBJECT, null);
    }

    default public <T> void writeObject(String name, T value, TypeInfo<?> typeInfo) {
        this.writeObject(name, value, typeInfo, null);
    }

    public ConverterOptions options();

    public String getCurrentName();

    public void writeName(String var1);

    public void writeStartObject(@Nonnull Object var1, TypeInfo<?> var2, ObjectStyle var3);

    public void writeEndObject();

    public void writeStartArray(@Nonnull Object var1, TypeInfo<?> var2, ObjectStyle var3);

    public void writeEndArray();

    public void writeValueBytes(String var1, DsonType var2, byte[] var3);

    public String encodeKey(Object var1);

    public void println();

    public void flush();

    @Override
    public void close();

    default public void writeStartObject(Object value, TypeInfo<?> typeInfo) {
        this.writeStartObject(value, typeInfo, ObjectStyle.INDENT);
    }

    default public void writeStartObject(String name, Object value, TypeInfo<?> typeInfo) {
        this.writeName(name);
        this.writeStartObject(value, typeInfo, ObjectStyle.INDENT);
    }

    default public void writeStartObject(String name, Object value, TypeInfo<?> typeInfo, ObjectStyle style) {
        this.writeName(name);
        this.writeStartObject(value, typeInfo, style);
    }

    default public void writeStartArray(Object value, TypeInfo<?> typeInfo) {
        this.writeStartArray(value, typeInfo, ObjectStyle.INDENT);
    }

    default public void writeStartArray(String name, Object value, TypeInfo<?> typeInfo) {
        this.writeName(name);
        this.writeStartArray(value, typeInfo, ObjectStyle.INDENT);
    }

    default public void writeStartArray(String name, Object value, TypeInfo<?> typeInfo, ObjectStyle style) {
        this.writeName(name);
        this.writeStartArray(value, typeInfo, style);
    }

    default public void writeInt(String name, int value) {
        this.writeInt(name, value, WireType.VARINT, (INumberStyle)NumberStyle.SIMPLE);
    }

    default public void writeInt(String name, int value, WireType wireType) {
        this.writeInt(name, value, wireType, (INumberStyle)NumberStyle.SIMPLE);
    }

    default public void writeLong(String name, long value) {
        this.writeLong(name, value, WireType.VARINT, (INumberStyle)NumberStyle.SIMPLE);
    }

    default public void writeLong(String name, long value, WireType wireType) {
        this.writeLong(name, value, wireType, (INumberStyle)NumberStyle.SIMPLE);
    }

    default public void writeFloat(String name, float value) {
        this.writeFloat(name, value, (INumberStyle)NumberStyle.SIMPLE);
    }

    default public void writeDouble(String name, double value) {
        this.writeDouble(name, value, (INumberStyle)NumberStyle.SIMPLE);
    }

    default public void writeString(String name, String value) {
        this.writeString(name, value, StringStyle.AUTO);
    }

    default public void writeShort(String name, short value) {
        this.writeInt(name, value, WireType.VARINT, (INumberStyle)NumberStyle.SIMPLE);
    }

    default public void writeShort(String name, short value, WireType wireType, INumberStyle style) {
        this.writeInt(name, value, wireType, style);
    }

    default public void writeByte(String name, byte value) {
        this.writeInt(name, value, WireType.VARINT, (INumberStyle)NumberStyle.SIMPLE);
    }

    default public void writeByte(String name, byte value, WireType wireType, INumberStyle style) {
        this.writeInt(name, value, WireType.VARINT, style);
    }

    default public void writeChar(String name, char value) {
        this.writeInt(name, value, WireType.UINT, (INumberStyle)NumberStyle.SIMPLE);
    }

    default public void writeChar(String name, char value, WireType ignore, INumberStyle style) {
        this.writeInt(name, value, WireType.UINT, style);
    }
}

