/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.base.ObjectUtils;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.ClassName;
import cn.wjybxx.dsoncodec.ClassNamePool;
import cn.wjybxx.dsoncodec.DsonCodecException;
import cn.wjybxx.dsoncodec.DsonConverterUtils;
import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.TypeMeta;
import cn.wjybxx.dsoncodec.TypeMetaRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class DynamicTypeMetaRegistry
implements TypeMetaRegistry {
    private final TypeMetaRegistry basicRegistry;
    private final ClassNamePool classNamePool = new ClassNamePool();
    private final ConcurrentHashMap<TypeInfo<?>, TypeMeta> type2MetaDic = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, TypeMeta> name2MetaDic = new ConcurrentHashMap();

    public DynamicTypeMetaRegistry(TypeMetaRegistry basicRegistry) {
        this.basicRegistry = Objects.requireNonNull(basicRegistry);
    }

    @Override
    @Nullable
    public TypeMeta ofClass(Class<?> clazz) {
        TypeMeta typeMeta = this.basicRegistry.ofClass(clazz);
        if (typeMeta != null) {
            return typeMeta;
        }
        if (clazz.isArray()) {
            return this.ofType(TypeInfo.of(clazz));
        }
        return null;
    }

    @Override
    @Nullable
    public TypeMeta ofType(TypeInfo<?> type) {
        return this.ofType(type, false);
    }

    private TypeMeta ofType(TypeInfo<?> type, boolean basicType) {
        ObjectStyle style;
        TypeMeta typeMeta = this.basicRegistry.ofType(type);
        if (typeMeta != null || basicType) {
            return typeMeta;
        }
        typeMeta = this.type2MetaDic.get(type);
        if (typeMeta != null) {
            return typeMeta;
        }
        if (!type.isGenericType() && !type.isArray()) {
            return null;
        }
        if (type.isArray()) {
            style = ObjectStyle.INDENT;
        } else {
            TypeMeta rawTypeMeta = this.ofType(type);
            if (rawTypeMeta == null) {
                throw new AssertionError((Object)("type: " + String.valueOf(type)));
            }
            style = rawTypeMeta.style;
        }
        ClassName className = this.classNameOfType(type);
        String mainClsName = className.toString();
        typeMeta = TypeMeta.of(type, style, mainClsName);
        this.type2MetaDic.put(type, typeMeta);
        this.name2MetaDic.put(mainClsName, typeMeta);
        return typeMeta;
    }

    @Override
    public TypeMeta ofName(String clsName) {
        return this.ofName(clsName, false);
    }

    private TypeMeta ofName(String clsName, boolean basicType) {
        TypeMeta typeMeta = this.basicRegistry.ofName(clsName);
        if (typeMeta != null || basicType) {
            return typeMeta;
        }
        typeMeta = this.name2MetaDic.get(clsName);
        if (typeMeta != null) {
            return typeMeta;
        }
        ClassName className = this.classNamePool.parse(clsName);
        TypeInfo<?> type = this.typeOfClassName(className);
        typeMeta = this.ofType(type);
        if (typeMeta == null) {
            throw new AssertionError((Object)type.toString());
        }
        if (typeMeta.clsNames.contains(clsName) || ObjectUtils.containsWhitespace((CharSequence)clsName)) {
            return typeMeta;
        }
        ArrayList<String> clsNames = new ArrayList<String>(typeMeta.clsNames.size() + 1);
        clsNames.addAll(typeMeta.clsNames);
        clsNames.add(clsName);
        typeMeta = TypeMeta.of(type, typeMeta.style, clsNames);
        this.type2MetaDic.put(type, typeMeta);
        for (String name : clsNames) {
            this.name2MetaDic.put(name, typeMeta);
        }
        return typeMeta;
    }

    private ClassName classNameOfType(TypeInfo<?> type) {
        if (type.isArray()) {
            TypeInfo<?> rootElementType = TypeInfo.of(DsonConverterUtils.getRootComponentType(type.rawType), type.typeArgs);
            int arrayRank = DsonConverterUtils.getArrayRank(type.rawType);
            String clsName = String.valueOf(this.classNameOfType(rootElementType)) + DsonConverterUtils.arrayRankSymbol(arrayRank);
            return new ClassName(clsName);
        }
        if (type.isGenericType()) {
            TypeInfo<?> genericTypeDefinition = type.getGenericTypeDefinition();
            TypeMeta typeMeta = this.ofType(genericTypeDefinition, true);
            if (typeMeta == null) {
                throw new DsonCodecException("typeMeta absent, type: " + String.valueOf(type));
            }
            List<Class<?>> genericArguments = type.typeArgs;
            ArrayList<ClassName> typeArgClassNames = new ArrayList<ClassName>(genericArguments.size());
            for (Class<?> genericArgument : genericArguments) {
                TypeInfo<?> genericArgType = TypeInfo.of(genericArgument);
                typeArgClassNames.add(this.classNameOfType(genericArgType));
            }
            return new ClassName(typeMeta.mainClsName(), typeArgClassNames);
        }
        TypeMeta typeMeta = this.ofType(type, true);
        if (typeMeta == null) {
            throw new DsonCodecException("typeMeta absent, type: " + String.valueOf(type));
        }
        return new ClassName(typeMeta.mainClsName());
    }

    private TypeInfo<?> typeOfClassName(ClassName className) {
        TypeInfo<Object> elementType;
        int arrayRank = className.getArrayRank();
        if (arrayRank > 0) {
            elementType = this.typeOfClassName(new ClassName(className.getRootElement(), className.typeArgs));
        } else {
            TypeMeta typeMeta = this.ofName(className.clsName, true);
            if (typeMeta == null) {
                throw new DsonCodecException("typeMeta absent, className: " + String.valueOf(className));
            }
            elementType = typeMeta.typeInfo;
            int typeArgsCount = className.typeArgs.size();
            if (typeArgsCount > 0) {
                Class[] typeParameters = new Class[typeArgsCount];
                for (int index = 0; index < typeArgsCount; ++index) {
                    ClassName genericArgClassName = className.typeArgs.get(index);
                    typeParameters[index] = this.typeOfClassName((ClassName)genericArgClassName).rawType;
                }
                elementType = TypeInfo.of(elementType.rawType, typeParameters);
            }
        }
        while (arrayRank-- > 0) {
            elementType = elementType.makeArrayType();
        }
        return elementType;
    }

    @Override
    public List<TypeMeta> export() {
        ArrayList<TypeMeta> result = new ArrayList<TypeMeta>(this.basicRegistry.export());
        result.addAll(this.type2MetaDic.values());
        return result;
    }
}

