/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TypeInfo<T> {
    public final Class<T> rawType;
    public final List<Class<?>> typeArgs;
    public static final TypeInfo<Object> OBJECT = new TypeInfo<Object>(Object.class);
    public static final TypeInfo<Integer> INTEGER = new TypeInfo<Integer>(Integer.class);
    public static final TypeInfo<Long> LONG = new TypeInfo<Long>(Long.class);
    public static final TypeInfo<String> STRING = new TypeInfo<String>(String.class);
    public static final TypeInfo<Object> NONE = new TypeInfo<Object>(Object.class);
    public static final TypeInfo<ArrayList> ARRAYLIST = new TypeInfo<ArrayList>(ArrayList.class, Object.class);
    public static final TypeInfo<LinkedHashSet> LINKED_HASHSET = new TypeInfo<LinkedHashSet>(LinkedHashSet.class, Object.class);
    public static final TypeInfo<LinkedHashMap> LINKED_HASHMAP = new TypeInfo<LinkedHashMap>(LinkedHashMap.class, Object.class, Object.class);
    public static final TypeInfo<LinkedHashMap> STRING_LINKED_HASHMAP = new TypeInfo<LinkedHashMap>(LinkedHashMap.class, String.class, Object.class);
    public static final TypeInfo<HashMap> HASHMAP = new TypeInfo<HashMap>(HashMap.class, Object.class, Object.class);
    public static final TypeInfo<HashMap> STRING_HASHMAP = new TypeInfo<HashMap>(HashMap.class, String.class, Object.class);

    private TypeInfo(Class<T> rawType) {
        this.rawType = Objects.requireNonNull(rawType);
        this.typeArgs = List.of();
    }

    private TypeInfo(Class<T> rawType, List<Class<?>> typeArgs) {
        this.rawType = Objects.requireNonNull(rawType);
        this.typeArgs = typeArgs;
    }

    private TypeInfo(Class<T> rawType, Class<?> typeArg1) {
        this.rawType = Objects.requireNonNull(rawType);
        this.typeArgs = List.of(typeArg1);
    }

    private TypeInfo(Class<T> rawType, Class<?> typeArg1, Class<?> typeArg2) {
        this.rawType = Objects.requireNonNull(rawType);
        this.typeArgs = List.of(typeArg1, typeArg2);
    }

    public boolean isPrimitive() {
        return this.rawType.isPrimitive();
    }

    public boolean isGenericType() {
        return !this.rawType.isArray() && !this.typeArgs.isEmpty();
    }

    public TypeInfo<?> getGenericTypeDefinition() {
        if (this.isGenericType()) {
            return new TypeInfo<T>(this.rawType);
        }
        return null;
    }

    public TypeInfo<?> getGenericArgument(int idx) {
        return TypeInfo.of(this.typeArgs.get(idx));
    }

    public boolean isArray() {
        return this.rawType.isArray();
    }

    public TypeInfo<?> getComponentType() {
        if (this.rawType.isArray()) {
            return new TypeInfo(this.rawType.getComponentType(), this.typeArgs);
        }
        return null;
    }

    public TypeInfo<?> makeArrayType() {
        return new TypeInfo<T>(this.rawType.arrayType(), this.typeArgs);
    }

    public static <T> TypeInfo<T> of(Class<T> rawType) {
        if (rawType == Object.class) {
            return OBJECT;
        }
        if (rawType == String.class) {
            return STRING;
        }
        if (rawType == Integer.class) {
            return INTEGER;
        }
        if (rawType == Long.class) {
            return LONG;
        }
        return new TypeInfo<T>(rawType);
    }

    public static <T> TypeInfo<T> of(Class<T> rawType, Class<?> typeArg1) {
        return new TypeInfo<T>(rawType, List.of(typeArg1));
    }

    public static <T> TypeInfo<T> of(Class<T> rawType, Class<?> typeArg1, Class<?> typeArg2) {
        return new TypeInfo<T>(rawType, List.of(typeArg1, typeArg2));
    }

    public static <T> TypeInfo<T> of(Class<T> rawType, Class<?> typeArg1, Class<?> typeArg2, Class<?> typeArg3) {
        return new TypeInfo<T>(rawType, List.of(typeArg1, typeArg2, typeArg3));
    }

    public static <T> TypeInfo<T> of(Class<T> rawType, Class<?> ... typeArgs) {
        return new TypeInfo<T>(rawType, List.of(typeArgs));
    }

    public static <T> TypeInfo<T> of(Class<T> rawType, List<Class<?>> typeArgs) {
        return new TypeInfo<T>(rawType, List.copyOf(typeArgs));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeInfo typeInfo = (TypeInfo)o;
        if (!this.rawType.equals(typeInfo.rawType)) {
            return false;
        }
        return this.typeArgs.equals(typeInfo.typeArgs);
    }

    public int hashCode() {
        int result = this.rawType.hashCode();
        result = 31 * result + this.typeArgs.hashCode();
        return result;
    }

    public String toString() {
        return "TypeInfo{rawType=" + String.valueOf(this.rawType) + ", typeArgs=" + String.valueOf(this.typeArgs) + "}";
    }
}

