/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.TypeInfo;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TypeMeta {
    public final TypeInfo<?> typeInfo;
    public final ObjectStyle style;
    public final List<String> clsNames;

    private TypeMeta(TypeInfo<?> typeInfo, ObjectStyle style, List<String> clsNames) {
        if (clsNames.isEmpty()) {
            throw new IllegalArgumentException("clsNames is empty");
        }
        this.typeInfo = Objects.requireNonNull(typeInfo);
        this.style = Objects.requireNonNull(style);
        this.clsNames = List.copyOf(clsNames);
    }

    public String mainClsName() {
        return this.clsNames.get(0);
    }

    public static TypeMeta of(Class<?> clazz, ObjectStyle style) {
        return new TypeMeta(TypeInfo.of(clazz), style, List.of(clazz.getSimpleName()));
    }

    public static TypeMeta of(Class<?> clazz, ObjectStyle style, String clsName) {
        return new TypeMeta(TypeInfo.of(clazz), style, List.of(clsName));
    }

    public static TypeMeta of(Class<?> clazz, ObjectStyle style, String ... clsNames) {
        return new TypeMeta(TypeInfo.of(clazz), style, List.of(clsNames));
    }

    public static TypeMeta of(Class<?> clazz, ObjectStyle style, List<String> clsNames) {
        return new TypeMeta(TypeInfo.of(clazz), style, List.copyOf(clsNames));
    }

    public static TypeMeta of(TypeInfo<?> typeInfo, ObjectStyle style, String clsName) {
        return new TypeMeta(typeInfo, style, List.of(clsName));
    }

    public static TypeMeta of(TypeInfo<?> typeInfo, ObjectStyle style, String ... clsNames) {
        return new TypeMeta(typeInfo, style, List.of(clsNames));
    }

    public static TypeMeta of(TypeInfo<?> typeInfo, ObjectStyle style, List<String> clsNames) {
        return new TypeMeta(typeInfo, style, List.copyOf(clsNames));
    }

    public String toString() {
        return "TypeMeta{type=" + String.valueOf(this.typeInfo) + ", style=" + String.valueOf(this.style) + ", classNames=" + String.valueOf(this.clsNames) + "}";
    }
}

