/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.TypeMeta;
import cn.wjybxx.dsoncodec.TypeMetaRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;

public class TypeMetaRegistries {
    public static TypeMetaRegistry fromMapper(Set<Class<?>> typeSet, Function<Class<?>, TypeMeta> mapper) {
        ArrayList<TypeMeta> typeMetaList = new ArrayList<TypeMeta>();
        for (Class<?> clazz : typeSet) {
            TypeMeta typeMeta = mapper.apply(clazz);
            assert (typeMeta.typeInfo.rawType == clazz);
            typeMetaList.add(typeMeta);
        }
        return TypeMetaRegistries.fromMetas(typeMetaList);
    }

    public static TypeMetaRegistry fromRegistries(TypeMetaRegistry ... registries) {
        ArrayList<TypeMeta> typeMetaList = new ArrayList<TypeMeta>();
        for (TypeMetaRegistry e : registries) {
            typeMetaList.addAll(e.export());
        }
        return TypeMetaRegistries.fromMetas(typeMetaList);
    }

    public static TypeMetaRegistry fromMetas(TypeMeta ... typeMetas) {
        return TypeMetaRegistries.fromMetas(Arrays.asList(typeMetas));
    }

    public static TypeMetaRegistry fromMetas(List<TypeMeta> typeMetaList) {
        IdentityHashMap type2MetaMap = new IdentityHashMap(typeMetaList.size());
        IdentityHashMap clazz2MetaMap = new IdentityHashMap(typeMetaList.size());
        HashMap<String, TypeMeta> name2MetaMap = HashMap.newHashMap(typeMetaList.size());
        for (TypeMeta typeMeta : typeMetaList) {
            TypeInfo<?> typeInfo = typeMeta.typeInfo;
            if (type2MetaMap.containsKey(typeInfo)) {
                throw new IllegalArgumentException("type %s is duplicate".formatted(typeInfo));
            }
            type2MetaMap.put(typeInfo, typeMeta);
            if (!typeInfo.isGenericType()) {
                if (clazz2MetaMap.containsKey(typeInfo.rawType)) {
                    throw new IllegalArgumentException("type %s is duplicate".formatted(typeInfo));
                }
                clazz2MetaMap.put(typeInfo.rawType, typeMeta);
            }
            for (String clsName : typeMeta.clsNames) {
                if (name2MetaMap.containsKey(clsName)) {
                    throw new IllegalArgumentException("clsName %s is duplicate".formatted(clsName));
                }
                name2MetaMap.put(clsName, typeMeta);
            }
        }
        return new TypeMetaRegistryImpl(type2MetaMap, clazz2MetaMap, name2MetaMap);
    }

    private static class TypeMetaRegistryImpl
    implements TypeMetaRegistry {
        private final Map<TypeInfo<?>, TypeMeta> type2MetaMap;
        private final Map<Class<?>, TypeMeta> clazz2MetaMap;
        private final Map<String, TypeMeta> name2MetaMap;

        TypeMetaRegistryImpl(Map<TypeInfo<?>, TypeMeta> type2MetaMap, Map<Class<?>, TypeMeta> clazz2MetaMap, Map<String, TypeMeta> name2MetaMap) {
            this.type2MetaMap = type2MetaMap;
            this.clazz2MetaMap = clazz2MetaMap;
            this.name2MetaMap = name2MetaMap;
        }

        @Override
        @Nullable
        public TypeMeta ofType(TypeInfo<?> type) {
            return this.type2MetaMap.get(type);
        }

        @Override
        @Nullable
        public TypeMeta ofClass(Class<?> clazz) {
            return this.clazz2MetaMap.get(clazz);
        }

        @Override
        public TypeMeta ofName(String clsName) {
            return this.name2MetaMap.get(clsName);
        }

        @Override
        public List<TypeMeta> export() {
            return new ArrayList<TypeMeta>(this.type2MetaMap.values());
        }
    }
}

