/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.codecs;

import cn.wjybxx.dson.DsonType;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonConverterUtils;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.annotations.DsonCodecScanIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@DsonCodecScanIgnore
public class CollectionCodec<T extends Collection>
implements DsonCodec<T> {
    final Class<T> clazz;
    final Supplier<? extends T> factory;

    public CollectionCodec() {
        this.clazz = Collection.class;
        this.factory = null;
    }

    public CollectionCodec(Class<T> clazz, Supplier<? extends T> factory) {
        this.clazz = Objects.requireNonNull(clazz);
        this.factory = factory;
    }

    @Override
    @Nonnull
    public Class<T> getEncoderClass() {
        return this.clazz;
    }

    private Collection<Object> newCollection(TypeInfo<?> typeInfo, Supplier<? extends T> factory) {
        if (factory != null) {
            return (Collection)factory.get();
        }
        if (this.factory != null) {
            return (Collection)this.factory.get();
        }
        if (Set.class.isAssignableFrom(typeInfo.rawType)) {
            return new LinkedHashSet<Object>();
        }
        return new ArrayList<Object>();
    }

    private static TypeInfo<?> getElementTypeInfo(TypeInfo<?> typeInfo) {
        if (typeInfo.isGenericType()) {
            return typeInfo.getGenericArgument(0);
        }
        TypeInfo<?> elementTypeInfo = DsonConverterUtils.getElementActualTypeInfo(typeInfo.rawType);
        return elementTypeInfo != null ? elementTypeInfo : TypeInfo.OBJECT;
    }

    @Override
    public void writeObject(DsonObjectWriter writer, T instance, TypeInfo<?> typeInfo, ObjectStyle style) {
        TypeInfo<?> componentArgInfo = CollectionCodec.getElementTypeInfo(typeInfo);
        for (Object e : instance) {
            writer.writeObject(null, e, componentArgInfo, null);
        }
    }

    @Override
    public T readObject(DsonObjectReader reader, TypeInfo<?> typeInfo, Supplier<? extends T> factory) {
        TypeInfo<?> componentArgInfo = CollectionCodec.getElementTypeInfo(typeInfo);
        Collection<Object> result = this.newCollection(typeInfo, factory);
        while (reader.readDsonType() != DsonType.END_OF_OBJECT) {
            result.add(reader.readObject(null, componentArgInfo));
        }
        return (T)((Collection)this.clazz.cast(result));
    }
}

