/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.codecs;

import cn.wjybxx.base.EnumLite;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dson.text.StringStyle;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.annotations.DsonCodecScanIgnore;
import cn.wjybxx.dsoncodec.codecs.AbstractEnumCodec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@DsonCodecScanIgnore
public class EnumCodec<T extends EnumLite>
extends AbstractEnumCodec<T>
implements DsonCodec<T> {
    private final Class<T> encoderClass;
    private final IntFunction<T> mapper;
    private final Map<String, T> name2EnumMap;

    public EnumCodec(Class<T> encoderClass, IntFunction<T> mapper) {
        if (!encoderClass.isEnum()) {
            throw new IllegalArgumentException("EnumLite must be enum class, type: " + String.valueOf(encoderClass));
        }
        boolean overrideToString = Arrays.stream(encoderClass.getDeclaredMethods()).anyMatch(e -> "toString".equals(e.getName()));
        if (overrideToString) {
            throw new IllegalArgumentException("enum class cannot override toString methods, type: " + String.valueOf(encoderClass));
        }
        this.encoderClass = Objects.requireNonNull(encoderClass);
        this.mapper = Objects.requireNonNull(mapper);
        EnumLite[] enumConstants = (EnumLite[])encoderClass.getEnumConstants();
        this.name2EnumMap = HashMap.newHashMap(enumConstants.length);
        for (EnumLite enumConstant : enumConstants) {
            Enum anEnum = (Enum)enumConstant;
            this.name2EnumMap.put(anEnum.name(), enumConstant);
        }
    }

    @Override
    @Nullable
    public T forName(String name) {
        return (T)((EnumLite)this.name2EnumMap.get(name));
    }

    @Override
    @Nullable
    public T forNumber(int number) {
        return (T)((EnumLite)this.mapper.apply(number));
    }

    @Override
    @Nonnull
    public final Class<T> getEncoderClass() {
        return this.encoderClass;
    }

    @Override
    public final boolean autoStartEnd() {
        return false;
    }

    @Override
    public void writeObject(DsonObjectWriter writer, T instance, TypeInfo<?> typeInfo, ObjectStyle style) {
        if (writer.options().writeEnumAsString) {
            writer.writeString(null, instance.toString(), StringStyle.UNQUOTE);
        } else {
            writer.writeInt(null, instance.getNumber());
        }
    }

    @Override
    public T readObject(DsonObjectReader reader, TypeInfo<?> typeInfo, Supplier<? extends T> factory) {
        if (reader.options().writeEnumAsString) {
            return (T)((EnumLite)this.name2EnumMap.get(reader.readString(reader.getCurrentName())));
        }
        return (T)((EnumLite)this.mapper.apply(reader.readInt(reader.getCurrentName())));
    }
}

