/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.codecs;

import cn.wjybxx.dson.text.INumberStyle;
import cn.wjybxx.dson.text.NumberStyle;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.annotations.DsonCodecScanIgnore;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@DsonCodecScanIgnore
public class FloatCodec
implements DsonCodec<Float> {
    @Override
    public boolean isWriteAsArray() {
        return false;
    }

    @Override
    public boolean autoStartEnd() {
        return false;
    }

    @Override
    @Nonnull
    public Class<Float> getEncoderClass() {
        return Float.class;
    }

    @Override
    public void writeObject(DsonObjectWriter writer, Float instance, TypeInfo<?> typeInfo, ObjectStyle style) {
        NumberStyle numberStyle = typeInfo.rawType == Float.class || typeInfo.rawType == Float.TYPE ? NumberStyle.SIMPLE : NumberStyle.TYPED;
        writer.writeFloat(null, instance.floatValue(), (INumberStyle)numberStyle);
    }

    @Override
    public Float readObject(DsonObjectReader reader, TypeInfo<?> typeInfo, Supplier<? extends Float> factory) {
        return Float.valueOf(reader.readFloat(reader.getCurrentName()));
    }
}

