/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.codecs;

import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dson.types.Timestamp;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.annotations.DsonCodecScanIgnore;
import java.time.Instant;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@DsonCodecScanIgnore
public class InstantCodec
implements DsonCodec<Instant> {
    @Override
    public boolean isWriteAsArray() {
        return false;
    }

    @Override
    public boolean autoStartEnd() {
        return false;
    }

    @Override
    @Nonnull
    public Class<Instant> getEncoderClass() {
        return Instant.class;
    }

    @Override
    public void writeObject(DsonObjectWriter writer, Instant instance, TypeInfo<?> typeInfo, ObjectStyle style) {
        writer.writeTimestamp(null, Timestamp.ofInstant((Instant)instance));
    }

    @Override
    public Instant readObject(DsonObjectReader reader, TypeInfo<?> typeInfo, Supplier<? extends Instant> factory) {
        Timestamp timestamp = reader.readTimestamp(reader.getCurrentName());
        return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
    }
}

