/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.codecs;

import cn.wjybxx.dson.WireType;
import cn.wjybxx.dson.text.INumberStyle;
import cn.wjybxx.dson.text.NumberStyle;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.annotations.DsonCodecScanIgnore;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@DsonCodecScanIgnore
public class Int64Codec
implements DsonCodec<Long> {
    @Override
    public boolean isWriteAsArray() {
        return false;
    }

    @Override
    public boolean autoStartEnd() {
        return false;
    }

    @Override
    @Nonnull
    public Class<Long> getEncoderClass() {
        return Long.class;
    }

    @Override
    public void writeObject(DsonObjectWriter writer, Long instance, TypeInfo<?> typeInfo, ObjectStyle style) {
        NumberStyle numberStyle = typeInfo.rawType == Long.class || typeInfo.rawType == Long.TYPE ? NumberStyle.SIMPLE : NumberStyle.TYPED;
        writer.writeLong(null, instance, WireType.VARINT, (INumberStyle)numberStyle);
    }

    @Override
    public Long readObject(DsonObjectReader reader, TypeInfo<?> typeInfo, Supplier<? extends Long> factory) {
        return reader.readLong(reader.getCurrentName());
    }
}

