/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.codecs;

import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dson.types.ExtDateTime;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.annotations.DsonCodecScanIgnore;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@DsonCodecScanIgnore
public class LocalDateCodec
implements DsonCodec<LocalDate> {
    @Override
    public boolean isWriteAsArray() {
        return false;
    }

    @Override
    public boolean autoStartEnd() {
        return false;
    }

    @Override
    @Nonnull
    public Class<LocalDate> getEncoderClass() {
        return LocalDate.class;
    }

    @Override
    public void writeObject(DsonObjectWriter writer, LocalDate instance, TypeInfo<?> typeInfo, ObjectStyle style) {
        ExtDateTime dateTime = LocalDateCodec.toDateTime(instance);
        writer.writeExtDateTime(null, dateTime);
    }

    @Override
    public LocalDate readObject(DsonObjectReader reader, TypeInfo<?> typeInfo, Supplier<? extends LocalDate> factory) {
        ExtDateTime dateTime = reader.readExtDateTime(reader.getCurrentName());
        return LocalDateCodec.ofDateTime(dateTime);
    }

    private static LocalDate ofDateTime(ExtDateTime dateTime) {
        LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(dateTime.getSeconds(), 0, ZoneOffset.UTC);
        return localDateTime.toLocalDate();
    }

    private static ExtDateTime toDateTime(LocalDate localDate) {
        long epochSecond = localDate.toEpochSecond(LocalTime.MIN, ZoneOffset.UTC);
        return new ExtDateTime(epochSecond, 0, 0, 1);
    }
}

