/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.codecs;

import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dson.types.ExtDateTime;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.annotations.DsonCodecScanIgnore;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@DsonCodecScanIgnore
public class LocalDateTimeCodec
implements DsonCodec<LocalDateTime> {
    @Override
    public boolean isWriteAsArray() {
        return false;
    }

    @Override
    public boolean autoStartEnd() {
        return false;
    }

    @Override
    @Nonnull
    public Class<LocalDateTime> getEncoderClass() {
        return LocalDateTime.class;
    }

    @Override
    public void writeObject(DsonObjectWriter writer, LocalDateTime instance, TypeInfo<?> typeInfo, ObjectStyle style) {
        ExtDateTime dateTime = ExtDateTime.ofDateTime((LocalDateTime)instance);
        writer.writeExtDateTime(null, dateTime);
    }

    @Override
    public LocalDateTime readObject(DsonObjectReader reader, TypeInfo<?> typeInfo, Supplier<? extends LocalDateTime> factory) {
        ExtDateTime dateTime = reader.readExtDateTime(reader.getCurrentName());
        return LocalDateTime.ofEpochSecond(dateTime.getSeconds(), dateTime.getNanos(), ZoneOffset.UTC);
    }
}

