/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.codecs;

import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dson.types.ExtDateTime;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.annotations.DsonCodecScanIgnore;
import java.time.LocalTime;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@DsonCodecScanIgnore
public class LocalTimeCodec
implements DsonCodec<LocalTime> {
    @Override
    public boolean isWriteAsArray() {
        return false;
    }

    @Override
    public boolean autoStartEnd() {
        return false;
    }

    @Override
    @Nonnull
    public Class<LocalTime> getEncoderClass() {
        return LocalTime.class;
    }

    @Override
    public void writeObject(DsonObjectWriter writer, LocalTime instance, TypeInfo<?> typeInfo, ObjectStyle style) {
        writer.writeExtDateTime(null, LocalTimeCodec.toDateTime(instance));
    }

    @Override
    public LocalTime readObject(DsonObjectReader reader, TypeInfo<?> typeInfo, Supplier<? extends LocalTime> factory) {
        ExtDateTime dateTime = reader.readExtDateTime(reader.getCurrentName());
        return LocalTimeCodec.ofDateTime(dateTime);
    }

    private static LocalTime ofDateTime(ExtDateTime dateTime) {
        long nanoOfDay = dateTime.getSeconds() * 1000000000L + (long)dateTime.getNanos();
        return LocalTime.ofNanoOfDay(nanoOfDay);
    }

    private static ExtDateTime toDateTime(LocalTime localTime) {
        return new ExtDateTime((long)localTime.toSecondOfDay(), localTime.getNano(), 0, 2);
    }
}

