/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.codecs;

import cn.wjybxx.dson.DsonType;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonConverterUtils;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.annotations.DsonCodecScanIgnore;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@DsonCodecScanIgnore
public class MapCodec<T extends Map>
implements DsonCodec<T> {
    final Class<T> clazz;
    final Supplier<? extends T> factory;

    public MapCodec() {
        this.clazz = Map.class;
        this.factory = null;
    }

    public MapCodec(Class<T> clazz, Supplier<? extends T> factory) {
        this.clazz = Objects.requireNonNull(clazz);
        this.factory = factory;
    }

    @Override
    public boolean autoStartEnd() {
        return false;
    }

    @Override
    @Nonnull
    public Class<T> getEncoderClass() {
        return this.clazz;
    }

    private Map<Object, Object> newMap(TypeInfo<?> typeInfo, Supplier<? extends T> factory) {
        if (factory != null) {
            return (Map)factory.get();
        }
        if (this.factory != null) {
            return (Map)this.factory.get();
        }
        return new LinkedHashMap<Object, Object>();
    }

    @Override
    public void writeObject(DsonObjectWriter writer, T instance, TypeInfo<?> typeInfo, ObjectStyle style) {
        TypeInfo<Object> valueArgInfo;
        TypeInfo<Object> keyArgInfo;
        if (typeInfo.typeArgs.size() == 2 && typeInfo.isGenericType()) {
            keyArgInfo = typeInfo.getGenericArgument(0);
            valueArgInfo = typeInfo.getGenericArgument(1);
        } else if (typeInfo.typeArgs.size() == 1 && (keyArgInfo = DsonConverterUtils.getKeyActualTypeInfo(typeInfo.rawType)) != null) {
            valueArgInfo = typeInfo.getGenericArgument(0);
        } else {
            valueArgInfo = TypeInfo.OBJECT;
            keyArgInfo = valueArgInfo;
        }
        Set entrySet = instance.entrySet();
        if (writer.options().writeMapAsDocument) {
            writer.writeStartObject(instance, typeInfo, style);
            for (Map.Entry entry : entrySet) {
                String keyString = writer.encodeKey(entry.getKey());
                Object value = entry.getValue();
                if (value == null) {
                    writer.writeName(keyString);
                    writer.writeNull(keyString);
                    continue;
                }
                writer.writeObject(keyString, value, valueArgInfo, null);
            }
            writer.writeEndObject();
        } else {
            writer.writeStartArray(instance, typeInfo, style);
            for (Map.Entry entry : entrySet) {
                writer.writeObject(null, entry.getKey(), keyArgInfo, null);
                writer.writeObject(null, entry.getValue(), valueArgInfo, null);
            }
            writer.writeEndArray();
        }
    }

    @Override
    public T readObject(DsonObjectReader reader, TypeInfo<?> typeInfo, Supplier<? extends T> factory) {
        TypeInfo<Object> valueArgInfo;
        TypeInfo<Object> keyArgInfo;
        if (typeInfo.typeArgs.size() == 2 && typeInfo.isGenericType()) {
            keyArgInfo = typeInfo.getGenericArgument(0);
            valueArgInfo = typeInfo.getGenericArgument(1);
        } else if (typeInfo.typeArgs.size() == 1 && (keyArgInfo = DsonConverterUtils.getKeyActualTypeInfo(typeInfo.rawType)) != null) {
            valueArgInfo = typeInfo.getGenericArgument(0);
        } else {
            valueArgInfo = TypeInfo.OBJECT;
            keyArgInfo = valueArgInfo;
        }
        Map<Object, Object> result = this.newMap(typeInfo, factory);
        if (reader.options().writeMapAsDocument) {
            reader.readStartObject();
            while (reader.readDsonType() != DsonType.END_OF_OBJECT) {
                String keyString = reader.readName();
                Object key = reader.decodeKey(keyString, keyArgInfo.rawType);
                Object value = reader.readObject(keyString, valueArgInfo);
                result.put(key, value);
            }
            reader.readEndObject();
        } else {
            reader.readStartArray();
            while (reader.readDsonType() != DsonType.END_OF_OBJECT) {
                Object key = reader.readObject(null, keyArgInfo);
                Object value = reader.readObject(null, valueArgInfo);
                result.put(key, value);
            }
            reader.readEndArray();
        }
        return (T)((Map)this.clazz.cast(result));
    }
}

