/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.codecs;

import cn.wjybxx.base.tuple.Tuple2;
import cn.wjybxx.dson.DsonType;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonCodecException;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.MapEncodeProxy;
import cn.wjybxx.dsoncodec.TypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class MapEncodeProxyCodec
implements DsonCodec<MapEncodeProxy> {
    @Override
    @Nonnull
    public Class<MapEncodeProxy> getEncoderClass() {
        return MapEncodeProxy.class;
    }

    @Override
    public boolean autoStartEnd() {
        return false;
    }

    @Override
    public void writeObject(DsonObjectWriter writer, MapEncodeProxy instance, TypeInfo<?> typeInfo, ObjectStyle style) {
        TypeInfo<Object> valueArgInfo = typeInfo.isGenericType() ? typeInfo.getGenericArgument(0) : TypeInfo.OBJECT;
        Collection entries = Objects.requireNonNull(instance.getEntries());
        switch (instance.getMode()) {
            default: {
                writer.writeStartObject(instance, typeInfo, style);
                for (Map.Entry entry : entries) {
                    writer.writeName(entry.getKey());
                    writer.writeObject(entry.getKey(), entry.getValue(), valueArgInfo, null);
                }
                writer.writeEndObject();
                break;
            }
            case 1: {
                writer.writeStartArray(instance, typeInfo, style);
                for (Map.Entry entry : entries) {
                    writer.writeString(null, entry.getKey());
                    writer.writeObject(null, entry.getValue(), valueArgInfo, null);
                }
                writer.writeEndArray();
                break;
            }
            case 2: {
                TypeInfo<Map.Entry> pairTypeInfo = TypeInfo.of(Map.Entry.class, String.class, valueArgInfo.rawType);
                writer.writeStartArray(instance, typeInfo, style);
                for (Map.Entry entry : entries) {
                    writer.writeStartArray(entry, pairTypeInfo);
                    writer.writeString(null, entry.getKey());
                    writer.writeObject(null, entry.getValue(), valueArgInfo, null);
                    writer.writeEndArray();
                }
                writer.writeEndArray();
                break;
            }
            case 3: {
                TypeInfo<Map.Entry> pairTypeInfo = TypeInfo.of(Map.Entry.class, String.class, valueArgInfo.rawType);
                writer.writeStartArray(instance, typeInfo, style);
                for (Map.Entry entry : entries) {
                    writer.writeStartObject(entry, pairTypeInfo);
                    writer.writeObject(entry.getKey(), entry.getValue(), valueArgInfo);
                    writer.writeEndObject();
                }
                writer.writeEndArray();
            }
        }
    }

    @Override
    public MapEncodeProxy readObject(DsonObjectReader reader, TypeInfo<?> typeInfo, Supplier<? extends MapEncodeProxy> factory) {
        TypeInfo<Object> valueArgInfo = typeInfo.isGenericType() ? typeInfo.getGenericArgument(0) : TypeInfo.OBJECT;
        ArrayList entries = new ArrayList();
        MapEncodeProxy result = new MapEncodeProxy();
        result.setEntries(entries);
        DsonType currentDsonType = reader.getCurrentDsonType();
        if (currentDsonType == DsonType.OBJECT) {
            result.setWriteAsDocument();
            reader.readStartObject();
            while (reader.readDsonType() != DsonType.END_OF_OBJECT) {
                String key = reader.readName();
                Object value = reader.readObject(key, valueArgInfo);
                entries.add(Tuple2.of((Object)key, (Object)value));
            }
            reader.readEndObject();
        } else {
            assert (currentDsonType == DsonType.ARRAY);
            reader.readStartArray();
            DsonType firstDsonType = reader.readDsonType();
            switch (firstDsonType) {
                case STRING: {
                    result.setWriteAsArray();
                    do {
                        String key = reader.readString(null);
                        Object value = reader.readObject(null, valueArgInfo);
                        entries.add(Tuple2.of((Object)key, (Object)value));
                    } while (reader.readDsonType() != DsonType.END_OF_OBJECT);
                    break;
                }
                case ARRAY: {
                    result.setWritePairAsArray();
                    do {
                        reader.readStartArray();
                        String key = reader.readString(null);
                        Object value = reader.readObject(null, valueArgInfo);
                        entries.add(Tuple2.of((Object)key, (Object)value));
                        reader.readEndArray();
                    } while (reader.readDsonType() != DsonType.END_OF_OBJECT);
                    break;
                }
                case OBJECT: {
                    result.setWritePairAsDocument();
                    do {
                        reader.readStartObject();
                        String key = reader.readName();
                        Object value = reader.readObject(key, valueArgInfo);
                        entries.add(Tuple2.of((Object)key, (Object)value));
                        reader.readEndObject();
                    } while (reader.readDsonType() != DsonType.END_OF_OBJECT);
                    break;
                }
                case END_OF_OBJECT: {
                    break;
                }
                default: {
                    throw new DsonCodecException("unexpected dsonType: " + String.valueOf(firstDsonType));
                }
            }
            reader.readEndArray();
        }
        return result;
    }
}

