/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public abstract class AbstractDsonCodec<T>
implements DsonCodec<T> {
    @Override
    @Nonnull
    public abstract TypeInfo getEncoderType();

    @Override
    public void writeObject(DsonObjectWriter writer, T inst, TypeInfo declaredType, ObjectStyle style) {
        if (writer.options().enableBeforeEncode) {
            this.beforeEncode(writer, inst);
        }
        this.writeFields(writer, inst);
    }

    protected void beforeEncode(DsonObjectWriter writer, T inst) {
    }

    public abstract void writeFields(DsonObjectWriter var1, T var2);

    @Override
    public T readObject(DsonObjectReader reader, Supplier<? extends T> factory) {
        T instance = factory != null ? factory.get() : this.newInstance(reader);
        this.readFields(reader, instance);
        if (reader.options().enableAfterDecode) {
            this.afterDecode(reader, instance);
        }
        return instance;
    }

    protected abstract T newInstance(DsonObjectReader var1);

    public abstract void readFields(DsonObjectReader var1, T var2);

    protected void afterDecode(DsonObjectReader reader, T inst) {
    }
}

