/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.base.pool.ArrayPool;
import cn.wjybxx.base.pool.ConcurrentArrayPool;
import cn.wjybxx.base.pool.ConcurrentObjectPool;
import cn.wjybxx.base.pool.ObjectPool;
import cn.wjybxx.dson.DsonReaderSettings;
import cn.wjybxx.dson.DsonWriterSettings;
import cn.wjybxx.dson.text.DsonTextReaderSettings;
import cn.wjybxx.dson.text.DsonTextWriterSettings;
import cn.wjybxx.dsoncodec.TypeWritePolicy;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ConverterOptions {
    public final TypeWritePolicy typeWritePolicy;
    public final boolean appendDef;
    public final boolean appendNull;
    public final boolean writeMapAsDocument;
    public final boolean writeEnumAsString;
    public final boolean randomRead;
    public final boolean readAsImmutable;
    public final boolean enableBeforeEncode;
    public final boolean enableAfterDecode;
    public final int pbBinaryType;
    public final int usage;
    public final int bufferSize;
    public final ArrayPool<byte[]> bufferPool;
    public final ObjectPool<StringBuilder> stringBuilderPool;
    public final DsonReaderSettings binReaderSettings;
    public final DsonWriterSettings binWriterSettings;
    public final DsonTextReaderSettings textReaderSettings;
    public final DsonTextWriterSettings textWriterSettings;
    public static ConverterOptions DEFAULT = ConverterOptions.newBuilder().build();

    public ConverterOptions(Builder builder) {
        this.typeWritePolicy = builder.typeWritePolicy;
        this.appendDef = builder.appendDef;
        this.appendNull = builder.appendNull;
        this.writeMapAsDocument = builder.writeMapAsDocument;
        this.writeEnumAsString = builder.writeEnumAsString;
        this.randomRead = builder.randomRead;
        this.readAsImmutable = builder.readAsImmutable;
        this.enableBeforeEncode = builder.enableBeforeEncode;
        this.enableAfterDecode = builder.enableAfterDecode;
        this.pbBinaryType = builder.pbBinaryType;
        this.usage = builder.usage;
        this.bufferSize = builder.bufferSize;
        this.bufferPool = Objects.requireNonNull(builder.bufferPool);
        this.stringBuilderPool = Objects.requireNonNull(builder.stringBuilderPool);
        this.binReaderSettings = Objects.requireNonNull(builder.binReaderSettings);
        this.binWriterSettings = Objects.requireNonNull(builder.binWriterSettings);
        this.textReaderSettings = Objects.requireNonNull(builder.textReaderSettings);
        this.textWriterSettings = Objects.requireNonNull(builder.textWriterSettings);
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        this.assignToBuilder(builder);
        return builder;
    }

    public void assignToBuilder(Builder builder) {
        builder.typeWritePolicy = this.typeWritePolicy;
        builder.appendDef = this.appendDef;
        builder.appendNull = this.appendNull;
        builder.writeMapAsDocument = this.writeMapAsDocument;
        builder.writeEnumAsString = this.writeEnumAsString;
        builder.randomRead = this.randomRead;
        builder.readAsImmutable = this.readAsImmutable;
        builder.enableBeforeEncode = this.enableBeforeEncode;
        builder.enableAfterDecode = this.enableAfterDecode;
        builder.pbBinaryType = this.pbBinaryType;
        builder.usage = this.usage;
        builder.bufferSize = this.bufferSize;
        builder.bufferPool = this.bufferPool;
        builder.stringBuilderPool = this.stringBuilderPool;
        builder.binReaderSettings = this.binReaderSettings;
        builder.binWriterSettings = this.binWriterSettings;
        builder.textReaderSettings = this.textReaderSettings;
        builder.textWriterSettings = this.textWriterSettings;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private TypeWritePolicy typeWritePolicy = TypeWritePolicy.OPTIMIZED;
        private boolean appendDef = true;
        private boolean appendNull = true;
        private boolean writeMapAsDocument = false;
        private boolean writeEnumAsString = false;
        private boolean randomRead = true;
        private boolean enableBeforeEncode = false;
        private boolean enableAfterDecode = true;
        private boolean readAsImmutable = false;
        private int pbBinaryType = 127;
        private int usage;
        private int bufferSize = 8192;
        private ArrayPool<byte[]> bufferPool = ConcurrentArrayPool.SHARED_BYTE_ARRAY_POOL;
        private ObjectPool<StringBuilder> stringBuilderPool = ConcurrentObjectPool.SHARED_STRING_BUILDER_POOL;
        private DsonReaderSettings binReaderSettings = DsonReaderSettings.DEFAULT;
        private DsonWriterSettings binWriterSettings = DsonWriterSettings.DEFAULT;
        private DsonTextReaderSettings textReaderSettings = DsonTextReaderSettings.DEFAULT;
        private DsonTextWriterSettings textWriterSettings = DsonTextWriterSettings.DEFAULT;

        public ConverterOptions build() {
            return new ConverterOptions(this);
        }

        public TypeWritePolicy getTypeWritePolicy() {
            return this.typeWritePolicy;
        }

        public Builder setTypeWritePolicy(TypeWritePolicy typeWritePolicy) {
            this.typeWritePolicy = typeWritePolicy;
            return this;
        }

        public boolean isAppendDef() {
            return this.appendDef;
        }

        public Builder setAppendDef(boolean appendDef) {
            this.appendDef = appendDef;
            return this;
        }

        public boolean isAppendNull() {
            return this.appendNull;
        }

        public Builder setAppendNull(boolean appendNull) {
            this.appendNull = appendNull;
            return this;
        }

        public boolean isWriteMapAsDocument() {
            return this.writeMapAsDocument;
        }

        public Builder setWriteMapAsDocument(boolean writeMapAsDocument) {
            this.writeMapAsDocument = writeMapAsDocument;
            return this;
        }

        public boolean isWriteEnumAsString() {
            return this.writeEnumAsString;
        }

        public Builder setWriteEnumAsString(boolean writeEnumAsString) {
            this.writeEnumAsString = writeEnumAsString;
            return this;
        }

        public boolean isRandomRead() {
            return this.randomRead;
        }

        public Builder setRandomRead(boolean randomRead) {
            this.randomRead = randomRead;
            return this;
        }

        public int getPbBinaryType() {
            return this.pbBinaryType;
        }

        public Builder setPbBinaryType(int pbBinaryType) {
            this.pbBinaryType = pbBinaryType;
            return this;
        }

        public int getUsage() {
            return this.usage;
        }

        public Builder setUsage(int usage) {
            this.usage = usage;
            return this;
        }

        public boolean isReadAsImmutable() {
            return this.readAsImmutable;
        }

        public Builder setReadAsImmutable(boolean readAsImmutable) {
            this.readAsImmutable = readAsImmutable;
            return this;
        }

        public boolean isEnableBeforeEncode() {
            return this.enableBeforeEncode;
        }

        public Builder setEnableBeforeEncode(boolean enableBeforeEncode) {
            this.enableBeforeEncode = enableBeforeEncode;
            return this;
        }

        public boolean isEnableAfterDecode() {
            return this.enableAfterDecode;
        }

        public Builder setEnableAfterDecode(boolean enableAfterDecode) {
            this.enableAfterDecode = enableAfterDecode;
            return this;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public Builder setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public ArrayPool<byte[]> getBufferPool() {
            return this.bufferPool;
        }

        public Builder setBufferPool(ArrayPool<byte[]> bufferPool) {
            this.bufferPool = bufferPool;
            return this;
        }

        public ObjectPool<StringBuilder> getStringBuilderPool() {
            return this.stringBuilderPool;
        }

        public Builder setStringBuilderPool(ObjectPool<StringBuilder> stringBuilderPool) {
            this.stringBuilderPool = stringBuilderPool;
            return this;
        }

        public DsonReaderSettings getBinReaderSettings() {
            return this.binReaderSettings;
        }

        public Builder setBinReaderSettings(DsonReaderSettings binReaderSettings) {
            this.binReaderSettings = binReaderSettings;
            return this;
        }

        public DsonWriterSettings getBinWriterSettings() {
            return this.binWriterSettings;
        }

        public Builder setBinWriterSettings(DsonWriterSettings binWriterSettings) {
            this.binWriterSettings = binWriterSettings;
            return this;
        }

        public DsonTextReaderSettings getTextReaderSettings() {
            return this.textReaderSettings;
        }

        public Builder setTextReaderSettings(DsonTextReaderSettings textReaderSettings) {
            this.textReaderSettings = textReaderSettings;
            return this;
        }

        public DsonTextWriterSettings getTextWriterSettings() {
            return this.textWriterSettings;
        }

        public Builder setTextWriterSettings(DsonTextWriterSettings textWriterSettings) {
            this.textWriterSettings = textWriterSettings;
            return this;
        }
    }
}

