/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonCodecCaster;
import cn.wjybxx.dsoncodec.DsonCodecConfig;
import cn.wjybxx.dsoncodec.DsonCodecException;
import cn.wjybxx.dsoncodec.DsonCodecImpl;
import cn.wjybxx.dsoncodec.DsonCodecRegistry;
import cn.wjybxx.dsoncodec.GenericCodecInfo;
import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.codecs.ArrayCodec;
import cn.wjybxx.dsoncodec.codecs.EnumCodec;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicCodecRegistry
implements DsonCodecRegistry {
    private static final Logger logger = LoggerFactory.getLogger(DynamicCodecRegistry.class);
    private final DsonCodecConfig config;
    private final List<DsonCodecCaster> casters;
    private final ConcurrentHashMap<TypeInfo, DsonCodecImpl<?>> encoderDic = new ConcurrentHashMap();
    private final ConcurrentHashMap<TypeInfo, DsonCodecImpl<?>> decoderDic = new ConcurrentHashMap();

    public DynamicCodecRegistry(DsonCodecConfig config) {
        this.config = config = config.toImmutable();
        this.casters = config.getCasters();
        config.getEncoderDic().forEach((typeInfo, dsonCodec) -> this.encoderDic.put((TypeInfo)typeInfo, new DsonCodecImpl(dsonCodec)));
        config.getDecoderDic().forEach((typeInfo, dsonCodec) -> this.decoderDic.put((TypeInfo)typeInfo, new DsonCodecImpl(dsonCodec)));
    }

    @Override
    @Nullable
    public DsonCodecImpl<?> getEncoder(TypeInfo type) {
        DsonCodecImpl<?> codecImpl = this.encoderDic.get(type);
        if (codecImpl != null) {
            return codecImpl;
        }
        if (type.isEnum()) {
            codecImpl = this.makeEnumCodec(type);
        } else if (type.isArrayType()) {
            codecImpl = this.makeArrayCodec(type);
        } else if (type.isGenericType()) {
            GenericCodecInfo genericCodecInfo = this.config.getGenericEncoderInfo(type.rawType);
            if (genericCodecInfo != null) {
                codecImpl = this.makeGenericCodec(type, genericCodecInfo);
            } else {
                TypeInfo superType = this.castEncoderType(type);
                if (superType != null) {
                    codecImpl = this.getEncoder(superType);
                }
            }
        } else {
            TypeInfo superType = this.castEncoderType(type);
            if (superType != null) {
                codecImpl = this.getEncoder(superType);
            }
        }
        if (codecImpl != null) {
            this.encoderDic.putIfAbsent(type, codecImpl);
            if (type.rawType == codecImpl.getEncoderType().rawType) {
                this.decoderDic.putIfAbsent(type, codecImpl);
            }
        }
        return codecImpl;
    }

    @Override
    @Nullable
    public DsonCodecImpl<?> getDecoder(TypeInfo type) {
        DsonCodecImpl<?> codecImpl = this.decoderDic.get(type);
        if (codecImpl != null) {
            return codecImpl;
        }
        if (type.isEnum()) {
            codecImpl = this.makeEnumCodec(type);
        } else if (type.isArrayType()) {
            codecImpl = this.makeArrayCodec(type);
        } else if (type.isGenericType()) {
            GenericCodecInfo genericCodecInfo = this.config.getGenericDecoderInfo(type.rawType);
            if (genericCodecInfo != null) {
                codecImpl = this.makeGenericCodec(type, genericCodecInfo);
            } else {
                TypeInfo subType = this.castDecoderType(type);
                if (subType != null) {
                    codecImpl = this.getDecoder(subType);
                }
            }
        } else {
            TypeInfo subType = this.castDecoderType(type);
            if (subType != null) {
                codecImpl = this.getDecoder(subType);
            }
        }
        if (codecImpl != null) {
            this.decoderDic.putIfAbsent(type, codecImpl);
            if (type.rawType == codecImpl.getEncoderType().rawType) {
                this.encoderDic.putIfAbsent(type, codecImpl);
            }
        }
        return codecImpl;
    }

    private DsonCodecImpl<?> makeArrayCodec(TypeInfo type) {
        return new DsonCodecImpl<T[]>(new ArrayCodec(type));
    }

    private DsonCodecImpl<?> makeEnumCodec(TypeInfo type) {
        return new DsonCodecImpl(new EnumCodec(type.rawType));
    }

    private DsonCodecImpl<?> makeGenericCodec(TypeInfo type, GenericCodecInfo genericCodecInfo) {
        assert (type.rawType == genericCodecInfo.typeInfo.rawType);
        if (type.genericArgs.size() != genericCodecInfo.typeInfo.genericArgs.size()) {
            type = genericCodecInfo.typeInfo;
        }
        Class<? extends DsonCodec> genericCodecTypeDefine = genericCodecInfo.codecType;
        try {
            Constructor<? extends DsonCodec> constructor = genericCodecTypeDefine.getConstructor(TypeInfo.class, Supplier.class);
            DsonCodec codec = constructor.newInstance(type, genericCodecInfo.factory);
            return new DsonCodecImpl(codec);
        }
        catch (NoSuchMethodException constructor) {
        }
        catch (ReflectiveOperationException ex) {
            logger.warn("create instance caught exception, type: " + String.valueOf(type), (Throwable)ex);
            return null;
        }
        try {
            Constructor<? extends DsonCodec> constructor = genericCodecTypeDefine.getConstructor(TypeInfo.class);
            DsonCodec codec = constructor.newInstance(type);
            return new DsonCodecImpl(codec);
        }
        catch (NoSuchMethodException constructor) {
        }
        catch (ReflectiveOperationException ex) {
            logger.warn("create instance caught exception, type: " + String.valueOf(type), (Throwable)ex);
            return null;
        }
        throw new DsonCodecException("bad generic codec: " + String.valueOf(genericCodecTypeDefine));
    }

    private TypeInfo castEncoderType(TypeInfo type) {
        Class<?> rawType = type.rawType;
        for (int i = this.casters.size() - 1; i >= 0; --i) {
            DsonCodecCaster caster = this.casters.get(i);
            TypeInfo superType = caster.castEncoderType(type);
            if (superType == null) continue;
            return superType.rawType == rawType ? null : superType;
        }
        if (List.class.isAssignableFrom(rawType)) {
            return TypeInfo.of(List.class, type.genericArgs);
        }
        if (Set.class.isAssignableFrom(rawType)) {
            return TypeInfo.of(Set.class, type.genericArgs);
        }
        if (Collection.class.isAssignableFrom(rawType)) {
            return TypeInfo.of(Collection.class, type.genericArgs);
        }
        if (Map.class.isAssignableFrom(rawType)) {
            return TypeInfo.of(Map.class, type.genericArgs);
        }
        return null;
    }

    private TypeInfo castDecoderType(TypeInfo type) {
        for (int i = this.casters.size() - 1; i >= 0; --i) {
            DsonCodecCaster caster = this.casters.get(i);
            TypeInfo subType = caster.castDecoderType(type);
            if (subType == null) continue;
            return subType.rawType == type.rawType ? null : subType;
        }
        return null;
    }
}

