/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.base.CollectionUtils;
import cn.wjybxx.dsoncodec.ClassPair;
import cn.wjybxx.dsoncodec.TypeInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class TypeWriteHelper {
    private final ConcurrentMap<ClassPair, Boolean> cacheDic = new ConcurrentHashMap<ClassPair, Boolean>(100);

    public TypeWriteHelper(Map<ClassPair, Boolean> configs) {
        this.cacheDic.putAll(configs);
    }

    public boolean isOptimizable(TypeInfo encoderType, TypeInfo declaredType) {
        if (encoderType.equals(declaredType)) {
            return true;
        }
        if (declaredType.rawType == Object.class) {
            return false;
        }
        if (encoderType.hasGenericArgs()) {
            if (!declaredType.hasGenericArgs()) {
                return false;
            }
            ClassPair key = new ClassPair(encoderType.rawType, declaredType.rawType);
            Boolean r = (Boolean)this.cacheDic.get(key);
            if (r != null) {
                return r != false && CollectionUtils.sequenceEqual(declaredType.genericArgs, encoderType.genericArgs);
            }
            return false;
        }
        if (declaredType.hasGenericArgs()) {
            return false;
        }
        ClassPair key = new ClassPair(encoderType.rawType, declaredType.rawType);
        Boolean r = (Boolean)this.cacheDic.get(key);
        return r != null && r != false;
    }
}

