/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.codecs;

import cn.wjybxx.dson.DsonType;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public final class ArrayCodec<T>
implements DsonCodec<T[]> {
    private final TypeInfo encoderType;
    private final TypeInfo elementTypeInfo;

    public ArrayCodec(TypeInfo encoderType) {
        assert (encoderType.isArrayType());
        this.encoderType = encoderType;
        this.elementTypeInfo = encoderType.getComponentType();
    }

    @Override
    @Nonnull
    public TypeInfo getEncoderType() {
        return this.encoderType;
    }

    @Override
    public boolean isWriteAsArray() {
        return true;
    }

    @Override
    public void writeObject(DsonObjectWriter writer, T[] inst, TypeInfo declaredType, ObjectStyle style) {
        TypeInfo elementTypeInfo = this.elementTypeInfo;
        for (int i = 0; i < inst.length; ++i) {
            writer.writeObject(null, inst[i], elementTypeInfo);
        }
    }

    @Override
    public T[] readObject(DsonObjectReader reader, Supplier<? extends T[]> factory) {
        TypeInfo elementTypeInfo = this.elementTypeInfo;
        ArrayList result = new ArrayList();
        while (reader.readDsonType() != DsonType.END_OF_OBJECT) {
            Object value = reader.readObject(null, elementTypeInfo, null);
            result.add(value);
        }
        Object[] array = (Object[])Array.newInstance(elementTypeInfo.rawType, result.size());
        result.toArray(array);
        return array;
    }
}

