/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.codecs;

import cn.wjybxx.base.CollectionUtils;
import cn.wjybxx.dson.DsonType;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonConverterUtils;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.annotations.DsonCodecScanIgnore;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@DsonCodecScanIgnore
public class CollectionCodec<E>
implements DsonCodec<Collection<E>> {
    protected final TypeInfo encoderType;
    protected final Supplier<? extends Collection<E>> factory;
    private final FactoryKind factoryKind;

    public CollectionCodec(TypeInfo encoderType) {
        this(encoderType, null);
    }

    public CollectionCodec(TypeInfo encoderType, Supplier<? extends Collection<E>> factory) {
        if (encoderType.genericArgs.size() != 1) {
            throw new IllegalArgumentException("encoderType.genericArgs.size() != 1");
        }
        if (factory == null) {
            factory = DsonConverterUtils.tryNoArgConstructorToSupplier(encoderType.rawType);
        }
        this.encoderType = encoderType;
        this.factory = factory;
        this.factoryKind = factory == null ? CollectionCodec.computeFactoryKind(encoderType) : FactoryKind.Unknown;
    }

    private static FactoryKind computeFactoryKind(TypeInfo typeInfo) {
        Class<?> clazz = typeInfo.rawType;
        if (clazz == EnumSet.class && typeInfo.genericArgs.get(0).isEnum()) {
            return FactoryKind.EnumSet;
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return FactoryKind.LinkedHashSet;
        }
        if (Deque.class.isAssignableFrom(clazz)) {
            return FactoryKind.ArrayDeque;
        }
        return FactoryKind.Unknown;
    }

    @Override
    @Nonnull
    public TypeInfo getEncoderType() {
        return this.encoderType;
    }

    protected Collection<E> newCollection() {
        if (this.factory != null) {
            return this.factory.get();
        }
        return switch (this.factoryKind.ordinal()) {
            case 1 -> {
                TypeInfo elementTypeInfo = this.encoderType.genericArgs.get(0);
                yield EnumSet.noneOf(elementTypeInfo.rawType);
            }
            case 2 -> new LinkedHashSet();
            case 3 -> new ArrayDeque();
            default -> new ArrayList();
        };
    }

    protected Collection<E> toImmutable(Collection<E> result) {
        if (result instanceof LinkedHashSet) {
            LinkedHashSet linkedHashSet = (LinkedHashSet)result;
            return Collections.unmodifiableSet(linkedHashSet);
        }
        if (result instanceof EnumSet) {
            Set enumSet = (Set)result;
            return Collections.unmodifiableSet(enumSet);
        }
        if (result instanceof Set) {
            Set set = (Set)result;
            return CollectionUtils.toImmutableLinkedHashSet((Collection)set);
        }
        return List.copyOf(result);
    }

    @Override
    public void writeObject(DsonObjectWriter writer, Collection<E> inst, TypeInfo declaredType, ObjectStyle style) {
        TypeInfo elementTypeInfo = this.encoderType.genericArgs.get(0);
        for (E e : inst) {
            writer.writeObject(null, e, elementTypeInfo, null);
        }
    }

    @Override
    public Collection<E> readObject(DsonObjectReader reader, Supplier<? extends Collection<E>> factory) {
        Collection result;
        TypeInfo elementTypeInfo = this.encoderType.genericArgs.get(0);
        Collection<Object> collection = result = factory != null ? factory.get() : this.newCollection();
        while (reader.readDsonType() != DsonType.END_OF_OBJECT) {
            result.add(reader.readObject(null, elementTypeInfo));
        }
        return reader.options().readAsImmutable ? this.toImmutable(result) : result;
    }

    private static enum FactoryKind {
        Unknown,
        EnumSet,
        LinkedHashSet,
        ArrayDeque;

    }
}

