/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.codecs;

import cn.wjybxx.base.tuple.Tuple2;
import cn.wjybxx.dson.DsonType;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonCodecException;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.MapEncodeProxy;
import cn.wjybxx.dsoncodec.TypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class MapEncodeProxyCodec<V>
implements DsonCodec<MapEncodeProxy<V>> {
    private final TypeInfo encoderType;

    public MapEncodeProxyCodec() {
        this.encoderType = TypeInfo.of(MapEncodeProxy.class, TypeInfo.OBJECT);
    }

    public MapEncodeProxyCodec(TypeInfo encoderType) {
        this.encoderType = encoderType;
    }

    @Override
    @Nonnull
    public TypeInfo getEncoderType() {
        return this.encoderType;
    }

    @Override
    public boolean autoStartEnd() {
        return false;
    }

    @Override
    public void writeObject(DsonObjectWriter writer, MapEncodeProxy<V> inst, TypeInfo declaredType, ObjectStyle style) {
        TypeInfo valueTypeInfo = this.encoderType.genericArgs.get(0);
        Collection<Map.Entry<String, V>> entries = Objects.requireNonNull(inst.getEntries());
        switch (inst.getMode()) {
            default: {
                writer.writeStartObject(style, this.encoderType, declaredType);
                for (Map.Entry<String, V> entry : entries) {
                    writer.writeName(entry.getKey());
                    writer.writeObject(entry.getKey(), entry.getValue(), valueTypeInfo, null);
                }
                writer.writeEndObject();
                break;
            }
            case 1: {
                writer.writeStartArray(style, this.encoderType, declaredType);
                for (Map.Entry<String, V> entry : entries) {
                    writer.writeString(null, entry.getKey());
                    writer.writeObject(null, entry.getValue(), valueTypeInfo, null);
                }
                writer.writeEndArray();
                break;
            }
            case 2: {
                writer.writeStartArray(style, this.encoderType, declaredType);
                for (Map.Entry<String, V> entry : entries) {
                    writer.writeStartArray(ObjectStyle.FLOW);
                    writer.writeString(null, entry.getKey());
                    writer.writeObject(null, entry.getValue(), valueTypeInfo, null);
                    writer.writeEndArray();
                }
                writer.writeEndArray();
                break;
            }
            case 3: {
                writer.writeStartArray(style, this.encoderType, declaredType);
                for (Map.Entry<String, V> entry : entries) {
                    writer.writeStartObject(ObjectStyle.FLOW);
                    writer.writeName(entry.getKey());
                    writer.writeObject(entry.getKey(), entry.getValue(), valueTypeInfo);
                    writer.writeEndObject();
                }
                writer.writeEndArray();
            }
        }
    }

    @Override
    public MapEncodeProxy<V> readObject(DsonObjectReader reader, Supplier<? extends MapEncodeProxy<V>> factory) {
        TypeInfo valueTypeInfo = this.encoderType.genericArgs.get(0);
        ArrayList entries = new ArrayList();
        MapEncodeProxy result = new MapEncodeProxy();
        result.setEntries(entries);
        DsonType currentDsonType = reader.getCurrentDsonType();
        if (currentDsonType == DsonType.OBJECT) {
            result.setWriteAsDocument();
            reader.readStartObject();
            while (reader.readDsonType() != DsonType.END_OF_OBJECT) {
                String key = reader.readName();
                Object value = reader.readObject(key, valueTypeInfo);
                entries.add(Tuple2.of((Object)key, value));
            }
            reader.readEndObject();
        } else {
            assert (currentDsonType == DsonType.ARRAY);
            reader.readStartArray();
            DsonType firstDsonType = reader.readDsonType();
            switch (firstDsonType) {
                case STRING: {
                    result.setWriteAsArray();
                    do {
                        String key = reader.readString(null);
                        Object value = reader.readObject(null, valueTypeInfo);
                        entries.add(Tuple2.of((Object)key, value));
                    } while (reader.readDsonType() != DsonType.END_OF_OBJECT);
                    break;
                }
                case ARRAY: {
                    result.setWritePairAsArray();
                    do {
                        reader.readStartArray();
                        String key = reader.readString(null);
                        Object value = reader.readObject(null, valueTypeInfo);
                        entries.add(Tuple2.of((Object)key, value));
                        reader.readEndArray();
                    } while (reader.readDsonType() != DsonType.END_OF_OBJECT);
                    break;
                }
                case OBJECT: {
                    result.setWritePairAsDocument();
                    do {
                        reader.readStartObject();
                        String key = reader.readName();
                        Object value = reader.readObject(key, valueTypeInfo);
                        entries.add(Tuple2.of((Object)key, value));
                        reader.readEndObject();
                    } while (reader.readDsonType() != DsonType.END_OF_OBJECT);
                    break;
                }
                case END_OF_OBJECT: {
                    break;
                }
                default: {
                    throw new DsonCodecException("unexpected dsonType: " + String.valueOf(firstDsonType));
                }
            }
            reader.readEndArray();
        }
        return result;
    }
}

