/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.codecs;

import cn.wjybxx.dson.WireType;
import cn.wjybxx.dson.text.INumberStyle;
import cn.wjybxx.dson.text.NumberStyle;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public final class MorePrimitiveCodecs {

    public static class CharacterCodec
    implements DsonCodec<Character> {
        @Override
        @Nonnull
        public TypeInfo getEncoderType() {
            return TypeInfo.BOXED_CHAR;
        }

        @Override
        public boolean autoStartEnd() {
            return false;
        }

        @Override
        public void writeObject(DsonObjectWriter writer, Character inst, TypeInfo declaredType, ObjectStyle style) {
            NumberStyle numberStyle = declaredType.rawType == Character.class || declaredType.rawType == Character.TYPE ? NumberStyle.SIMPLE : NumberStyle.TYPED;
            writer.writeInt(null, inst.charValue(), WireType.UINT, (INumberStyle)numberStyle);
        }

        @Override
        public Character readObject(DsonObjectReader reader, Supplier<? extends Character> factory) {
            return Character.valueOf((char)reader.readInt(null));
        }
    }

    public static class ByteCodec
    implements DsonCodec<Byte> {
        @Override
        @Nonnull
        public TypeInfo getEncoderType() {
            return TypeInfo.BOXED_BYTE;
        }

        @Override
        public boolean autoStartEnd() {
            return false;
        }

        @Override
        public void writeObject(DsonObjectWriter writer, Byte inst, TypeInfo declaredType, ObjectStyle style) {
            NumberStyle numberStyle = declaredType.rawType == Byte.class || declaredType.rawType == Byte.TYPE ? NumberStyle.SIMPLE : NumberStyle.TYPED;
            writer.writeInt(null, inst.byteValue(), WireType.SINT, (INumberStyle)numberStyle);
        }

        @Override
        public Byte readObject(DsonObjectReader reader, Supplier<? extends Byte> factory) {
            return (byte)reader.readInt(null);
        }
    }

    public static class ShortCodec
    implements DsonCodec<Short> {
        @Override
        @Nonnull
        public TypeInfo getEncoderType() {
            return TypeInfo.BOXED_SHORT;
        }

        @Override
        public boolean autoStartEnd() {
            return false;
        }

        @Override
        public void writeObject(DsonObjectWriter writer, Short inst, TypeInfo declaredType, ObjectStyle style) {
            NumberStyle numberStyle = declaredType.rawType == Short.class || declaredType.rawType == Short.TYPE ? NumberStyle.SIMPLE : NumberStyle.TYPED;
            writer.writeInt(null, inst.shortValue(), WireType.SINT, (INumberStyle)numberStyle);
        }

        @Override
        public Short readObject(DsonObjectReader reader, Supplier<? extends Short> factory) {
            return (short)reader.readInt(null);
        }
    }
}

