/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.fastutil;

import cn.wjybxx.dson.DsonType;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonConverterUtils;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class Int2ObjectMapCodec<V>
implements DsonCodec<Int2ObjectMap<V>> {
    protected final TypeInfo encoderType;
    protected final Supplier<? extends Int2ObjectMap<V>> factory;

    public Int2ObjectMapCodec(TypeInfo encoderType) {
        this(encoderType, null);
    }

    public Int2ObjectMapCodec(TypeInfo encoderType, Supplier<? extends Int2ObjectMap<V>> factory) {
        if (factory == null) {
            factory = DsonConverterUtils.tryNoArgConstructorToSupplier(encoderType.rawType);
        }
        this.encoderType = encoderType;
        this.factory = factory;
    }

    @Override
    public boolean autoStartEnd() {
        return false;
    }

    @Override
    @Nonnull
    public TypeInfo getEncoderType() {
        return this.encoderType;
    }

    protected Int2ObjectMap<V> newMap() {
        if (this.factory != null) {
            return this.factory.get();
        }
        return new Int2ObjectLinkedOpenHashMap();
    }

    @Override
    public void writeObject(DsonObjectWriter writer, Int2ObjectMap<V> inst, TypeInfo declaredType, ObjectStyle style) {
        TypeInfo valueTypeInfo = this.encoderType.genericArgs.get(0);
        if (writer.options().writeMapAsDocument) {
            writer.writeStartObject(style, this.encoderType, declaredType);
            ObjectIterator itr = Int2ObjectMaps.fastIterator(inst);
            while (itr.hasNext()) {
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)itr.next();
                String keyString = Integer.toString(entry.getIntKey());
                Object value = entry.getValue();
                if (value == null) {
                    writer.writeName(keyString);
                    writer.writeNull(keyString);
                    continue;
                }
                writer.writeObject(keyString, value, valueTypeInfo, null);
            }
            writer.writeEndObject();
        } else {
            writer.writeStartArray(style, this.encoderType, declaredType);
            ObjectIterator itr = Int2ObjectMaps.fastIterator(inst);
            while (itr.hasNext()) {
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)itr.next();
                writer.writeInt(null, entry.getIntKey(), null);
                writer.writeObject(null, entry.getValue(), valueTypeInfo, null);
            }
            writer.writeEndArray();
        }
    }

    @Override
    public Int2ObjectMap<V> readObject(DsonObjectReader reader, Supplier<? extends Int2ObjectMap<V>> factory) {
        Int2ObjectMap result;
        TypeInfo valueTypeInfo = this.encoderType.genericArgs.get(0);
        Object object = result = factory != null ? factory.get() : this.newMap();
        if (reader.options().writeMapAsDocument) {
            reader.readStartObject();
            while (reader.readDsonType() != DsonType.END_OF_OBJECT) {
                String keyString = reader.readName();
                int key = Integer.parseInt(keyString);
                Object value = reader.readObject(keyString, valueTypeInfo);
                result.put(key, value);
            }
            reader.readEndObject();
        } else {
            reader.readStartArray();
            while (reader.readDsonType() != DsonType.END_OF_OBJECT) {
                int key = reader.readInt(null);
                Object value = reader.readObject(null, valueTypeInfo);
                result.put(key, value);
            }
            reader.readEndArray();
        }
        return reader.options().readAsImmutable ? Int2ObjectMaps.unmodifiable(result) : result;
    }
}

