/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.fastutil;

import cn.wjybxx.dson.DsonType;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonConverterUtils;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntImmutableList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class IntCollectionCodec
implements DsonCodec<IntCollection> {
    protected final TypeInfo typeInfo;
    protected final Supplier<? extends IntCollection> factory;
    private final boolean isSet;

    public IntCollectionCodec(TypeInfo typeInfo, Supplier<? extends IntCollection> factory) {
        if (factory == null) {
            factory = DsonConverterUtils.tryNoArgConstructorToSupplier(typeInfo.rawType);
        }
        this.typeInfo = Objects.requireNonNull(typeInfo);
        this.factory = factory;
        this.isSet = IntSet.class.isAssignableFrom(typeInfo.rawType);
    }

    @Override
    @Nonnull
    public TypeInfo getEncoderType() {
        return this.typeInfo;
    }

    protected IntCollection newCollection() {
        if (this.factory != null) {
            return this.factory.get();
        }
        return this.isSet ? new IntLinkedOpenHashSet() : new IntArrayList();
    }

    private static IntCollection toImmutable(IntCollection result) {
        if (result instanceof IntSet) {
            IntSet intSet = (IntSet)result;
            return IntSets.unmodifiable((IntSet)intSet);
        }
        return new IntImmutableList(result);
    }

    @Override
    public void writeObject(DsonObjectWriter writer, IntCollection inst, TypeInfo declaredType, ObjectStyle style) {
        IntIterator itr = inst.iterator();
        while (itr.hasNext()) {
            writer.writeInt(null, itr.nextInt());
        }
    }

    @Override
    public IntCollection readObject(DsonObjectReader reader, Supplier<? extends IntCollection> factory) {
        IntCollection result;
        IntCollection intCollection = result = factory != null ? factory.get() : this.newCollection();
        while (reader.readDsonType() != DsonType.END_OF_OBJECT) {
            result.add(reader.readInt(null));
        }
        return reader.options().readAsImmutable ? IntCollectionCodec.toImmutable(result) : result;
    }
}

