/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.dson.DsonReader;
import cn.wjybxx.dson.DsonType;
import cn.wjybxx.dsoncodec.AbstractObjectReader;
import cn.wjybxx.dsoncodec.DsonConverter;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.TypeInfo;
import java.util.Objects;

final class DefaultDsonObjectReader
extends AbstractObjectReader
implements DsonObjectReader {
    public DefaultDsonObjectReader(DsonConverter converter, DsonReader reader) {
        super(converter, reader);
    }

    @Override
    public boolean readName(String name) {
        DsonReader reader = this.reader;
        if (reader.getContextType().isArrayLike()) {
            if (reader.isAtValue()) {
                return true;
            }
            if (reader.isAtType()) {
                return reader.readDsonType() != DsonType.END_OF_OBJECT;
            }
            return reader.getCurrentDsonType() != DsonType.END_OF_OBJECT;
        }
        if (reader.isAtValue()) {
            return name == null || reader.getCurrentName().equals(name);
        }
        Objects.requireNonNull(name, "name");
        if (reader.isAtType() ? reader.readDsonType() == DsonType.END_OF_OBJECT : reader.getCurrentDsonType() == DsonType.END_OF_OBJECT) {
            return false;
        }
        reader.readName(name);
        return true;
    }

    @Override
    public void setEncoderType(TypeInfo encoderType) {
        this.reader.attach((Object)encoderType);
    }

    @Override
    public TypeInfo getEncoderType() {
        return (TypeInfo)this.reader.attachment();
    }
}

