/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.dson.DsonType;
import cn.wjybxx.dson.DsonValue;
import cn.wjybxx.dson.DsonWriter;
import cn.wjybxx.dson.Dsons;
import cn.wjybxx.dson.text.INumberStyle;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dson.text.StringStyle;
import cn.wjybxx.dson.types.Binary;
import cn.wjybxx.dson.types.ExtDateTime;
import cn.wjybxx.dson.types.ObjectLitePtr;
import cn.wjybxx.dson.types.ObjectPtr;
import cn.wjybxx.dson.types.Timestamp;
import cn.wjybxx.dsoncodec.ConverterOptions;
import cn.wjybxx.dsoncodec.DsonCodecException;
import cn.wjybxx.dsoncodec.DsonCodecImpl;
import cn.wjybxx.dsoncodec.DsonConverter;
import cn.wjybxx.dsoncodec.DsonConverterUtils;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.TypeMeta;
import cn.wjybxx.dsoncodec.TypeWriteHelper;
import cn.wjybxx.dsoncodec.TypeWritePolicy;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

final class DefaultDsonObjectWriter
implements DsonObjectWriter {
    private final DsonConverter converter;
    private final TypeWriteHelper typeWriteHelper;
    private final DsonWriter writer;

    public DefaultDsonObjectWriter(DsonConverter converter, TypeWriteHelper typeWriteHelper, DsonWriter writer) {
        this.converter = converter;
        this.typeWriteHelper = typeWriteHelper;
        this.writer = writer;
    }

    @Override
    public void writeInt(String name, int value, INumberStyle style) {
        if (value != 0 || !this.writer.isAtName() || this.converter.options().appendDef) {
            this.writer.writeInt32(name, value, style);
        }
    }

    @Override
    public void writeLong(String name, long value, INumberStyle style) {
        if (value != 0L || !this.writer.isAtName() || this.converter.options().appendDef) {
            this.writer.writeInt64(name, value, style);
        }
    }

    @Override
    public void writeFloat(String name, float value, INumberStyle style) {
        if (value != 0.0f || !this.writer.isAtName() || this.converter.options().appendDef) {
            this.writer.writeFloat(name, value, style);
        }
    }

    @Override
    public void writeDouble(String name, double value, INumberStyle style) {
        if (value != 0.0 || !this.writer.isAtName() || this.converter.options().appendDef) {
            this.writer.writeDouble(name, value, style);
        }
    }

    @Override
    public void writeBoolean(String name, boolean value) {
        if (value || !this.writer.isAtName() || this.converter.options().appendDef) {
            this.writer.writeBool(name, value);
        }
    }

    @Override
    public void writeString(String name, @Nullable String value, StringStyle style) {
        if (value == null) {
            this.writeNull(name);
        } else {
            this.writer.writeString(name, value, style);
        }
    }

    @Override
    public void writeNull(String name) {
        if (!this.writer.isAtName() || this.converter.options().appendNull) {
            this.writer.writeNull(name);
        }
    }

    @Override
    public void writeBytes(String name, byte[] value) {
        if (value == null) {
            this.writeNull(name);
        } else {
            this.writer.writeBinary(name, value, 0, value.length);
        }
    }

    @Override
    public void writeBytes(String name, byte[] value, int offset, int len) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.writer.writeBinary(name, value, offset, len);
    }

    @Override
    public void writeBinary(String name, Binary binary) {
        if (binary == null) {
            this.writeNull(name);
        } else {
            this.writer.writeBinary(name, binary);
        }
    }

    @Override
    public void writePtr(String name, ObjectPtr objectPtr) {
        if (objectPtr == null) {
            this.writeNull(name);
        } else {
            this.writer.writePtr(name, objectPtr);
        }
    }

    @Override
    public void writeLitePtr(String name, ObjectLitePtr objectLitePtr) {
        if (objectLitePtr == null) {
            this.writeNull(name);
        } else {
            this.writer.writeLitePtr(name, objectLitePtr);
        }
    }

    @Override
    public void writeDateTime(String name, LocalDateTime dateTime) {
        if (dateTime == null) {
            this.writeNull(name);
        } else {
            this.writer.writeDateTime(name, ExtDateTime.ofDateTime((LocalDateTime)dateTime));
        }
    }

    @Override
    public void writeExtDateTime(String name, ExtDateTime dateTime) {
        if (dateTime == null) {
            this.writeNull(name);
        } else {
            this.writer.writeDateTime(name, dateTime);
        }
    }

    @Override
    public void writeTimestamp(String name, Timestamp timestamp) {
        if (timestamp == null) {
            this.writeNull(name);
        } else {
            this.writer.writeTimestamp(name, timestamp);
        }
    }

    @Override
    public <T> void writeObject(String name, T value, TypeInfo declaredType, ObjectStyle style) {
        Objects.requireNonNull(declaredType, "typeInfo");
        if (value == null) {
            this.writeNull(name);
            return;
        }
        TypeInfo runtimeTypeInfo = this.getRuntimeTypeInfo(value, declaredType);
        DsonCodecImpl<?> codec = this.converter.codecRegistry().getEncoder(runtimeTypeInfo);
        if (codec != null) {
            if (this.writer.isAtName()) {
                this.writer.writeName(name);
            }
            if (style == null) {
                style = this.findObjectStyle(codec.getEncoderType());
            }
            codec.writeObject(this, value, declaredType, style);
            return;
        }
        Class<?> type = value.getClass();
        if (value instanceof DsonValue) {
            DsonValue dsonValue = (DsonValue)value;
            Dsons.writeDsonValue((DsonWriter)this.writer, (DsonValue)dsonValue, (String)name);
            return;
        }
        throw DsonCodecException.unsupportedType(type);
    }

    @Override
    public ConverterOptions options() {
        return this.converter.options();
    }

    @Override
    public String getCurrentName() {
        return this.writer.getCurrentName();
    }

    @Override
    public void writeName(String name) {
        this.writer.writeName(name);
    }

    @Override
    public void writeTypeInfo(TypeInfo encoderType, TypeInfo declaredType) {
        this.writer.attach((Object)encoderType);
        TypeWritePolicy policy = this.converter.options().typeWritePolicy;
        if (policy == TypeWritePolicy.OPTIMIZED && !this.typeWriteHelper.isOptimizable(encoderType, declaredType) || policy == TypeWritePolicy.ALWAYS) {
            TypeMeta typeMeta = this.converter.typeMetaRegistry().ofType(encoderType);
            if (typeMeta == null) {
                throw new DsonCodecException("typeMeta of encoderType: %s is absent".formatted(encoderType));
            }
            this.writer.writeSimpleHeader(typeMeta.mainClsName());
        }
    }

    @Override
    public void writeStartObject(ObjectStyle style) {
        this.writer.writeStartObject(style);
    }

    @Override
    public void writeEndObject() {
        this.writer.writeEndObject();
    }

    @Override
    public void writeStartArray(ObjectStyle style) {
        this.writer.writeStartArray(style);
    }

    @Override
    public void writeEndArray() {
        this.writer.writeEndArray();
    }

    @Override
    public void writeValueBytes(String name, DsonType dsonType, byte[] data) {
        Objects.requireNonNull(data);
        this.writer.writeValueBytes(name, dsonType, data);
    }

    @Override
    public <T> String encodeKey(T key, TypeInfo keyType) {
        Objects.requireNonNull(key);
        if (key instanceof String) {
            String str = (String)key;
            return str;
        }
        if (key instanceof Integer || key instanceof Long) {
            return key.toString();
        }
        DsonCodecImpl<?> codecImpl = this.converter.codecRegistry().getEncoder(keyType);
        if (codecImpl == null || !codecImpl.isEnumCodec()) {
            throw DsonCodecException.unsupportedType(key.getClass());
        }
        if (this.converter.options().writeEnumAsString) {
            return codecImpl.getName(key);
        }
        return Integer.toString(codecImpl.getNumber(key));
    }

    @Override
    public void setEncoderType(TypeInfo encoderType) {
        this.writer.attach((Object)encoderType);
    }

    @Override
    public TypeInfo getEncoderType() {
        return (TypeInfo)this.writer.attachment();
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    public void close() {
        this.writer.close();
    }

    private ObjectStyle findObjectStyle(TypeInfo encoderType) {
        TypeMeta typeMeta = this.converter.typeMetaRegistry().ofType(encoderType);
        return typeMeta != null ? typeMeta.style : ObjectStyle.INDENT;
    }

    private TypeInfo getRuntimeTypeInfo(Object value, TypeInfo declaredType) {
        Class<?> encoderClass = DsonConverterUtils.getEncodeClass(value);
        if (encoderClass == declaredType.rawType) {
            return declaredType;
        }
        if (declaredType.hasTypeArgs()) {
            TypeInfo typeInfo = this.converter.genericCodecHelper().inheritTypeArgs(encoderClass, declaredType);
            return typeInfo == null ? TypeInfo.of(encoderClass) : typeInfo;
        }
        return TypeInfo.of(encoderClass);
    }

    @Override
    public void writeStartObject(ObjectStyle style, TypeInfo encoderType, TypeInfo declaredType) {
        this.writer.writeStartObject(style);
        this.writeTypeInfo(encoderType, declaredType);
    }

    @Override
    public void writeStartObject(String name, ObjectStyle style) {
        this.writer.writeName(name);
        this.writer.writeStartObject(style);
    }

    @Override
    public void writeStartObject(String name, ObjectStyle style, TypeInfo encoderType, TypeInfo declaredType) {
        this.writer.writeName(name);
        this.writer.writeStartObject(style);
        this.writeTypeInfo(encoderType, declaredType);
    }

    @Override
    public void writeStartArray(ObjectStyle style, TypeInfo encoderType, TypeInfo declaredType) {
        this.writer.writeStartArray(style);
        this.writeTypeInfo(encoderType, declaredType);
    }

    @Override
    public void writeStartArray(String name, ObjectStyle style) {
        this.writer.writeName(name);
        this.writer.writeStartArray(style);
    }

    @Override
    public void writeStartArray(String name, ObjectStyle style, TypeInfo encoderType, TypeInfo declaredType) {
        this.writer.writeName(name);
        this.writer.writeStartArray(style);
        this.writeTypeInfo(encoderType, declaredType);
    }
}

