/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.dson.DsonContextType;
import cn.wjybxx.dson.DsonType;
import cn.wjybxx.dson.types.Binary;
import cn.wjybxx.dson.types.ExtDateTime;
import cn.wjybxx.dson.types.ObjectLitePtr;
import cn.wjybxx.dson.types.ObjectPtr;
import cn.wjybxx.dson.types.Timestamp;
import cn.wjybxx.dsoncodec.ConverterOptions;
import cn.wjybxx.dsoncodec.TypeInfo;
import java.time.LocalDateTime;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public interface DsonObjectReader
extends AutoCloseable {
    public int readInt(String var1);

    public long readLong(String var1);

    public float readFloat(String var1);

    public double readDouble(String var1);

    public boolean readBoolean(String var1);

    public String readString(String var1);

    public void readNull(String var1);

    default public byte[] readBytes(String name) {
        Binary binary = this.readBinary(name);
        return binary == null ? null : binary.unsafeBuffer();
    }

    public Binary readBinary(String var1);

    public ObjectPtr readPtr(String var1);

    public ObjectLitePtr readLitePtr(String var1);

    public LocalDateTime readDateTime(String var1);

    public ExtDateTime readExtDateTime(String var1);

    public Timestamp readTimestamp(String var1);

    @Nullable
    public <T> T readObject(String var1, TypeInfo var2, Supplier<? extends T> var3);

    default public <T> T readObject(String name, TypeInfo declaredType) {
        return this.readObject(name, declaredType, null);
    }

    public ConverterOptions options();

    public DsonContextType getContextType();

    public DsonType readDsonType();

    public String readName();

    public boolean readName(String var1);

    public DsonType getCurrentDsonType();

    public String getCurrentName();

    public void readStartObject();

    public void readEndObject();

    public void readStartArray();

    public void readEndArray();

    public void skipName();

    public void skipValue();

    public void skipToEndOfObject();

    public byte[] readValueAsBytes(String var1);

    public <T> T decodeKey(String var1, TypeInfo var2);

    public void setComponentType(DsonType var1);

    public void setEncoderType(TypeInfo var1);

    public TypeInfo getEncoderType();

    @Override
    public void close();

    default public boolean readStartObject(String name) {
        if (this.readName(name)) {
            this.readStartObject();
            return true;
        }
        return false;
    }

    default public boolean readStartArray(String name) {
        if (this.readName(name)) {
            this.readStartArray();
            return true;
        }
        return false;
    }

    default public short readShort(String name) {
        return (short)this.readInt(name);
    }

    default public byte readByte(String name) {
        return (byte)this.readInt(name);
    }

    default public char readChar(String name) {
        return (char)this.readInt(name);
    }
}

