/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.dson.DsonType;
import cn.wjybxx.dson.text.INumberStyle;
import cn.wjybxx.dson.text.NumberStyle;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dson.text.StringStyle;
import cn.wjybxx.dson.types.Binary;
import cn.wjybxx.dson.types.ExtDateTime;
import cn.wjybxx.dson.types.ObjectLitePtr;
import cn.wjybxx.dson.types.ObjectPtr;
import cn.wjybxx.dson.types.Timestamp;
import cn.wjybxx.dsoncodec.ConverterOptions;
import cn.wjybxx.dsoncodec.TypeInfo;
import java.time.LocalDateTime;
import javax.annotation.Nullable;

public interface DsonObjectWriter
extends AutoCloseable {
    public void writeInt(String var1, int var2, INumberStyle var3);

    public void writeLong(String var1, long var2, INumberStyle var4);

    public void writeFloat(String var1, float var2, INumberStyle var3);

    public void writeDouble(String var1, double var2, INumberStyle var4);

    public void writeBoolean(String var1, boolean var2);

    public void writeString(String var1, String var2, StringStyle var3);

    public void writeNull(String var1);

    public void writeBytes(String var1, byte[] var2);

    public void writeBytes(String var1, byte[] var2, int var3, int var4);

    public void writeBinary(String var1, Binary var2);

    public void writePtr(String var1, ObjectPtr var2);

    public void writeLitePtr(String var1, ObjectLitePtr var2);

    public void writeDateTime(String var1, LocalDateTime var2);

    public void writeExtDateTime(String var1, ExtDateTime var2);

    public void writeTimestamp(String var1, Timestamp var2);

    public <T> void writeObject(String var1, T var2, TypeInfo var3, @Nullable ObjectStyle var4);

    default public <T> void writeObject(String name, T value) {
        this.writeObject(name, value, TypeInfo.OBJECT, null);
    }

    default public <T> void writeObject(String name, T value, TypeInfo declaredType) {
        this.writeObject(name, value, declaredType, null);
    }

    public ConverterOptions options();

    public String getCurrentName();

    public void writeName(String var1);

    public void writeTypeInfo(TypeInfo var1, TypeInfo var2);

    public void writeStartObject(ObjectStyle var1);

    public void writeEndObject();

    public void writeStartArray(ObjectStyle var1);

    public void writeEndArray();

    public void writeValueBytes(String var1, DsonType var2, byte[] var3);

    public <T> String encodeKey(T var1, TypeInfo var2);

    public void setEncoderType(TypeInfo var1);

    public TypeInfo getEncoderType();

    public void flush();

    @Override
    public void close();

    default public void writeStartObject(ObjectStyle style, TypeInfo encoderType, TypeInfo declaredType) {
        this.writeStartObject(style);
        this.writeTypeInfo(encoderType, declaredType);
    }

    default public void writeStartObject(String name, ObjectStyle style) {
        this.writeName(name);
        this.writeStartObject(style);
    }

    default public void writeStartObject(String name, ObjectStyle style, TypeInfo encoderType, TypeInfo declaredType) {
        this.writeName(name);
        this.writeStartObject(style);
        this.writeTypeInfo(encoderType, declaredType);
    }

    default public void writeStartArray(ObjectStyle style, TypeInfo encoderType, TypeInfo declaredType) {
        this.writeStartArray(style);
        this.writeTypeInfo(encoderType, declaredType);
    }

    default public void writeStartArray(String name, ObjectStyle style) {
        this.writeName(name);
        this.writeStartArray(style);
    }

    default public void writeStartArray(String name, ObjectStyle style, TypeInfo encoderType, TypeInfo declaredType) {
        this.writeName(name);
        this.writeStartArray(style);
        this.writeTypeInfo(encoderType, declaredType);
    }

    default public void writeInt(String name, int value) {
        this.writeInt(name, value, (INumberStyle)NumberStyle.SIMPLE);
    }

    default public void writeLong(String name, long value) {
        this.writeLong(name, value, (INumberStyle)NumberStyle.SIMPLE);
    }

    default public void writeFloat(String name, float value) {
        this.writeFloat(name, value, (INumberStyle)NumberStyle.SIMPLE);
    }

    default public void writeDouble(String name, double value) {
        this.writeDouble(name, value, (INumberStyle)NumberStyle.SIMPLE);
    }

    default public void writeString(String name, String value) {
        this.writeString(name, value, StringStyle.AUTO);
    }

    default public void writeShort(String name, short value) {
        this.writeInt(name, value, (INumberStyle)NumberStyle.SIMPLE);
    }

    default public void writeShort(String name, short value, INumberStyle style) {
        this.writeInt(name, value, style);
    }

    default public void writeByte(String name, byte value) {
        this.writeInt(name, value, (INumberStyle)NumberStyle.SIMPLE);
    }

    default public void writeByte(String name, byte value, INumberStyle style) {
        this.writeInt(name, value, style);
    }

    default public void writeChar(String name, char value) {
        this.writeInt(name, value, (INumberStyle)NumberStyle.SIMPLE);
    }

    default public void writeChar(String name, char value, INumberStyle style) {
        this.writeInt(name, value, style);
    }
}

