/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.base.ArrayUtils;
import cn.wjybxx.base.ObjectUtils;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.ClassName;
import cn.wjybxx.dsoncodec.DsonCodecException;
import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.TypeMeta;
import cn.wjybxx.dsoncodec.TypeMetaConfig;
import cn.wjybxx.dsoncodec.TypeMetaRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public final class DynamicTypeMetaRegistry
implements TypeMetaRegistry {
    private final TypeMetaConfig basicRegistry;
    private final ConcurrentHashMap<String, ClassName> classNamePool = new ConcurrentHashMap(1024);
    private final ConcurrentHashMap<TypeInfo, TypeMeta> type2MetaDic = new ConcurrentHashMap(1024);
    private final ConcurrentHashMap<String, TypeMeta> name2MetaDic = new ConcurrentHashMap(1024);

    public DynamicTypeMetaRegistry(TypeMetaConfig config) {
        this.basicRegistry = config.toImmutable();
    }

    @Override
    @Nullable
    public TypeMeta ofType(TypeInfo type) {
        ObjectStyle style;
        TypeMeta typeMeta = this.basicRegistry.ofType(type);
        if (typeMeta != null) {
            return typeMeta;
        }
        typeMeta = this.type2MetaDic.get(type);
        if (typeMeta != null) {
            return typeMeta;
        }
        if (!type.isGenericType() && !type.isArrayType()) {
            return null;
        }
        if (type.isArrayType()) {
            style = ObjectStyle.INDENT;
        } else {
            TypeMeta rawTypeMeta = this.basicRegistry.ofType(TypeInfo.of(type.rawType));
            if (rawTypeMeta == null) {
                throw new DsonCodecException("typeMeta absent, type: " + String.valueOf(type));
            }
            style = rawTypeMeta.style;
        }
        ClassName className = this.classNameOfType(type);
        String mainClsName = className.toString();
        typeMeta = TypeMeta.of(type, style, mainClsName);
        this.type2MetaDic.putIfAbsent(type, typeMeta);
        this.name2MetaDic.putIfAbsent(mainClsName, typeMeta);
        return typeMeta;
    }

    @Override
    public TypeMeta ofName(String clsName) {
        TypeMeta typeMeta = this.basicRegistry.ofName(clsName);
        if (typeMeta != null) {
            return typeMeta;
        }
        typeMeta = this.name2MetaDic.get(clsName);
        if (typeMeta != null) {
            return typeMeta;
        }
        ClassName className = this.parseName(clsName);
        TypeInfo type = this.typeOfClassName(className);
        typeMeta = this.ofType(type);
        if (typeMeta == null) {
            throw new DsonCodecException("typeMeta absent, type: " + String.valueOf(type));
        }
        if (typeMeta.clsNames.contains(clsName) || ObjectUtils.containsWhitespace((CharSequence)clsName)) {
            return typeMeta;
        }
        ArrayList<String> clsNames = new ArrayList<String>(typeMeta.clsNames.size() + 1);
        clsNames.addAll(typeMeta.clsNames);
        clsNames.add(clsName);
        typeMeta = TypeMeta.of(type, typeMeta.style, clsNames);
        this.type2MetaDic.put(type, typeMeta);
        for (String name : clsNames) {
            this.name2MetaDic.put(name, typeMeta);
        }
        return typeMeta;
    }

    private ClassName parseName(String clsName) {
        Objects.requireNonNull(clsName);
        ClassName className = this.classNamePool.get(clsName);
        if (className != null) {
            return className;
        }
        if (ObjectUtils.containsWhitespace((CharSequence)clsName)) {
            return ClassName.parse(clsName);
        }
        className = ClassName.parse(clsName);
        this.classNamePool.put(clsName, className);
        return className;
    }

    private ClassName classNameOfType(TypeInfo type) {
        if (type.isArrayType()) {
            TypeInfo rootElementType = TypeInfo.of(ArrayUtils.getRootComponentType(type.rawType), type.typeArgs);
            int arrayRank = ArrayUtils.getArrayRank(type.rawType);
            String clsName = String.valueOf(this.classNameOfType(rootElementType)) + ArrayUtils.arrayRankSymbol((int)arrayRank);
            return new ClassName(clsName);
        }
        if (type.isGenericType()) {
            TypeMeta typeMeta = this.basicRegistry.ofType(TypeInfo.of(type.rawType));
            if (typeMeta == null) {
                throw new DsonCodecException("typeMeta absent, type: " + String.valueOf(type));
            }
            List<TypeInfo> genericTypeArgs = type.typeArgs;
            ArrayList<ClassName> typeArgClassNames = new ArrayList<ClassName>(genericTypeArgs.size());
            for (TypeInfo genericTypeArg : genericTypeArgs) {
                typeArgClassNames.add(this.classNameOfType(genericTypeArg));
            }
            return new ClassName(typeMeta.mainClsName(), typeArgClassNames);
        }
        TypeMeta typeMeta = this.basicRegistry.ofType(type);
        if (typeMeta == null) {
            throw new DsonCodecException("typeMeta absent, type: " + String.valueOf(type));
        }
        return new ClassName(typeMeta.mainClsName());
    }

    private TypeInfo typeOfClassName(ClassName className) {
        TypeInfo result;
        int arrayRank = className.getArrayRank();
        if (arrayRank > 0) {
            result = this.typeOfClassName(new ClassName(className.getRootElement(), className.typeArgs));
        } else {
            TypeMeta typeMeta = this.basicRegistry.ofName(className.clsName);
            if (typeMeta == null) {
                throw new DsonCodecException("typeMeta absent, className: " + String.valueOf(className));
            }
            result = typeMeta.typeInfo;
            int typeArgsCount = className.typeArgs.size();
            if (typeArgsCount > 0) {
                TypeInfo[] typeArgs = new TypeInfo[typeArgsCount];
                for (int index = 0; index < typeArgsCount; ++index) {
                    typeArgs[index] = this.typeOfClassName(className.typeArgs.get(index));
                }
                result = TypeInfo.of(result.rawType, typeArgs);
            }
        }
        if (arrayRank > 0) {
            result = result.makeArrayType(arrayRank);
        }
        return result;
    }
}

