/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.codecs;

import cn.wjybxx.dson.text.INumberStyle;
import cn.wjybxx.dson.text.NumberStyle;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.annotations.DsonCodecScanIgnore;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@DsonCodecScanIgnore
public class Int32Codec
implements DsonCodec<Integer> {
    @Override
    @Nonnull
    public TypeInfo getEncoderType() {
        return TypeInfo.BOXED_INT;
    }

    @Override
    public boolean autoStartEnd() {
        return false;
    }

    @Override
    public void writeObject(DsonObjectWriter writer, Integer inst, TypeInfo declaredType, ObjectStyle style) {
        NumberStyle numberStyle = declaredType.rawType == Integer.class || declaredType.rawType == Integer.TYPE ? NumberStyle.SIMPLE : NumberStyle.TYPED;
        writer.writeInt(null, inst, (INumberStyle)numberStyle);
    }

    @Override
    public Integer readObject(DsonObjectReader reader, Supplier<? extends Integer> factory) {
        return reader.readInt(null);
    }
}

