/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec.fastutil;

import cn.wjybxx.dson.DsonType;
import cn.wjybxx.dson.text.ObjectStyle;
import cn.wjybxx.dsoncodec.DsonCodec;
import cn.wjybxx.dsoncodec.DsonConverterUtils;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.DsonObjectWriter;
import cn.wjybxx.dsoncodec.TypeInfo;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongImmutableList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class LongCollectionCodec
implements DsonCodec<LongCollection> {
    protected final TypeInfo typeInfo;
    protected final Supplier<? extends LongCollection> factory;
    private final boolean isSet;

    public LongCollectionCodec(TypeInfo typeInfo) {
        this(typeInfo, null);
    }

    public LongCollectionCodec(TypeInfo typeInfo, Supplier<? extends LongCollection> factory) {
        if (factory == null) {
            Class<?> rawType = typeInfo.rawType;
            factory = DsonConverterUtils.tryNoArgConstructorToSupplier(rawType);
        }
        this.typeInfo = typeInfo;
        this.factory = factory;
        this.isSet = LongSet.class.isAssignableFrom(typeInfo.rawType);
    }

    @Override
    @Nonnull
    public TypeInfo getEncoderType() {
        return this.typeInfo;
    }

    private LongCollection newCollection() {
        if (this.factory != null) {
            return this.factory.get();
        }
        return this.isSet ? new LongLinkedOpenHashSet() : new LongArrayList();
    }

    private static LongCollection toImmutable(LongCollection result) {
        if (result instanceof LongSet) {
            LongSet intSet = (LongSet)result;
            return LongSets.unmodifiable((LongSet)intSet);
        }
        return new LongImmutableList(result);
    }

    @Override
    public void writeObject(DsonObjectWriter writer, LongCollection inst, TypeInfo declaredType, ObjectStyle style) {
        LongIterator itr = inst.iterator();
        while (itr.hasNext()) {
            writer.writeLong(null, itr.nextLong());
        }
    }

    @Override
    public LongCollection readObject(DsonObjectReader reader, Supplier<? extends LongCollection> factory) {
        LongCollection result;
        LongCollection longCollection = result = factory != null ? factory.get() : this.newCollection();
        while (reader.readDsonType() != DsonType.END_OF_OBJECT) {
            result.add(reader.readLong(null));
        }
        return reader.options().readAsImmutable ? LongCollectionCodec.toImmutable(result) : result;
    }
}

