/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.base.ObjectUtils;
import cn.wjybxx.dson.DsonContextType;
import cn.wjybxx.dson.DsonReader;
import cn.wjybxx.dson.DsonType;
import cn.wjybxx.dson.DsonValue;
import cn.wjybxx.dson.Dsons;
import cn.wjybxx.dson.text.DsonTextReader;
import cn.wjybxx.dson.text.DsonTexts;
import cn.wjybxx.dson.text.DsonToken;
import cn.wjybxx.dson.types.Binary;
import cn.wjybxx.dson.types.ExtDateTime;
import cn.wjybxx.dson.types.ObjectLitePtr;
import cn.wjybxx.dson.types.ObjectPtr;
import cn.wjybxx.dson.types.Timestamp;
import cn.wjybxx.dsoncodec.ConverterOptions;
import cn.wjybxx.dsoncodec.DsonCodecException;
import cn.wjybxx.dsoncodec.DsonCodecHelper;
import cn.wjybxx.dsoncodec.DsonCodecImpl;
import cn.wjybxx.dsoncodec.DsonConverter;
import cn.wjybxx.dsoncodec.DsonConverterUtils;
import cn.wjybxx.dsoncodec.DsonObjectReader;
import cn.wjybxx.dsoncodec.TypeInfo;
import cn.wjybxx.dsoncodec.TypeMeta;
import java.time.LocalDateTime;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class AbstractObjectReader
implements DsonObjectReader {
    protected DsonConverter converter;
    protected DsonReader reader;

    AbstractObjectReader(DsonConverter converter, DsonReader reader) {
        this.converter = converter;
        this.reader = reader;
    }

    @Override
    public int readInt(String name) {
        return this.readName(name) ? DsonCodecHelper.readInt(this.reader, name) : 0;
    }

    @Override
    public long readLong(String name) {
        return this.readName(name) ? DsonCodecHelper.readLong(this.reader, name) : 0L;
    }

    @Override
    public float readFloat(String name) {
        return this.readName(name) ? DsonCodecHelper.readFloat(this.reader, name) : 0.0f;
    }

    @Override
    public double readDouble(String name) {
        return this.readName(name) ? DsonCodecHelper.readDouble(this.reader, name) : 0.0;
    }

    @Override
    public boolean readBoolean(String name) {
        return this.readName(name) && DsonCodecHelper.readBool(this.reader, name);
    }

    @Override
    public String readString(String name) {
        return this.readName(name) ? DsonCodecHelper.readString(this.reader, name) : null;
    }

    @Override
    public void readNull(String name) {
        if (this.readName(name)) {
            DsonCodecHelper.readNull(this.reader, name);
        }
    }

    @Override
    public Binary readBinary(String name) {
        return this.readName(name) ? DsonCodecHelper.readBinary(this.reader, name) : null;
    }

    @Override
    public ObjectPtr readPtr(String name) {
        return this.readName(name) ? DsonCodecHelper.readPtr(this.reader, name) : null;
    }

    @Override
    public ObjectLitePtr readLitePtr(String name) {
        return this.readName(name) ? DsonCodecHelper.readLitePtr(this.reader, name) : null;
    }

    @Override
    public LocalDateTime readDateTime(String name) {
        if (this.readName(name)) {
            ExtDateTime extDateTime = DsonCodecHelper.readDateTime(this.reader, name);
            return extDateTime == null ? null : extDateTime.toDateTime();
        }
        return null;
    }

    @Override
    public ExtDateTime readExtDateTime(String name) {
        return this.readName(name) ? DsonCodecHelper.readDateTime(this.reader, name) : null;
    }

    @Override
    public Timestamp readTimestamp(String name) {
        return this.readName(name) ? DsonCodecHelper.readTimestamp(this.reader, name) : null;
    }

    @Override
    @Nullable
    public <T> T readObject(String name, TypeInfo declaredType, Supplier<? extends T> factory) {
        Class<?> rawType = declaredType.rawType;
        if (!this.readName(name)) {
            return (T)DsonConverterUtils.getDefaultValue(rawType);
        }
        DsonReader reader = this.reader;
        DsonType dsonType = reader.getCurrentDsonType();
        if (dsonType == DsonType.NULL) {
            reader.readNull(name);
            return (T)DsonConverterUtils.getDefaultValue(rawType);
        }
        if (dsonType.isContainer()) {
            String clsName = this.readClsName(dsonType);
            DsonCodecImpl<?> codec = this.findObjectDecoder(declaredType, factory, clsName);
            if (codec == null) {
                throw DsonCodecException.incompatible(declaredType.rawType, clsName);
            }
            return codec.readObject(this, declaredType, factory);
        }
        DsonCodecImpl<?> codec = this.converter.codecRegistry().getDecoder(declaredType);
        if (codec != null) {
            return codec.readObject(this, declaredType, factory);
        }
        if (DsonValue.class.isAssignableFrom(rawType)) {
            return (T)rawType.cast(Dsons.readDsonValue((DsonReader)reader));
        }
        return (T)DsonCodecHelper.readDsonValueValue(reader, name);
    }

    @Override
    public ConverterOptions options() {
        return this.converter.options();
    }

    @Override
    public DsonContextType getContextType() {
        return this.reader.getContextType();
    }

    @Override
    public DsonType readDsonType() {
        return this.reader.isAtType() ? this.reader.readDsonType() : this.reader.getCurrentDsonType();
    }

    @Override
    public String readName() {
        return this.reader.isAtName() ? this.reader.readName() : this.reader.getCurrentName();
    }

    @Override
    @Nonnull
    public DsonType getCurrentDsonType() {
        return this.reader.getCurrentDsonType();
    }

    @Override
    public String getCurrentName() {
        return this.reader.getCurrentName();
    }

    @Override
    public void readStartObject() {
        if (this.reader.isAtType()) {
            this.reader.readDsonType();
        }
        this.reader.readStartObject();
    }

    @Override
    public void readEndObject() {
        this.reader.skipToEndOfObject();
        this.reader.readEndObject();
    }

    @Override
    public void readStartArray() {
        if (this.reader.isAtType()) {
            this.reader.readDsonType();
        }
        this.reader.readStartArray();
    }

    @Override
    public void readEndArray() {
        this.reader.skipToEndOfObject();
        this.reader.readEndArray();
    }

    @Override
    public void skipName() {
        this.reader.skipName();
    }

    @Override
    public void skipValue() {
        this.reader.skipValue();
    }

    @Override
    public void skipToEndOfObject() {
        this.reader.skipToEndOfObject();
    }

    @Override
    public byte[] readValueAsBytes(String name) {
        return this.readName(name) ? this.reader.readValueAsBytes(name) : null;
    }

    @Override
    public <T> T decodeKey(String keyString, TypeInfo keyTypeInfo) {
        Object result;
        Class<?> keyDeclared = keyTypeInfo.rawType;
        if (keyDeclared == String.class || keyDeclared == Object.class) {
            return (T)keyString;
        }
        if (keyDeclared == Integer.class) {
            return (T)Integer.valueOf(keyString);
        }
        if (keyDeclared == Long.class) {
            return (T)Long.valueOf(keyString);
        }
        DsonCodecImpl<?> codec = this.converter.codecRegistry().getDecoder(keyTypeInfo);
        if (codec == null || !codec.isEnumCodec()) {
            throw DsonCodecException.unsupportedKeyType(keyDeclared);
        }
        if (this.converter.options().writeEnumAsString) {
            result = codec.forName(keyString);
        } else {
            int number = Integer.parseInt(keyString);
            result = codec.forNumber(number);
        }
        if (result == null) {
            throw DsonCodecException.enumAbsent(keyDeclared, keyString);
        }
        return (T)result;
    }

    @Override
    public void setComponentType(DsonType dsonType) {
        DsonReader dsonReader = this.reader;
        if (dsonReader instanceof DsonTextReader) {
            DsonTextReader textReader = (DsonTextReader)dsonReader;
            DsonToken token = DsonTexts.clsNameTokenOfType((DsonType)dsonType);
            textReader.setCompClsNameToken(token);
        }
    }

    @Override
    public void close() {
        this.reader.close();
    }

    private String readClsName(DsonType dsonType) {
        String clsName;
        DsonReader reader = this.reader;
        if (reader.hasWaitingStartContext()) {
            return "";
        }
        if (dsonType == DsonType.OBJECT) {
            reader.readStartObject();
        } else {
            reader.readStartArray();
        }
        DsonType nextDsonType = reader.peekDsonType();
        if (nextDsonType == DsonType.HEADER) {
            reader.readDsonType();
            reader.readStartHeader();
            clsName = reader.readString("clsName");
            if (clsName.lastIndexOf(32) < 0) {
                clsName = clsName.intern();
            }
            reader.skipToEndOfObject();
            reader.readEndHeader();
        } else {
            clsName = "";
        }
        reader.backToWaitStart();
        return clsName;
    }

    private DsonCodecImpl<?> findObjectDecoder(TypeInfo declaredType, Supplier<?> factory, String clsName) {
        TypeMeta typeMeta;
        if (factory != null) {
            return this.converter.codecRegistry().getDecoder(declaredType);
        }
        if (!ObjectUtils.isBlank((String)clsName) && (typeMeta = this.converter.typeMetaRegistry().ofName(clsName)) != null && declaredType.rawType.isAssignableFrom(typeMeta.typeInfo.rawType)) {
            return this.converter.codecRegistry().getDecoder(typeMeta.typeInfo);
        }
        return this.converter.codecRegistry().getDecoder(declaredType);
    }
}

