/*
 * Decompiled with CFR 0.152.
 */
package cn.wjybxx.dsoncodec;

import cn.wjybxx.base.ArrayUtils;
import cn.wjybxx.base.mutable.MutableInt;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ClassName {
    private static final char SPLIT_CHAR = '`';
    public final String clsName;
    public final List<ClassName> typeArgs;
    private int _hashcode;

    public ClassName(String clsName) {
        this.clsName = clsName;
        this.typeArgs = List.of();
    }

    public ClassName(String clsName, List<ClassName> typeArgs) {
        this.clsName = Objects.requireNonNull(clsName, "clsName");
        this.typeArgs = typeArgs == null ? List.of() : List.copyOf(typeArgs);
    }

    public boolean isArray() {
        int idx = this.clsName.length() - 1;
        return this.clsName.charAt(idx) == ']' && this.clsName.charAt(idx - 1) == '[';
    }

    public int getArrayRank() {
        int r = 0;
        int idx = this.clsName.length() - 1;
        while (this.clsName.charAt(idx) == ']' && this.clsName.charAt(idx - 1) == '[') {
            idx -= 2;
            ++r;
        }
        return r;
    }

    public String getRootElement() {
        int idx = this.clsName.length() - 1;
        while (this.clsName.charAt(idx) == ']' && this.clsName.charAt(idx - 1) == '[') {
            idx -= 2;
        }
        return this.clsName.substring(0, idx + 1);
    }

    public boolean isGeneric() {
        int idx = this.clsName.length() - 1;
        return this.clsName.charAt(idx) != ']' && this.typeArgs.size() > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassName className = (ClassName)o;
        if (!this.clsName.equals(className.clsName)) {
            return false;
        }
        return this.typeArgs.equals(className.typeArgs);
    }

    public int hashCode() {
        int r = this._hashcode;
        if (r != 0) {
            return r;
        }
        r = this.clsName.hashCode();
        for (int i = 0; i < this.typeArgs.size(); ++i) {
            r = 31 * r + this.typeArgs.get(i).hashCode();
        }
        this._hashcode = r;
        return r;
    }

    public String toString() {
        return this.toString(null).toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        int arrayRank;
        if (sb == null) {
            sb = new StringBuilder(this.clsName.length());
        }
        if ((arrayRank = this.getArrayRank()) == 0) {
            sb.append(this.clsName);
        } else {
            sb.append(this.clsName, 0, this.clsName.length() - arrayRank * 2);
        }
        if (this.typeArgs.size() > 0) {
            sb.append('[');
            for (int i = 0; i < this.typeArgs.size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                this.typeArgs.get(i).toString(sb);
            }
            sb.append(']');
        }
        if (arrayRank > 0) {
            sb.append(ArrayUtils.arrayRankSymbol((int)arrayRank));
        }
        return sb;
    }

    public static ClassName parse(String fullClsName) {
        return ClassName.parse(fullClsName, 0, fullClsName.length() - 1);
    }

    private static ClassName parse(String fullClsName, int rawStartIndex, int rawEndIndex) {
        rawStartIndex = ClassName.skipLeading(fullClsName, rawStartIndex);
        rawEndIndex = ClassName.skipTrailing(fullClsName, rawEndIndex);
        int arrayRank = 0;
        while (fullClsName.charAt(rawEndIndex) == ']' && fullClsName.charAt(rawEndIndex - 1) == '[') {
            rawEndIndex -= 2;
            ++arrayRank;
        }
        int typeArgStartIdx = fullClsName.indexOf(91, rawStartIndex, rawEndIndex + 1);
        if (typeArgStartIdx > 0) {
            String typeArg;
            int typeArgEndIdx = fullClsName.lastIndexOf(93, rawEndIndex);
            if (typeArgEndIdx < 0 || typeArgStartIdx + 1 >= typeArgEndIdx) {
                throw new IllegalArgumentException("bad fullClsName : " + fullClsName);
            }
            int clsNameEndIndex = typeArgStartIdx - 1;
            clsNameEndIndex = ClassName.skipTrailing(fullClsName, clsNameEndIndex);
            Object clsName = fullClsName.substring(rawStartIndex, clsNameEndIndex + 1);
            if (arrayRank > 0) {
                clsName = (String)clsName + ArrayUtils.arrayRankSymbol((int)arrayRank);
            }
            ArrayList<ClassName> typeArgs = new ArrayList<ClassName>(2);
            MutableInt eleStartIdx = new MutableInt(typeArgStartIdx + 1);
            while (eleStartIdx.getValue() > 0 && (typeArg = ClassName.scanNextTypeArg(fullClsName, eleStartIdx.getValue(), typeArgEndIdx - 1, eleStartIdx)) != null) {
                if (typeArg.indexOf(91) > 0) {
                    typeArgs.add(ClassName.parse(typeArg, 0, typeArg.length() - 1));
                    continue;
                }
                typeArgs.add(new ClassName(typeArg, null));
            }
            return new ClassName((String)clsName, typeArgs);
        }
        return new ClassName(fullClsName, null);
    }

    private static String scanNextTypeArg(String typeArgs, int startIndex, int endIndex, MutableInt nextStartIndex) {
        if ((startIndex = ClassName.skipLeading(typeArgs, startIndex)) > (endIndex = ClassName.skipTrailing(typeArgs, endIndex))) {
            nextStartIndex.setValue(-1);
            return null;
        }
        int stackDepth = 0;
        for (int index = startIndex; index <= endIndex; ++index) {
            char c = typeArgs.charAt(index);
            if (c == ',' && stackDepth == 0) {
                nextStartIndex.setValue(index + 1);
                index = ClassName.skipTrailing(typeArgs, index - 1);
                return typeArgs.substring(startIndex, index + 1);
            }
            if (c == '[') {
                ++stackDepth;
            } else if (c == ']') {
                --stackDepth;
            }
            if (index != endIndex) continue;
            assert (stackDepth == 0);
            nextStartIndex.setValue(-1);
            index = ClassName.skipTrailing(typeArgs, index);
            return typeArgs.substring(startIndex, index + 1);
        }
        throw new IllegalArgumentException("bad typeArgs: " + typeArgs);
    }

    private static int skipLeading(String str, int index) {
        while (Character.isWhitespace(str.charAt(index))) {
            ++index;
        }
        return index;
    }

    private static int skipTrailing(String str, int index) {
        while (Character.isWhitespace(str.charAt(index))) {
            --index;
        }
        return index;
    }
}

